/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.fabric.impl.biome.TheEndBiomeData;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3541;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_6908;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.generator.BCLBiomeSource;
import org.betterx.bclib.api.v2.generator.BiomePicker;
import org.betterx.bclib.api.v2.generator.GeneratorOptions;
import org.betterx.bclib.api.v2.generator.map.hex.HexBiomeMap;
import org.betterx.bclib.api.v2.generator.map.square.SquareBiomeMap;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.config.ConfigKeeper;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.interfaces.BiomeMap;
import org.betterx.bclib.interfaces.TheEndBiomeDataAccessor;
import org.betterx.bclib.noise.OpenSimplexNoise;

public class BCLibEndBiomeSource
extends BCLBiomeSource {
    private static final OpenSimplexNoise SMALL_NOISE = new OpenSimplexNoise(8324L);
    public static Codec<BCLibEndBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6903.method_40419((class_5321)class_2378.field_25114).forGetter(theEndBiomeSource -> theEndBiomeSource.biomeRegistry), (App)Codec.LONG.fieldOf("seed").stable().forGetter(source -> source.currentSeed), (App)Codec.INT.optionalFieldOf("version").stable().forGetter(source -> Optional.of(source.biomeSourceVersion))).apply((Applicative)instance, instance.stable(BCLibEndBiomeSource::new)));
    private final class_6880<class_1959> centerBiome;
    private final class_6880<class_1959> barrens;
    private final Point pos;
    private final Function<Point, Boolean> endLandFunction;
    private class_3541 noise;
    private BiomeMap mapLand;
    private BiomeMap mapVoid;
    private final BiomePicker endLandBiomePicker;
    private final BiomePicker endVoidBiomePicker;

    public BCLibEndBiomeSource(class_2378<class_1959> biomeRegistry, long seed, Optional<Integer> version) {
        this(biomeRegistry, seed, version, true);
    }

    public BCLibEndBiomeSource(class_2378<class_1959> biomeRegistry, Optional<Integer> version) {
        this(biomeRegistry, 0L, version, false);
    }

    private BCLibEndBiomeSource(class_2378<class_1959> biomeRegistry, long seed, Optional<Integer> version, boolean initMaps) {
        this(biomeRegistry, BCLibEndBiomeSource.getBiomes(biomeRegistry), seed, version, initMaps);
    }

    private BCLibEndBiomeSource(class_2378<class_1959> biomeRegistry, List<class_6880<class_1959>> list, long seed, Optional<Integer> version, boolean initMaps) {
        super(biomeRegistry, list, seed, version);
        this.endLandBiomePicker = new BiomePicker(biomeRegistry);
        this.endVoidBiomePicker = new BiomePicker(biomeRegistry);
        List includeVoid = (List)Configs.BIOMES_CONFIG.getEntry("force_include", "end_void_biomes", ConfigKeeper.StringArrayEntry.class).getValue();
        List includeLand = (List)Configs.BIOMES_CONFIG.getEntry("force_include", "end_land_biomes", ConfigKeeper.StringArrayEntry.class).getValue();
        this.method_28443().forEach(biome -> {
            class_2960 key = ((class_5321)biome.method_40230().orElseThrow()).method_29177();
            String group = key.method_12836() + "." + key.method_12832();
            if (!BiomeAPI.hasBiome(key)) {
                BCLBiome bclBiome = new BCLBiome(key, (class_1959)biome.comp_349());
                if (includeVoid.contains(key.toString())) {
                    this.endVoidBiomePicker.addBiome(bclBiome);
                } else {
                    this.endLandBiomePicker.addBiome(bclBiome);
                }
            } else {
                BCLBiome bclBiome = BiomeAPI.getBiome(key);
                if (bclBiome != BiomeAPI.EMPTY_BIOME && bclBiome.getParentBiome() == null) {
                    if (BiomeAPI.wasRegisteredAsEndVoidBiome(key) || includeVoid.contains(key.toString())) {
                        this.endVoidBiomePicker.addBiome(bclBiome);
                    } else if (BiomeAPI.wasRegisteredAsEndLandBiome(key) || includeLand.contains(key.toString())) {
                        this.endLandBiomePicker.addBiome(bclBiome);
                    }
                }
            }
        });
        this.endLandBiomePicker.rebuild();
        this.endVoidBiomePicker.rebuild();
        this.centerBiome = biomeRegistry.method_44298(class_1972.field_9411);
        this.barrens = biomeRegistry.method_44298(class_1972.field_9465);
        this.endLandFunction = GeneratorOptions.getEndLandFunction();
        this.pos = new Point();
        if (initMaps) {
            this.initMap(seed);
        }
    }

    @Override
    protected BCLBiomeSource cloneForDatapack(Set<class_6880<class_1959>> datapackBiomes) {
        datapackBiomes.addAll(BCLibEndBiomeSource.getBclBiomes((class_2378<class_1959>)this.biomeRegistry));
        return new BCLibEndBiomeSource((class_2378<class_1959>)this.biomeRegistry, datapackBiomes.stream().toList(), this.currentSeed, Optional.of(this.biomeSourceVersion), true);
    }

    private static List<class_6880<class_1959>> getBclBiomes(class_2378<class_1959> biomeRegistry) {
        List include = (List)Configs.BIOMES_CONFIG.getEntry("force_include", "end_land_biomes", ConfigKeeper.StringArrayEntry.class).getValue();
        include.addAll((Collection)Configs.BIOMES_CONFIG.getEntry("force_include", "end_void_biomes", ConfigKeeper.StringArrayEntry.class).getValue());
        TheEndBiomeData.Overrides overrides = TheEndBiomeData.createOverrides(biomeRegistry);
        if (overrides instanceof TheEndBiomeDataAccessor) {
            TheEndBiomeDataAccessor acc = (TheEndBiomeDataAccessor)overrides;
            return BCLibEndBiomeSource.getBiomes(biomeRegistry, new ArrayList<String>(0), include, (biome, location) -> BCLibEndBiomeSource.isValidNonVanillaEndBiome((class_6880<class_1959>)biome, location) || acc.bcl_isNonVanillaAndCanGenerateInEnd((class_5321<class_1959>)((class_5321)biome.method_40230().orElseThrow())));
        }
        return BCLibEndBiomeSource.getBiomes(biomeRegistry, new ArrayList<String>(0), include, BCLibEndBiomeSource::isValidNonVanillaEndBiome);
    }

    private static List<class_6880<class_1959>> getBiomes(class_2378<class_1959> biomeRegistry) {
        List include = (List)Configs.BIOMES_CONFIG.getEntry("force_include", "end_land_biomes", ConfigKeeper.StringArrayEntry.class).getValue();
        include.addAll((Collection)Configs.BIOMES_CONFIG.getEntry("force_include", "end_void_biomes", ConfigKeeper.StringArrayEntry.class).getValue());
        TheEndBiomeData.Overrides overrides = TheEndBiomeData.createOverrides(biomeRegistry);
        if (overrides instanceof TheEndBiomeDataAccessor) {
            TheEndBiomeDataAccessor acc = (TheEndBiomeDataAccessor)overrides;
            return BCLibEndBiomeSource.getBiomes(biomeRegistry, new ArrayList<String>(0), include, (biome, location) -> BCLibEndBiomeSource.isValidEndBiome((class_6880<class_1959>)biome, location) || acc.bcl_canGenerateInEnd((class_5321<class_1959>)((class_5321)biome.method_40230().orElseThrow())));
        }
        return BCLibEndBiomeSource.getBiomes(biomeRegistry, new ArrayList<String>(0), include, BCLibEndBiomeSource::isValidEndBiome);
    }

    private static boolean isValidEndBiome(class_6880<class_1959> biome, class_2960 location) {
        return biome.method_40220(class_6908.field_37394) || BiomeAPI.wasRegisteredAsEndBiome(location);
    }

    private static boolean isValidNonVanillaEndBiome(class_6880<class_1959> biome, class_2960 location) {
        return biome.method_40220(class_6908.field_37394) || BiomeAPI.wasRegisteredAs(location, BiomeAPI.BiomeType.BCL_END_LAND) || BiomeAPI.wasRegisteredAs(location, BiomeAPI.BiomeType.BCL_END_VOID);
    }

    public static float getLegacyHeightValue(class_3541 simplexNoise, int i, int j) {
        int k = i / 2;
        int l = j / 2;
        int m = i % 2;
        int n = j % 2;
        float f = 100.0f - class_3532.method_15355((float)(i * i + j * j)) * 8.0f;
        f = class_3532.method_15363((float)f, (float)-100.0f, (float)80.0f);
        for (int o = -12; o <= 12; ++o) {
            for (int p = -12; p <= 12; ++p) {
                long q = k + o;
                long r = l + p;
                if (q * q + r * r <= 4096L || !(simplexNoise.method_15433((double)q, (double)r) < (double)-0.9f)) continue;
                float g = (class_3532.method_15379((float)q) * 3439.0f + class_3532.method_15379((float)r) * 147.0f) % 13.0f + 9.0f;
                float h = m - o * 2;
                float s = n - p * 2;
                float t = 100.0f - class_3532.method_15355((float)(h * h + s * s)) * g;
                t = class_3532.method_15363((float)t, (float)-100.0f, (float)80.0f);
                f = Math.max(f, t);
            }
        }
        return f;
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_2378.field_25096, (class_2960)BCLib.makeID("end_biome_source"), CODEC);
    }

    @Override
    protected void onInitMap(long seed) {
        if (this.biomeSourceVersion != BIOME_SOURCE_VERSION_HEX) {
            this.mapLand = new SquareBiomeMap(seed, GeneratorOptions.getBiomeSizeEndLand(), this.endLandBiomePicker);
            this.mapVoid = new SquareBiomeMap(seed, GeneratorOptions.getBiomeSizeEndVoid(), this.endVoidBiomePicker);
        } else {
            this.mapLand = new HexBiomeMap(seed, GeneratorOptions.getBiomeSizeEndLand(), this.endLandBiomePicker);
            this.mapVoid = new HexBiomeMap(seed, GeneratorOptions.getBiomeSizeEndVoid(), this.endVoidBiomePicker);
        }
        class_2919 chunkRandom = new class_2919((class_5819)new class_5820(seed));
        chunkRandom.method_33650(17292);
        this.noise = new class_3541((class_5819)chunkRandom);
    }

    public class_6880<class_1959> method_38109(int biomeX, int biomeY, int biomeZ, class_6544.class_6552 sampler) {
        if (this.mapLand == null || this.mapVoid == null) {
            return (class_6880)this.method_28443().stream().findFirst().get();
        }
        long posX = biomeX << 2;
        long posZ = biomeZ << 2;
        long farEndBiomes = GeneratorOptions.getFarEndBiomes();
        long dist = posX * posX + posZ * posZ;
        if ((biomeX & 0x3F) == 0 && (biomeZ & 0x3F) == 0) {
            this.mapLand.clearCache();
            this.mapVoid.clearCache();
        }
        if (this.endLandFunction == null) {
            if (dist <= farEndBiomes) {
                return this.centerBiome;
            }
            float height = BCLibEndBiomeSource.getLegacyHeightValue(this.noise, (biomeX >> 1) + 1, (biomeZ >> 1) + 1) + (float)SMALL_NOISE.eval(biomeX, biomeZ) * 5.0f;
            if (height > -20.0f && height < -5.0f) {
                return this.barrens;
            }
            if (height < -10.0f) {
                return this.mapVoid.getBiome((double)((double)posX), (double)((double)(biomeY << 2)), (double)((double)posZ)).biome;
            }
            return this.mapLand.getBiome((double)((double)posX), (double)((double)(biomeY << 2)), (double)((double)posZ)).biome;
        }
        this.pos.setLocation(biomeX, biomeZ);
        if (this.endLandFunction.apply(this.pos).booleanValue()) {
            return dist <= farEndBiomes ? this.centerBiome : this.mapLand.getBiome((double)((double)posX), (double)((double)(biomeY << 2)), (double)((double)posZ)).biome;
        }
        return dist <= farEndBiomes ? this.barrens : this.mapVoid.getBiome((double)((double)posX), (double)((double)(biomeY << 2)), (double)((double)posZ)).biome;
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    public String toString() {
        return "BCLib - The End BiomeSource (" + Integer.toHexString(((Object)((Object)this)).hashCode()) + ", version=" + this.biomeSourceVersion + ", seed=" + this.currentSeed + ", biomes=" + this.method_28443().size() + ")";
    }
}

