/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_3218;
import net.minecraft.class_3754;
import net.minecraft.class_5216;
import net.minecraft.class_5284;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5485;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7059;
import net.minecraft.class_7138;
import net.minecraft.class_7510;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.LevelGenUtil;
import org.betterx.bclib.api.v2.levelgen.biomes.InternalBiomeAPI;
import org.betterx.bclib.api.v2.levelgen.surface.SurfaceRuleUtil;
import org.betterx.bclib.interfaces.NoiseGeneratorSettingsProvider;
import org.betterx.bclib.interfaces.SurfaceRuleProvider;
import org.betterx.bclib.mixin.common.ChunkGeneratorAccessor;
import org.betterx.bclib.util.ModUtil;

public class BCLChunkGenerator
extends class_3754 {
    public static final Codec<BCLChunkGenerator> CODEC = RecordCodecBuilder.create(builderInstance -> {
        RecordCodecBuilder noiseGetter = class_6903.method_40419((class_5321)class_2378.field_35433).forGetter(BCLChunkGenerator::getNoises);
        RecordCodecBuilder biomeSourceCodec = class_1966.field_24713.fieldOf("biome_source").forGetter(generator -> generator.field_12761);
        RecordCodecBuilder settingsCodec = class_5284.field_24781.fieldOf("settings").forGetter(generator -> generator.field_24774);
        return class_3754.method_41042((RecordCodecBuilder.Instance)builderInstance).and(builderInstance.group((App)noiseGetter, (App)biomeSourceCodec, (App)settingsCodec)).apply((Applicative)builderInstance, builderInstance.stable(BCLChunkGenerator::new));
    });
    public final class_1966 initialBiomeSource;
    public static final Predicate<class_5321<class_5363>> NON_MANAGED_DIMENSIONS = dim -> dim != class_5363.field_25413 && dim != class_5363.field_25414;
    public static final Predicate<class_5321<class_5363>> ALL_DIMENSIONS = dim -> true;

    public BCLChunkGenerator(class_2378<class_7059> registry, class_2378<class_5216.class_5487> registry2, class_1966 biomeSource, class_6880<class_5284> holder) {
        super(registry, registry2, biomeSource, holder);
        this.initialBiomeSource = biomeSource;
        if (!"0.0.0".equals(ModUtil.getModVersion("terrablender"))) {
            BCLib.LOGGER.info("Make sure features are loaded from terrablender for " + biomeSource);
            this.rebuildFeaturesPerStep(biomeSource);
        }
        System.out.println("Chunk Generator: " + this + " (biomeSource: " + biomeSource + ")");
    }

    private void rebuildFeaturesPerStep(class_1966 biomeSource) {
        BCLChunkGenerator bCLChunkGenerator = this;
        if (bCLChunkGenerator instanceof ChunkGeneratorAccessor) {
            ChunkGeneratorAccessor acc = (ChunkGeneratorAccessor)((Object)bCLChunkGenerator);
            Function<class_6880, class_5485> function = hh -> ((class_1959)hh.comp_349()).method_30970();
            acc.bcl_setFeaturesPerStep((Supplier<List<class_7510.class_6827>>)Suppliers.memoize(() -> class_7510.method_44210(List.copyOf(biomeSource.method_28443()), hh -> ((class_5485)function.apply((class_6880)hh)).method_30983(), (boolean)true)));
        }
    }

    public void restoreInitialBiomeSource() {
        BCLChunkGenerator bCLChunkGenerator;
        if (this.initialBiomeSource != this.method_12098() && (bCLChunkGenerator = this) instanceof ChunkGeneratorAccessor) {
            ChunkGeneratorAccessor acc = (ChunkGeneratorAccessor)((Object)bCLChunkGenerator);
            class_1966 bs = LevelGenUtil.getWorldSettings().fixBiomeSource(this.initialBiomeSource, this.method_12098().method_28443());
            acc.bcl_setBiomeSource(bs);
            this.rebuildFeaturesPerStep(this.method_12098());
        }
    }

    public static void injectNoiseSettings(class_5285 settings) {
        BCLChunkGenerator.injectNoiseSettings(settings, ALL_DIMENSIONS);
    }

    public static void injectNoiseSettings(class_5321<class_5363> dimensionKey, class_2794 loadedChunkGenerator) {
        class_3754 nbc;
        Object object;
        BCLib.LOGGER.debug("Checking Noise Settings for " + dimensionKey.method_29177().toString());
        class_1966 loadedBiomeSource = loadedChunkGenerator.method_12098();
        InternalBiomeAPI.applyModifications(loadedBiomeSource, dimensionKey);
        if (loadedChunkGenerator instanceof class_3754 && (object = (nbc = (class_3754)loadedChunkGenerator).method_41541().comp_349()) instanceof SurfaceRuleProvider) {
            SurfaceRuleProvider srp = (SurfaceRuleProvider)object;
            srp.bclib_overwrite(SurfaceRuleUtil.addRulesForBiomeSource(((class_5284)nbc.method_41541().comp_349()).comp_478(), loadedBiomeSource));
        }
    }

    public static void injectNoiseSettings(class_5285 settings, Predicate<class_5321<class_5363>> filter) {
        List<class_5321<class_5363>> otherDimensions = settings.method_28609().method_29722().stream().map(e -> (class_5321)e.getKey()).filter(filter).toList();
        for (class_5321<class_5363> key : otherDimensions) {
            Optional stem = settings.method_28609().method_40264(key);
            if (!stem.isPresent()) continue;
            BCLChunkGenerator.injectNoiseSettings(key, ((class_5363)((class_6880)stem.get()).comp_349()).method_29571());
        }
    }

    protected Codec<? extends class_2794> method_28506() {
        return CODEC;
    }

    private class_2378<class_5216.class_5487> getNoises() {
        BCLChunkGenerator bCLChunkGenerator = this;
        if (bCLChunkGenerator instanceof NoiseGeneratorSettingsProvider) {
            NoiseGeneratorSettingsProvider p = (NoiseGeneratorSettingsProvider)((Object)bCLChunkGenerator);
            return p.bclib_getNoises();
        }
        return null;
    }

    public String toString() {
        return "BCLib - Chunk Generator (" + Integer.toHexString(((Object)((Object)this)).hashCode()) + ")";
    }

    public void appendFeaturesPerStep() {
    }

    public static class_7138 createRandomState(class_3218 level, class_2794 generator) {
        if (generator instanceof class_3754) {
            class_3754 noiseBasedChunkGenerator = (class_3754)generator;
            return class_7138.method_41556((class_5284)((class_5284)noiseBasedChunkGenerator.method_41541().comp_349()), (class_2378)level.method_30349().method_30530(class_2378.field_35433), (long)level.method_8412());
        }
        return class_7138.method_41557((class_5455)level.method_30349(), (class_5321)class_5284.field_26355, (long)level.method_8412());
    }

    public static void restoreInitialBiomeSources(class_5285 settings) {
        BCLChunkGenerator.restoreInitialBiomeSource(settings, (class_5321<class_5363>)class_5363.field_25413);
        BCLChunkGenerator.restoreInitialBiomeSource(settings, (class_5321<class_5363>)class_5363.field_25414);
    }

    public static void restoreInitialBiomeSource(class_5285 settings, class_5321<class_5363> dimension) {
        class_5363 loadedStem = (class_5363)settings.method_28609().method_31140(dimension);
        class_2794 class_27942 = loadedStem.method_29571();
        if (class_27942 instanceof BCLChunkGenerator) {
            BCLChunkGenerator cg = (BCLChunkGenerator)class_27942;
            cg.restoreInitialBiomeSource();
        }
    }
}

