/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator;

import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;

public abstract class BCLBiomeSource
extends class_1966 {
    public static int BIOME_SOURCE_VERSION_NONE = -1;
    public static int BIOME_SOURCE_VERSION_VANILLA = 0;
    public static int BIOME_SOURCE_VERSION_SQUARE = 17;
    public static int BIOME_SOURCE_VERSION_HEX;
    public static int DEFAULT_BIOME_SOURCE_VERSION;
    protected final class_2378<class_1959> biomeRegistry;
    protected long currentSeed;
    public final int biomeSourceVersion;

    private static List<class_6880<class_1959>> preInit(class_2378<class_1959> biomeRegistry, List<class_6880<class_1959>> biomes) {
        biomes = biomes.stream().sorted(Comparator.comparing(holder -> ((class_5321)holder.method_40230().get()).method_29177().toString())).toList();
        biomes.forEach(biome -> BiomeAPI.sortBiomeFeatures((class_6880<class_1959>)biome));
        return biomes;
    }

    protected BCLBiomeSource(class_2378<class_1959> biomeRegistry, List<class_6880<class_1959>> list, long seed, Optional<Integer> biomeSourceVersion) {
        super(BCLBiomeSource.preInit(biomeRegistry, list));
        this.biomeRegistry = biomeRegistry;
        this.biomeSourceVersion = biomeSourceVersion.orElse(DEFAULT_BIOME_SOURCE_VERSION);
        this.currentSeed = seed;
        System.out.println(this + " with Registry: " + biomeRegistry.getClass().getName() + "@" + Integer.toHexString(biomeRegistry.hashCode()));
    }

    public final void setSeed(long seed) {
        if (seed != this.currentSeed) {
            System.out.println(this + " set Seed: " + seed);
            this.currentSeed = seed;
            this.initMap(seed);
        }
    }

    protected final void initMap(long seed) {
        System.out.println(this + " updates Map");
        this.onInitMap(seed);
    }

    protected abstract void onInitMap(long var1);

    public static int getVersionBiomeSource(class_1966 biomeSource) {
        if (biomeSource == null) {
            return BIOME_SOURCE_VERSION_NONE;
        }
        if (biomeSource instanceof BCLBiomeSource) {
            BCLBiomeSource bcl = (BCLBiomeSource)biomeSource;
            return bcl.biomeSourceVersion;
        }
        return BIOME_SOURCE_VERSION_VANILLA;
    }

    public BCLBiomeSource createCopyForDatapack(Set<class_6880<class_1959>> datapackBiomes) {
        HashSet mutableSet = Sets.newHashSet();
        mutableSet.addAll(datapackBiomes);
        return this.cloneForDatapack(mutableSet);
    }

    protected abstract BCLBiomeSource cloneForDatapack(Set<class_6880<class_1959>> var1);

    protected static List<class_6880<class_1959>> getBiomes(class_2378<class_1959> biomeRegistry, List<String> exclude, List<String> include, ValidBiomePredicate test) {
        return biomeRegistry.method_10220().filter(biome -> biomeRegistry.method_29113(biome).isPresent()).map(biome -> biomeRegistry.method_44298((class_5321)biomeRegistry.method_29113(biome).get())).filter(biome -> {
            class_2960 location = ((class_5321)biome.method_40230().orElseThrow()).method_29177();
            String strLocation = location.toString();
            if (exclude.contains(strLocation)) {
                return false;
            }
            if (include.contains(strLocation)) {
                return true;
            }
            return test.isValid((class_6880<class_1959>)biome, location);
        }).toList();
    }

    static {
        DEFAULT_BIOME_SOURCE_VERSION = BIOME_SOURCE_VERSION_HEX = 18;
    }

    public static interface ValidBiomePredicate {
        public boolean isValid(class_6880<class_1959> var1, class_2960 var2);
    }
}

