/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange.handler.autosync;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.dataexchange.DataHandler;
import org.betterx.bclib.api.v2.dataexchange.DataHandlerDescriptor;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.AutoFileSyncEntry;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.AutoSync;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.AutoSyncID;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.RequestFiles;
import org.betterx.bclib.client.gui.screens.ConfirmRestartScreen;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.util.Pair;
import org.betterx.bclib.util.PathUtil;
import org.betterx.bclib.util.Triple;

public class SendFiles
extends DataHandler.FromServer {
    public static final DataHandlerDescriptor DESCRIPTOR = new DataHandlerDescriptor(new class_2960("bclib", "send_files"), SendFiles::new, false, false);
    protected List<AutoFileSyncEntry> files;
    private String token;
    private List<Pair<AutoFileSyncEntry, byte[]>> receivedFiles;

    public SendFiles() {
        this(null, "");
    }

    public SendFiles(List<AutoFileSyncEntry> files, String token) {
        super(SendFiles.DESCRIPTOR.IDENTIFIER);
        this.files = files;
        this.token = token;
    }

    @Override
    protected boolean prepareDataOnServer() {
        if (!Configs.SERVER_CONFIG.isAllowingAutoSync()) {
            BCLib.LOGGER.info("Auto-Sync was disabled on the server.");
            return false;
        }
        return true;
    }

    @Override
    protected void serializeDataOnServer(class_2540 buf) {
        List existingFiles = this.files.stream().filter(e -> e != null && e.fileName != null && e.fileName.exists()).collect(Collectors.toList());
        SendFiles.writeString(buf, this.token);
        buf.writeInt(existingFiles.size());
        BCLib.LOGGER.info("Sending " + existingFiles.size() + " Files to Client:");
        for (AutoFileSyncEntry entry : existingFiles) {
            int length = entry.serializeContent(buf);
            BCLib.LOGGER.info("\t- " + entry + " (" + PathUtil.humanReadableFileSize(length) + ")");
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void deserializeIncomingDataOnClient(class_2540 buf, PacketSender responseSender) {
        if (Configs.CLIENT_CONFIG.isAcceptingConfigs() || Configs.CLIENT_CONFIG.isAcceptingFiles() || Configs.CLIENT_CONFIG.isAcceptingMods()) {
            this.token = SendFiles.readString(buf);
            if (!this.token.equals(RequestFiles.currentToken)) {
                RequestFiles.newToken();
                BCLib.LOGGER.error("Unrequested File Transfer!");
                this.receivedFiles = new ArrayList<Pair<AutoFileSyncEntry, byte[]>>(0);
                return;
            }
            RequestFiles.newToken();
            int size = buf.readInt();
            this.receivedFiles = new ArrayList<Pair<AutoFileSyncEntry, byte[]>>(size);
            BCLib.LOGGER.info("Server sent " + size + " Files:");
            for (int i = 0; i < size; ++i) {
                Triple<AutoFileSyncEntry, byte[], AutoSyncID> p = AutoFileSyncEntry.deserializeContent(buf);
                if (p.first != null) {
                    String type;
                    if (((AutoFileSyncEntry)p.first).isConfigFile() && Configs.CLIENT_CONFIG.isAcceptingConfigs()) {
                        this.receivedFiles.add(p);
                        type = "Accepted Config ";
                    } else if (p.first instanceof AutoFileSyncEntry.ForModFileRequest && Configs.CLIENT_CONFIG.isAcceptingMods()) {
                        this.receivedFiles.add(p);
                        type = "Accepted Mod ";
                    } else if (Configs.CLIENT_CONFIG.isAcceptingFiles()) {
                        this.receivedFiles.add(p);
                        type = "Accepted File ";
                    } else {
                        type = "Ignoring ";
                    }
                    BCLib.LOGGER.info("\t- " + type + p.first + " (" + PathUtil.humanReadableFileSize(((byte[])p.second).length) + ")");
                    continue;
                }
                BCLib.LOGGER.error("   - Failed to receive File " + p.third + ", possibly sent from a Mod that is not installed on the client.");
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void runOnClientGameThread(class_310 client) {
        if (Configs.CLIENT_CONFIG.isAcceptingConfigs() || Configs.CLIENT_CONFIG.isAcceptingFiles() || Configs.CLIENT_CONFIG.isAcceptingMods()) {
            BCLib.LOGGER.info("Writing Files:");
            for (Pair<AutoFileSyncEntry, byte[]> entry : this.receivedFiles) {
                AutoFileSyncEntry e = (AutoFileSyncEntry)entry.first;
                byte[] data = (byte[])entry.second;
                SendFiles.writeSyncedFile(e, data, e.fileName);
            }
            this.showConfirmRestart(client);
        }
    }

    @Environment(value=EnvType.CLIENT)
    static void writeSyncedFile(AutoSyncID e, byte[] data, File fileName) {
        if (fileName != null && !PathUtil.isChildOf(PathUtil.GAME_FOLDER, fileName.toPath())) {
            BCLib.LOGGER.error(fileName + " is not within game folder " + PathUtil.GAME_FOLDER);
            return;
        }
        if (!PathUtil.MOD_BAK_FOLDER.toFile().exists()) {
            PathUtil.MOD_BAK_FOLDER.toFile().mkdirs();
        }
        Path path = fileName != null ? fileName.toPath() : null;
        Path removeAfter = null;
        if (e instanceof AutoFileSyncEntry.ForModFileRequest) {
            AutoFileSyncEntry.ForModFileRequest mase = (AutoFileSyncEntry.ForModFileRequest)e;
            removeAfter = path;
            int count = 0;
            String prefix = "_bclib_synced_";
            String name = "_bclib_synced_" + mase.modID + "_" + mase.version.replace(".", "_") + ".jar";
            do {
                path = path != null ? path.getParent().resolve(name) : PathUtil.MOD_FOLDER.resolve(name);
                name = "_bclib_synced_" + mase.modID + "_" + mase.version.replace(".", "_") + "__" + String.format("%03d", ++count) + ".jar";
            } while (path.toFile().exists());
        }
        BCLib.LOGGER.info("\t- Writing " + path + " (" + PathUtil.humanReadableFileSize(data.length) + ")");
        try {
            File parentFile = path.getParent().toFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            Files.write(path, data, new OpenOption[0]);
            if (removeAfter != null) {
                Path targetPath;
                String bakFileName = removeAfter.toFile().getName();
                Object collisionFreeName = bakFileName;
                int count = 0;
                do {
                    targetPath = PathUtil.MOD_BAK_FOLDER.resolve((String)collisionFreeName);
                    collisionFreeName = String.format("%03d", ++count) + "_" + bakFileName;
                } while (targetPath.toFile().exists());
                BCLib.LOGGER.info("\t- Moving " + removeAfter + " to " + targetPath);
                removeAfter.toFile().renameTo(targetPath.toFile());
            }
            AutoSync.didReceiveFile(e, fileName);
        }
        catch (IOException ioException) {
            BCLib.LOGGER.error("\t--> Writing " + fileName + " failed: " + ioException);
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected void showConfirmRestart(class_310 client) {
        client.method_1507((class_437)new ConfirmRestartScreen(() -> {
            class_310.method_1551().method_1507(null);
            client.method_1592();
        }));
    }
}

