/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange.handler.autosync;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.dataexchange.DataHandler;
import org.betterx.bclib.api.v2.dataexchange.DataHandlerDescriptor;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.AutoFileSyncEntry;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.AutoSyncID;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.SendFiles;
import org.betterx.bclib.config.Configs;

public class RequestFiles
extends DataHandler.FromClient {
    public static final DataHandlerDescriptor DESCRIPTOR = new DataHandlerDescriptor(new class_2960("bclib", "request_files"), RequestFiles::new, false, false);
    static String currentToken = "";
    protected List<AutoSyncID> files;
    String receivedToken = "";

    private RequestFiles() {
        this((List<AutoSyncID>)null);
    }

    public RequestFiles(List<AutoSyncID> files) {
        super(RequestFiles.DESCRIPTOR.IDENTIFIER);
        this.files = files;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected boolean prepareDataOnClient() {
        if (!Configs.CLIENT_CONFIG.isAllowingAutoSync()) {
            BCLib.LOGGER.info("Auto-Sync was disabled on the client.");
            return false;
        }
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void serializeDataOnClient(class_2540 buf) {
        RequestFiles.newToken();
        RequestFiles.writeString(buf, currentToken);
        buf.writeInt(this.files.size());
        for (AutoSyncID a : this.files) {
            a.serializeData(buf);
        }
    }

    @Override
    protected void deserializeIncomingDataOnServer(class_2540 buf, class_1657 player, PacketSender responseSender) {
        this.receivedToken = RequestFiles.readString(buf);
        int size = buf.readInt();
        this.files = new ArrayList<AutoSyncID>(size);
        BCLib.LOGGER.info("Client requested " + size + " Files:");
        for (int i = 0; i < size; ++i) {
            AutoSyncID asid = AutoSyncID.deserializeData(buf);
            this.files.add(asid);
            BCLib.LOGGER.info("\t- " + asid);
        }
    }

    @Override
    protected void runOnServerGameThread(MinecraftServer server, class_1657 player) {
        if (!Configs.SERVER_CONFIG.isAllowingAutoSync()) {
            BCLib.LOGGER.info("Auto-Sync was disabled on the server.");
            return;
        }
        List<AutoFileSyncEntry> syncEntries = this.files.stream().map(asid -> AutoFileSyncEntry.findMatching(asid)).filter(e -> e != null).collect(Collectors.toList());
        this.reply(new SendFiles(syncEntries, this.receivedToken), server);
    }

    public static void newToken() {
        currentToken = UUID.randomUUID().toString();
    }

    static {
        RequestFiles.newToken();
    }
}

