/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange.handler.autosync;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.dataexchange.DataHandler;
import org.betterx.bclib.api.v2.dataexchange.DataHandlerDescriptor;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.HelloClient;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.util.ModUtil;

public class HelloServer
extends DataHandler.FromClient {
    public static final DataHandlerDescriptor DESCRIPTOR = new DataHandlerDescriptor(new class_2960("bclib", "hello_server"), HelloServer::new, true, false);
    protected String bclibVersion = "0.0.0";

    public HelloServer() {
        super(HelloServer.DESCRIPTOR.IDENTIFIER);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected boolean prepareDataOnClient() {
        if (!Configs.CLIENT_CONFIG.isAllowingAutoSync()) {
            BCLib.LOGGER.info("Auto-Sync was disabled on the client.");
            return false;
        }
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void serializeDataOnClient(class_2540 buf) {
        BCLib.LOGGER.info("Sending hello to server.");
        buf.writeInt(ModUtil.convertModVersion(HelloClient.getBCLibVersion()));
    }

    @Override
    protected void deserializeIncomingDataOnServer(class_2540 buf, class_1657 player, PacketSender responseSender) {
        this.bclibVersion = ModUtil.convertModVersion(buf.readInt());
    }

    @Override
    protected void runOnServerGameThread(MinecraftServer server, class_1657 player) {
        if (!Configs.SERVER_CONFIG.isAllowingAutoSync()) {
            BCLib.LOGGER.info("Auto-Sync was disabled on the server.");
            return;
        }
        String localBclibVersion = HelloClient.getBCLibVersion();
        BCLib.LOGGER.info("Received Hello from Client. (server=" + localBclibVersion + ", client=" + this.bclibVersion + ")");
        if (!server.method_3860()) {
            BCLib.LOGGER.info("Auto-Sync is disabled for Singleplayer worlds.");
            return;
        }
        this.reply(new HelloClient(), server);
    }
}

