/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange;

import java.io.File;
import java.util.Objects;
import net.minecraft.class_2540;
import org.betterx.bclib.api.v2.dataexchange.DataHandler;
import org.betterx.bclib.api.v2.dataexchange.FileHash;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.AutoSync;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.AutoSyncID;

public class SyncFileHash
extends AutoSyncID {
    public final FileHash hash;
    static final AutoSync.NeedTransferPredicate NEED_TRANSFER = (clientHash, serverHash, content) -> !clientHash.equals(serverHash);

    SyncFileHash(String modID, File file, byte[] md5, int size, int value) {
        this(modID, file.getName(), md5, size, value);
    }

    SyncFileHash(String modID, String uniqueID, byte[] md5, int size, int value) {
        this(modID, uniqueID, new FileHash(md5, size, value));
    }

    SyncFileHash(String modID, File file, FileHash hash) {
        this(modID, file.getName(), hash);
    }

    SyncFileHash(String modID, String uniqueID, FileHash hash) {
        super(modID, uniqueID);
        this.hash = hash;
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.hash.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SyncFileHash)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SyncFileHash that = (SyncFileHash)o;
        return this.hash.equals(that.hash);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.hash);
    }

    public void serialize(class_2540 buf) {
        this.hash.serialize(buf);
        DataHandler.writeString(buf, this.modID);
        DataHandler.writeString(buf, this.uniqueID);
    }

    public static SyncFileHash deserialize(class_2540 buf) {
        FileHash hash = FileHash.deserialize(buf);
        String modID = DataHandler.readString(buf);
        String uniqueID = DataHandler.readString(buf);
        return new SyncFileHash(modID, uniqueID, hash);
    }

    public static SyncFileHash create(String modID, File file) {
        return SyncFileHash.create(modID, file, file.getName());
    }

    public static SyncFileHash create(String modID, File file, String uniqueID) {
        return new SyncFileHash(modID, uniqueID, FileHash.create(file));
    }
}

