/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.util.ModUtil;

public class WorldDataAPI {
    private static final Map<String, class_2487> TAGS = Maps.newHashMap();
    private static final List<String> MODS = Lists.newArrayList();
    private static final String TAG_CREATED = "create_version";
    private static final String TAG_MODIFIED = "modify_version";
    private static File dataDir;

    public static void load(File dataDir) {
        WorldDataAPI.dataDir = dataDir;
        ((Stream)MODS.stream().parallel()).forEach(modID -> {
            File file = new File(dataDir, modID + ".nbt");
            class_2487 root = new class_2487();
            if (file.exists()) {
                try {
                    root = class_2507.method_30613((File)file);
                }
                catch (IOException e) {
                    BCLib.LOGGER.error("World data loading failed", e);
                }
                TAGS.put((String)modID, root);
            } else {
                Optional optional = FabricLoader.getInstance().getModContainer(modID);
                if (optional.isPresent()) {
                    ModContainer modContainer = (ModContainer)optional.get();
                    if (BCLib.isDevEnvironment()) {
                        root.method_10582("version", "255.255.9999");
                    } else {
                        root.method_10582("version", modContainer.getMetadata().getVersion().toString());
                    }
                    TAGS.put((String)modID, root);
                    WorldDataAPI.saveFile(modID);
                }
            }
        });
    }

    public static void registerModCache(String modID) {
        if (!MODS.contains(modID)) {
            MODS.add(modID);
        }
    }

    public static class_2487 getRootTag(String modID) {
        class_2487 root = TAGS.get(modID);
        if (root == null) {
            root = new class_2487();
            root.method_10582(TAG_CREATED, ModUtil.getModVersion(modID));
            TAGS.put(modID, root);
        }
        return root;
    }

    public static boolean hasMod(String modID) {
        return MODS.contains(modID);
    }

    public static class_2487 getCompoundTag(String modID, String path) {
        String[] parts = path.split("\\.");
        class_2487 tag = WorldDataAPI.getRootTag(modID);
        for (String part : parts) {
            if (tag.method_10545(part)) {
                tag = tag.method_10562(part);
                continue;
            }
            class_2487 t = new class_2487();
            tag.method_10566(part, (class_2520)t);
            tag = t;
        }
        return tag;
    }

    public static void saveFile(String modID) {
        try {
            if (!dataDir.exists()) {
                dataDir.mkdirs();
            }
            class_2487 tag = WorldDataAPI.getRootTag(modID);
            tag.method_10582(TAG_MODIFIED, ModUtil.getModVersion(modID));
            File tempFile = new File(dataDir, modID + "_temp.nbt");
            class_2507.method_30614((class_2487)tag, (File)tempFile);
            File oldFile = new File(dataDir, modID + "_old.nbt");
            File dataFile = new File(dataDir, modID + ".nbt");
            class_156.method_27760((File)dataFile, (File)tempFile, (File)oldFile);
        }
        catch (IOException e) {
            BCLib.LOGGER.error("World data saving failed", e);
        }
    }

    public static String getModVersion(String modID) {
        return WorldDataAPI.getRootTag(modID).method_10558("version");
    }

    public static int getIntModVersion(String modID) {
        return ModUtil.convertModVersion(WorldDataAPI.getModVersion(modID));
    }
}

