/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_6862;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.biomes.InternalBiomeAPI;
import org.betterx.bclib.api.v2.tag.NamedMineableTags;
import org.betterx.bclib.api.v2.tag.TagAPI;
import org.betterx.bclib.blocks.BaseBarrelBlock;
import org.betterx.bclib.blocks.BaseChestBlock;
import org.betterx.bclib.blocks.BaseFurnaceBlock;
import org.betterx.bclib.blocks.BaseSignBlock;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.client.render.BaseChestBlockEntityRenderer;
import org.betterx.bclib.client.render.BaseSignBlockEntityRenderer;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.interfaces.PostInitable;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.interfaces.TagProvider;
import org.betterx.bclib.interfaces.tools.AddMineableAxe;
import org.betterx.bclib.interfaces.tools.AddMineableHammer;
import org.betterx.bclib.interfaces.tools.AddMineableHoe;
import org.betterx.bclib.interfaces.tools.AddMineablePickaxe;
import org.betterx.bclib.interfaces.tools.AddMineableShears;
import org.betterx.bclib.interfaces.tools.AddMineableShovel;
import org.betterx.bclib.interfaces.tools.AddMineableSword;
import org.betterx.bclib.interfaces.tools.PreventMineableAdd;
import org.betterx.bclib.registry.BaseBlockEntities;

public class PostInitAPI {
    private static List<Consumer<Boolean>> postInitFunctions = Lists.newArrayList();
    private static List<class_6862<class_2248>> blockTags = Lists.newArrayList();
    private static List<class_6862<class_1792>> itemTags = Lists.newArrayList();

    public static void register(Consumer<Boolean> function) {
        postInitFunctions.add(function);
    }

    public static void postInit(boolean isClient) {
        class_2378.field_11146.forEach(block -> {
            PostInitAPI.processBlockCommon(block);
            if (isClient) {
                PostInitAPI.processBlockClient(block);
            }
        });
        class_2378.field_11142.forEach(item -> PostInitAPI.processItemCommon(item));
        if (postInitFunctions != null) {
            postInitFunctions.forEach(function -> function.accept(isClient));
            postInitFunctions = null;
        }
        blockTags = null;
        itemTags = null;
        InternalBiomeAPI.loadFabricAPIBiomes();
        Configs.BIOMES_CONFIG.saveChanges();
    }

    @Environment(value=EnvType.CLIENT)
    private static void processBlockClient(class_2248 block) {
        if (block instanceof RenderLayerProvider) {
            BCLRenderLayer layer = ((RenderLayerProvider)block).getRenderLayer();
            if (layer == BCLRenderLayer.CUTOUT) {
                BlockRenderLayerMap.INSTANCE.putBlock(block, class_1921.method_23581());
            } else if (layer == BCLRenderLayer.TRANSLUCENT) {
                BlockRenderLayerMap.INSTANCE.putBlock(block, class_1921.method_23583());
            }
        }
        if (block instanceof BaseChestBlock) {
            BaseChestBlockEntityRenderer.registerRenderLayer(block);
        } else if (block instanceof BaseSignBlock) {
            BaseSignBlockEntityRenderer.registerRenderLayer(block);
        }
    }

    private static void processItemCommon(class_1792 item) {
        if (item instanceof TagProvider) {
            TagProvider provider = (TagProvider)item;
            try {
                provider.addTags(null, itemTags);
            }
            catch (NullPointerException ex) {
                BCLib.LOGGER.error(item + " probably tried to access blockTags.", ex);
            }
            itemTags.forEach(tag -> TagAPI.addItemTag((class_6862<class_1792>)tag, item));
            itemTags.clear();
        }
    }

    private static void processBlockCommon(class_2248 block) {
        if (block instanceof PostInitable) {
            ((PostInitable)block).postInit();
        }
        if (block instanceof BaseChestBlock) {
            BaseBlockEntities.CHEST.registerBlock(block);
        } else if (block instanceof BaseSignBlock) {
            BaseBlockEntities.SIGN.registerBlock(block);
        } else if (block instanceof BaseBarrelBlock) {
            BaseBlockEntities.BARREL.registerBlock(block);
        } else if (block instanceof BaseFurnaceBlock) {
            BaseBlockEntities.FURNACE.registerBlock(block);
        }
        if (!(block instanceof PreventMineableAdd)) {
            if (block instanceof AddMineableShears) {
                TagAPI.addBlockTags(block, NamedMineableTags.SHEARS);
            }
            if (block instanceof AddMineableAxe) {
                TagAPI.addBlockTags(block, NamedMineableTags.AXE);
            }
            if (block instanceof AddMineablePickaxe) {
                TagAPI.addBlockTags(block, NamedMineableTags.PICKAXE);
            }
            if (block instanceof AddMineableShovel) {
                TagAPI.addBlockTags(block, NamedMineableTags.SHOVEL);
            }
            if (block instanceof AddMineableHoe) {
                TagAPI.addBlockTags(block, NamedMineableTags.HOE);
            }
            if (block instanceof AddMineableSword) {
                TagAPI.addBlockTags(block, NamedMineableTags.SWORD);
            }
            if (block instanceof AddMineableHammer) {
                TagAPI.addBlockTags(block, NamedMineableTags.HAMMER);
            }
        }
        if (block instanceof TagProvider) {
            ((TagProvider)block).addTags(blockTags, itemTags);
            blockTags.forEach(tag -> TagAPI.addBlockTag((class_6862<class_2248>)tag, block));
            itemTags.forEach(tag -> TagAPI.addItemTag((class_6862<class_1792>)tag, new class_1935[]{block}));
            blockTags.clear();
            itemTags.clear();
        }
    }
}

