/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2520;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3949;
import net.minecraft.class_5268;
import net.minecraft.class_5285;
import net.minecraft.class_5292;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.server.MinecraftServer;
import org.betterx.bclib.api.v2.dataexchange.DataExchangeAPI;
import org.betterx.bclib.api.v2.datafixer.DataFixerAPI;
import org.betterx.bclib.api.v2.levelgen.LevelGenUtil;
import org.betterx.bclib.api.v2.levelgen.biomes.InternalBiomeAPI;
import org.betterx.bclib.mixin.common.RegistryOpsAccessor;

public class LifeCycleAPI {
    private static final List<LevelLoadBiomesCall> onLoadLevelBiomes = new ArrayList<LevelLoadBiomesCall>(2);
    private static final List<LevelLoadCall> onLoadLevel = new ArrayList<LevelLoadCall>(2);
    private static final List<BeforeLevelLoadCall> beforeLoadLevel = new ArrayList<BeforeLevelLoadCall>(2);

    private static void worldCreationStarted(class_5455 access) {
        InternalBiomeAPI.initRegistry(access);
    }

    public static void newWorldSetup(class_32.class_5143 levelStorageAccess, class_5285 settings) {
        DataExchangeAPI.prepareServerside();
        InternalBiomeAPI.prepareNewLevel();
        DataFixerAPI.createWorldData(levelStorageAccess, settings);
        LifeCycleAPI._runBeforeLevelLoad();
    }

    public static void newWorldSetup(String levelID, class_5285 worldGenSettings, class_32 levelSource) {
        DataExchangeAPI.prepareServerside();
        InternalBiomeAPI.prepareNewLevel();
        DataFixerAPI.createWorldData(levelSource, levelID, worldGenSettings);
        LifeCycleAPI._runBeforeLevelLoad();
    }

    public static void newWorldSetup(class_32.class_5143 levelStorageAccess) {
        InternalBiomeAPI.prepareNewLevel();
        DataFixerAPI.fixData(levelStorageAccess, false, didFix -> {});
        LifeCycleAPI._runBeforeLevelLoad();
    }

    public static class_5285 worldLoadStarted(class_5285 settings, Optional<class_6903<class_2520>> registryOps) {
        Object var3_2 = registryOps.orElse(null);
        if (var3_2 instanceof RegistryOpsAccessor) {
            RegistryOpsAccessor acc = var3_2;
            InternalBiomeAPI.initRegistry(acc.bcl_getRegistryAccess());
        }
        settings = LevelGenUtil.fixSettingsInCurrentWorld(registryOps, settings);
        return settings;
    }

    public static void worldCreationStarted(class_6903<class_2520> regOps) {
        if (regOps instanceof RegistryOpsAccessor) {
            RegistryOpsAccessor acc = (RegistryOpsAccessor)regOps;
            LifeCycleAPI.worldCreationStarted(acc.bcl_getRegistryAccess());
        }
    }

    public static void worldCreationStarted(Optional<class_32.class_5143> levelStorageAccess, class_5292 worldGenSettingsComponent) {
        LifeCycleAPI.worldCreationStarted(worldGenSettingsComponent.method_29700());
        if (levelStorageAccess.isPresent()) {
            LifeCycleAPI.newWorldSetup(levelStorageAccess.get(), worldGenSettingsComponent.method_41884().comp_616());
        }
    }

    public static void beforeLevelLoad(BeforeLevelLoadCall call) {
        beforeLoadLevel.add(call);
    }

    public static void onLevelLoad(LevelLoadBiomesCall call) {
        onLoadLevelBiomes.add(call);
    }

    public static void onLevelLoad(LevelLoadCall call) {
        onLoadLevel.add(call);
    }

    public static void _runBeforeLevelLoad() {
        beforeLoadLevel.forEach(c -> c.beforeLoad());
    }

    public static void _runLevelLoad(class_3218 world, MinecraftServer minecraftServer, Executor executor, class_32.class_5143 levelStorageAccess, class_5268 serverLevelData, class_5321<class_1937> resourceKey, class_3949 chunkProgressListener, boolean bl, long l, List<class_5304> list, boolean bl2) {
        onLoadLevel.forEach(c -> c.onLoad(world, minecraftServer, executor, levelStorageAccess, serverLevelData, resourceKey, chunkProgressListener, bl, l, list, bl2));
        long seed = world.method_8412();
        class_2378 biomeRegistry = world.method_30349().method_30530(class_2378.field_25114);
        onLoadLevelBiomes.forEach(c -> c.onLoad(world, seed, (class_2378<class_1959>)biomeRegistry));
    }

    public static interface LevelLoadBiomesCall {
        public void onLoad(class_3218 var1, long var2, class_2378<class_1959> var4);
    }

    public static interface LevelLoadCall {
        public void onLoad(class_3218 var1, MinecraftServer var2, Executor var3, class_32.class_5143 var4, class_5268 var5, class_5321<class_1937> var6, class_3949 var7, boolean var8, long var9, List<class_5304> var11, boolean var12);
    }

    public static interface BeforeLevelLoadCall {
        public void beforeLoad();
    }
}

