/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2794;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.datafixer.ForcedLevelPatch;
import org.betterx.bclib.api.v2.datafixer.MigrationProfile;
import org.betterx.bclib.api.v2.levelgen.LevelGenUtil;
import org.betterx.bclib.util.MHelper;

final class BiomeSourcePatch
extends ForcedLevelPatch {
    private static final String NETHER_BIOME_SOURCE = "bclib:nether_biome_source";
    private static final String END_BIOME_SOURCE = "bclib:end_biome_source";
    private static final String MC_NETHER = "minecraft:the_nether";
    private static final String MC_END = "minecraft:the_end";

    protected BiomeSourcePatch() {
        super("bclib", "1.2.1");
    }

    @Override
    protected Boolean runLevelDatPatch(class_2487 root, MigrationProfile profile) {
        LevelGenUtil.migrateGeneratorSettings();
        class_2487 worldGenSettings = root.method_10562("Data").method_10562("WorldGenSettings");
        class_2487 dimensions = worldGenSettings.method_10562("dimensions");
        class_5455.class_6893 registryAccess = class_5455.method_40314();
        class_6903 registryOps = class_6903.method_40414((DynamicOps)class_2509.field_11560, (class_5455)registryAccess);
        boolean result = false;
        result |= this.checkDimension(worldGenSettings, dimensions, (class_5455)registryAccess, (class_6903<class_2520>)registryOps, (class_5321<class_5363>)class_5363.field_25413);
        System.out.println("Dimensions:" + dimensions);
        return result |= this.checkDimension(worldGenSettings, dimensions, (class_5455)registryAccess, (class_6903<class_2520>)registryOps, (class_5321<class_5363>)class_5363.field_25414);
    }

    private boolean checkDimension(class_2487 worldGenSettings, class_2487 dimensions, class_5455 registryAccess, class_6903<class_2520> registryOps, class_5321<class_5363> dimensionKey) {
        int targetVersion;
        long seed = worldGenSettings.method_10545("seed") ? worldGenSettings.method_10537("seed") : MHelper.RANDOM.nextLong();
        boolean genStructures = !worldGenSettings.method_10545("generate_features") || worldGenSettings.method_10577("generate_features");
        boolean genBonusChest = worldGenSettings.method_10545("bonus_chest") && worldGenSettings.method_10577("bonus_chest");
        boolean result = false;
        class_2487 dimensionTag = dimensions.method_10562(dimensionKey.method_29177().toString());
        Optional oWorldGen = class_5285.field_24826.parse(new Dynamic(registryOps, (Object)worldGenSettings)).result();
        Optional oLevelStem = class_5363.field_25411.parse(new Dynamic(registryOps, (Object)dimensionTag)).resultOrPartial(BCLib.LOGGER::error);
        Optional<class_2794> netherGenerator = oLevelStem.map(l -> l.method_29571());
        int biomeSourceVersion = LevelGenUtil.getBiomeVersionForGenerator(netherGenerator.orElse(null));
        if (biomeSourceVersion != (targetVersion = LevelGenUtil.getBiomeVersionForCurrentWorld(dimensionKey))) {
            Optional<class_6880<class_5363>> refLevelStem = LevelGenUtil.referenceStemForVersion(dimensionKey, targetVersion, registryAccess, oWorldGen.map(g -> g.method_28028()).orElse(seed), oWorldGen.map(g -> g.method_28029()).orElse(genStructures), oWorldGen.map(g -> g.method_28030()).orElse(genBonusChest));
            BCLib.LOGGER.warning("The world uses the BiomeSource Version " + biomeSourceVersion + " but should have " + targetVersion + ".", new Object[0]);
            BCLib.LOGGER.warning("Dimension: " + dimensionKey, new Object[0]);
            BCLib.LOGGER.warning("Found: " + netherGenerator, new Object[0]);
            BCLib.LOGGER.warning("Should: " + refLevelStem.map(l -> ((class_5363)l.comp_349()).method_29571()), new Object[0]);
            if (refLevelStem.isPresent()) {
                class_6880<class_5363> levelStem = refLevelStem.get();
                BCLib.LOGGER.warning("Repairing level.dat in order to ensure world continuity.", new Object[0]);
                Codec codec = class_5363.field_25411.orElse((Object)((class_5363)levelStem.comp_349()));
                DataResult encodeResult = codec.encodeStart(registryOps, (Object)((class_5363)levelStem.comp_349()));
                if (encodeResult.result().isPresent()) {
                    dimensions.method_10566(dimensionKey.method_29177().toString(), (class_2520)encodeResult.result().get());
                    result = true;
                } else {
                    BCLib.LOGGER.error("Unable to encode '" + dimensionKey + "' generator for level.dat.");
                }
            } else {
                BCLib.LOGGER.error("Unable to update '" + dimensionKey + "' generator in level.dat.");
            }
        }
        return result;
    }

    private boolean isBCLibEntry(class_2487 dimRoot) {
        String type = dimRoot.method_10562("generator").method_10562("biome_source").method_10558("type");
        if (type.isEmpty() || type.length() < 5) {
            return false;
        }
        return type.startsWith("bclib");
    }

    public static class_2487 makeNetherGenerator(long seed) {
        class_2487 generator = new class_2487();
        generator.method_10582("type", "minecraft:noise");
        generator.method_10582("settings", "minecraft:nether");
        generator.method_10544("seed", seed);
        class_2487 biomeSource = new class_2487();
        biomeSource.method_10582("type", NETHER_BIOME_SOURCE);
        biomeSource.method_10544("seed", seed);
        generator.method_10566("biome_source", (class_2520)biomeSource);
        return generator;
    }

    public static class_2487 makeEndGenerator(long seed) {
        class_2487 generator = new class_2487();
        generator.method_10582("type", "minecraft:noise");
        generator.method_10582("settings", "minecraft:end");
        generator.method_10544("seed", seed);
        class_2487 biomeSource = new class_2487();
        biomeSource.method_10582("type", END_BIOME_SOURCE);
        biomeSource.method_10544("seed", seed);
        generator.method_10566("biome_source", (class_2520)biomeSource);
        return generator;
    }
}

