/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.betterx.bclib.BCLibPatch;
import org.betterx.bclib.api.v2.WorldDataAPI;
import org.betterx.bclib.api.v2.dataexchange.DataExchangeAPI;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.Chunker;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.HelloClient;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.HelloServer;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.RequestFiles;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.SendFiles;
import org.betterx.bclib.api.v2.generator.BCLibEndBiomeSource;
import org.betterx.bclib.api.v2.generator.BCLibNetherBiomeSource;
import org.betterx.bclib.api.v2.generator.GeneratorOptions;
import org.betterx.bclib.api.v2.levelgen.features.blockpredicates.Types;
import org.betterx.bclib.api.v2.levelgen.features.placement.PlacementModifiers;
import org.betterx.bclib.api.v2.levelgen.structures.TemplatePiece;
import org.betterx.bclib.api.v2.levelgen.surface.rules.Conditions;
import org.betterx.bclib.api.v2.tag.TagAPI;
import org.betterx.bclib.commands.CommandRegistry;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.presets.worldgen.BCLWorldPresets;
import org.betterx.bclib.recipes.AnvilRecipe;
import org.betterx.bclib.recipes.CraftingRecipes;
import org.betterx.bclib.registry.BaseBlockEntities;
import org.betterx.bclib.registry.BaseRegistry;
import org.betterx.bclib.util.Logger;

public class BCLib
implements ModInitializer {
    public static final String MOD_ID = "bclib";
    public static final String TOGETHER_WORLDS = "worlds_together";
    public static final Logger LOGGER = new Logger("bclib");

    public void onInitialize() {
        Types.ensureStaticInitialization();
        BaseRegistry.register();
        GeneratorOptions.init();
        BaseBlockEntities.register();
        BCLibEndBiomeSource.register();
        BCLibNetherBiomeSource.register();
        TagAPI.init();
        CraftingRecipes.init();
        WorldDataAPI.registerModCache(MOD_ID);
        WorldDataAPI.registerModCache(TOGETHER_WORLDS);
        DataExchangeAPI.registerMod(MOD_ID);
        BCLWorldPresets.registerPresets();
        AnvilRecipe.register();
        Conditions.registerAll();
        CommandRegistry.register();
        DataExchangeAPI.registerDescriptors(List.of(HelloClient.DESCRIPTOR, HelloServer.DESCRIPTOR, RequestFiles.DESCRIPTOR, SendFiles.DESCRIPTOR, Chunker.DESCRIPTOR));
        BCLibPatch.register();
        TemplatePiece.ensureStaticInitialization();
        PlacementModifiers.ensureStaticInitialization();
        Configs.save();
    }

    public static boolean isDevEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static class_2960 makeID(String path) {
        return new class_2960(MOD_ID, path);
    }
}

