/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.util;

import com.tom.storagemod.util.IItemHandler;
import com.tom.storagemod.util.ItemHandlerHelper;
import java.util.Objects;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_2350;

public class SidedInvWrapper
implements IItemHandler {
    protected final class_1278 inv;
    protected final class_2350 side;

    public SidedInvWrapper(class_1278 inv, class_2350 side) {
        this.inv = inv;
        this.side = side;
    }

    public static int getSlot(class_1278 inv, int slot, class_2350 side) {
        int[] slots = inv.method_5494(side);
        if (slot < slots.length) {
            return slots[slot];
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SidedInvWrapper that = (SidedInvWrapper)o;
        return this.inv.equals(that.inv) && this.side == that.side;
    }

    public int hashCode() {
        int result = this.inv.hashCode();
        result = 31 * result + Objects.hashCode(this.side);
        return result;
    }

    @Override
    public int getSlots() {
        return this.inv.method_5494(this.side).length;
    }

    @Override
    public class_1799 getStackInSlot(int slot) {
        int i = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        return i == -1 ? class_1799.field_8037 : this.inv.method_5438(i);
    }

    @Override
    public class_1799 insertItem(int slot, class_1799 stack, boolean simulate) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        int slot1 = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 == -1) {
            return stack;
        }
        class_1799 stackInSlot = this.inv.method_5438(slot1);
        if (!stackInSlot.method_7960()) {
            if (stackInSlot.method_7947() >= Math.min(stackInSlot.method_7914(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            if (!this.inv.method_5492(slot1, stack, this.side) || !this.inv.method_5437(slot1, stack)) {
                return stack;
            }
            int m = Math.min(stack.method_7914(), this.getSlotLimit(slot)) - stackInSlot.method_7947();
            if (stack.method_7947() <= m) {
                if (!simulate) {
                    class_1799 copy = stack.method_7972();
                    copy.method_7933(stackInSlot.method_7947());
                    this.setInventorySlotContents(slot1, copy);
                }
                return class_1799.field_8037;
            }
            stack = stack.method_7972();
            if (!simulate) {
                class_1799 copy = stack.method_7971(m);
                copy.method_7933(stackInSlot.method_7947());
                this.setInventorySlotContents(slot1, copy);
                return stack;
            }
            stack.method_7934(m);
            return stack;
        }
        if (!this.inv.method_5492(slot1, stack, this.side) || !this.inv.method_5437(slot1, stack)) {
            return stack;
        }
        int m = Math.min(stack.method_7914(), this.getSlotLimit(slot));
        if (m < stack.method_7947()) {
            stack = stack.method_7972();
            if (!simulate) {
                this.setInventorySlotContents(slot1, stack.method_7971(m));
                return stack;
            }
            stack.method_7934(m);
            return stack;
        }
        if (!simulate) {
            this.setInventorySlotContents(slot1, stack);
        }
        return class_1799.field_8037;
    }

    private void setInventorySlotContents(int slot, class_1799 stack) {
        this.inv.method_5431();
        this.inv.method_5447(slot, stack);
    }

    @Override
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return class_1799.field_8037;
        }
        int slot1 = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 == -1) {
            return class_1799.field_8037;
        }
        class_1799 stackInSlot = this.inv.method_5438(slot1);
        if (stackInSlot.method_7960()) {
            return class_1799.field_8037;
        }
        if (!this.inv.method_5493(slot1, stackInSlot, this.side)) {
            return class_1799.field_8037;
        }
        if (simulate) {
            if (stackInSlot.method_7947() < amount) {
                return stackInSlot.method_7972();
            }
            class_1799 copy = stackInSlot.method_7972();
            copy.method_7939(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.method_7947(), amount);
        class_1799 ret = this.inv.method_5434(slot1, m);
        this.inv.method_5431();
        return ret;
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.inv.method_5444();
    }

    @Override
    public boolean isItemValid(int slot, class_1799 stack) {
        int slot1 = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        return slot1 == -1 ? false : this.inv.method_5437(slot1, stack);
    }
}

