/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.util;

import com.tom.storagemod.StorageMod;
import com.tom.storagemod.util.InventoryWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3902;

public class MultiItemHandler
implements class_1263 {
    private List<InventoryWrapper> handlers = new ArrayList<InventoryWrapper>();
    private List<class_1799[]> dupDetector = new ArrayList<class_1799[]>();
    private int[] invSizes = new int[0];
    private int invSize;
    private boolean calling;

    public <R> R call(BiFunction<InventoryWrapper, Integer, R> func, int slot, R def) {
        if (this.calling) {
            return def;
        }
        if (slot >= this.invSize) {
            return def;
        }
        this.calling = true;
        for (int i = 0; i < this.invSizes.length; ++i) {
            if (slot >= this.invSizes[i]) {
                slot -= this.invSizes[i];
                continue;
            }
            R r = func.apply(this.handlers.get(i), slot);
            this.calling = false;
            return r;
        }
        this.calling = false;
        return def;
    }

    public int method_5439() {
        return this.invSize;
    }

    public boolean method_5442() {
        return false;
    }

    public class_1799 method_5438(int paramInt) {
        return this.call(InventoryWrapper::getStack, paramInt, class_1799.field_8037);
    }

    public class_1799 method_5434(int paramInt1, int paramInt2) {
        return this.call((i, s) -> i.removeStack((int)s, paramInt2), paramInt1, class_1799.field_8037);
    }

    public class_1799 method_5441(int paramInt) {
        return this.call(InventoryWrapper::removeStack, paramInt, class_1799.field_8037);
    }

    public void method_5447(int paramInt, class_1799 paramItemStack) {
        this.call((i, s) -> {
            i.setStack((int)s, paramItemStack);
            return class_3902.field_17274;
        }, paramInt, class_3902.field_17274);
    }

    public boolean method_5443(class_1657 paramPlayerEntity) {
        return false;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        return this.call((i, s) -> i.isValid((int)s, stack, false), slot, false);
    }

    public List<InventoryWrapper> getHandlers() {
        return this.handlers;
    }

    public void refresh() {
        this.dupDetector.clear();
        if (this.invSizes.length != this.handlers.size()) {
            this.invSizes = new int[this.handlers.size()];
        }
        this.invSize = 0;
        for (int i = 0; i < this.invSizes.length; ++i) {
            int s;
            InventoryWrapper ih = this.handlers.get(i);
            if (ih == null) {
                this.invSizes[i] = 0;
                continue;
            }
            this.invSizes[i] = s = ih.size();
            this.invSize += s;
        }
    }

    public boolean contains(Object o) {
        return this.handlers.contains(o);
    }

    public void add(InventoryWrapper e) {
        if (this.checkInv(e)) {
            this.handlers.add(e);
        }
    }

    private boolean checkInv(InventoryWrapper h) {
        int len = Math.min(StorageMod.CONFIG.invDupScanSize, h.size());
        if (len == 0) {
            return true;
        }
        class_1799[] is = new class_1799[len];
        for (int i = 0; i < len; ++i) {
            is[i] = h.getStack(i);
        }
        for (class_1799[] st : this.dupDetector) {
            int l = Math.min(len, st.length);
            for (int i = 0; i < l; ++i) {
                class_1799 item = st[i];
                if (item.method_7960() || item != is[i]) continue;
                return false;
            }
        }
        this.dupDetector.add(is);
        return true;
    }

    public void method_5448() {
        this.invSize = 0;
        this.handlers.clear();
        this.dupDetector.clear();
    }

    public void method_5431() {
    }
}

