/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.StorageMod;
import com.tom.storagemod.block.BlockInventoryCableConnector;
import com.tom.storagemod.gui.ContainerInventoryLink;
import com.tom.storagemod.tile.TileEntityInventoryCableConnectorBase;
import com.tom.storagemod.util.IInventoryLink;
import com.tom.storagemod.util.InventoryWrapper;
import com.tom.storagemod.util.RemoteConnections;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3908;

public class TileEntityInventoryCableConnector
extends TileEntityInventoryCableConnectorBase
implements class_3908,
IInventoryLink {
    private static final String CHANNEL_TAG = "channel";
    private static final String REMOTE_TAG = "remote";
    private UUID channel = null;
    private int beaconLevel = -1;
    private boolean remote;

    public TileEntityInventoryCableConnector(class_2338 pos, class_2680 state) {
        super(StorageMod.invCableConnectorTile, pos, state);
    }

    @Override
    public void updateServer() {
        super.updateServer();
        if (!this.field_11863.field_9236 && this.field_11863.method_8510() % 20L == 18L) {
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            class_2350 facing = (class_2350)state.method_11654((class_2769)BlockInventoryCableConnector.FACING);
            class_2338 pos = this.field_11867.method_10093(facing);
            class_2680 st = this.field_11863.method_8320(pos);
            this.beaconLevel = st.method_27852(class_2246.field_10327) ? TileEntityInventoryCableConnector.calcBeaconLevel(this.field_11863, pos.method_10263(), pos.method_10264(), pos.method_10260()) : -1;
        }
    }

    @Override
    protected InventoryWrapper getPointedAt(class_2338 pos, class_2350 facing) {
        if (this.beaconLevel >= 0) {
            RemoteConnections.Channel chn;
            if (this.channel != null && this.beaconLevel > 0 && (chn = RemoteConnections.get(this.field_11863).getChannel(this.channel)) != null) {
                if (!this.remote) {
                    return chn.findOthers((class_3218)this.field_11863, this.field_11867, this.beaconLevel);
                }
                chn.register((class_3218)this.field_11863, this.field_11867);
            }
            return null;
        }
        return super.getPointedAt(pos, facing);
    }

    public static int calcBeaconLevel(class_1937 world, int x, int y, int z) {
        int i = 0;
        class_2586 ent = world.method_8321(new class_2338(x, y, z));
        if (ent instanceof class_2580) {
            int k;
            class_2580 b = (class_2580)ent;
            if (b.method_10937().isEmpty()) {
                return 0;
            }
            int j = 1;
            while (j <= 4 && (k = y - j) >= world.method_31607()) {
                boolean flag = true;
                block1: for (int l = x - j; l <= x + j && flag; ++l) {
                    for (int i1 = z - j; i1 <= z + j; ++i1) {
                        if (world.method_8320(new class_2338(l, k, i1)).method_26164(class_3481.field_22275)) continue;
                        flag = false;
                        continue block1;
                    }
                }
                if (!flag) break;
                i = j++;
            }
        }
        return i;
    }

    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new ContainerInventoryLink(syncId, inv, this);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"ts.inventory_connector");
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.channel = nbt.method_10545(CHANNEL_TAG) ? nbt.method_25926(CHANNEL_TAG) : null;
        this.remote = nbt.method_10577(REMOTE_TAG);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.channel != null) {
            nbt.method_25927(CHANNEL_TAG, this.channel);
        }
        nbt.method_10556(REMOTE_TAG, this.remote);
    }

    @Override
    public InventoryWrapper getInventoryFrom(class_3218 fromWorld, int fromLevel) {
        if (!this.remote || this.beaconLevel < StorageMod.CONFIG.invLinkBeaconLvl) {
            return null;
        }
        if (this.beaconLevel >= StorageMod.CONFIG.invLinkBeaconLvlDim || fromLevel >= StorageMod.CONFIG.invLinkBeaconLvlDim) {
            return new InventoryWrapper(this, class_2350.field_11033);
        }
        if (fromWorld.method_27983().equals(this.field_11863.method_27983())) {
            return new InventoryWrapper(this, class_2350.field_11033);
        }
        return null;
    }

    public boolean stillValid(class_1657 p_59619_) {
        RemoteConnections.Channel chn;
        if (this.channel != null && (chn = RemoteConnections.get(this.field_11863).getChannel(this.channel)) != null && !chn.publicChannel && !chn.owner.equals(p_59619_.method_5667())) {
            return false;
        }
        if (this.field_11863.method_8321(this.field_11867) != this || this.beaconLevel < 0) {
            return false;
        }
        return !(p_59619_.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) > 64.0);
    }

    @Override
    public UUID getChannel() {
        return this.channel;
    }

    public void setChannel(UUID channel) {
        RemoteConnections.get(this.field_11863).invalidateCache(this.channel);
        this.channel = channel;
        this.method_5431();
    }

    public int getBeaconLevel() {
        return this.beaconLevel;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
        this.method_5431();
    }
}

