/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.google.common.collect.Lists;
import com.tom.storagemod.NetworkHandler;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.StoredItemStack;
import com.tom.storagemod.tile.TileEntityStorageTerminal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1715;
import net.minecraft.class_1729;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5421;

public class ContainerStorageTerminal
extends class_1729<class_1715>
implements NetworkHandler.IDataReceiver {
    private static final int DIVISION_BASE = 1000;
    private static final char[] ENCODED_POSTFIXES = "KMGTPE".toCharArray();
    public static final Format format;
    protected TileEntityStorageTerminal te;
    protected int playerSlotsStart;
    protected List<SlotStorage> storageSlotList = new ArrayList<SlotStorage>();
    public List<StoredItemStack> itemList = Lists.newArrayList();
    public List<StoredItemStack> itemListClient = Lists.newArrayList();
    public List<StoredItemStack> itemListClientSorted = Lists.newArrayList();
    private Map<StoredItemStack, Long> itemsCount = new HashMap<StoredItemStack, Long>();
    private int lines;
    protected class_1661 pinv;
    public Runnable onPacket;
    public int terminalData;
    public String search;

    public ContainerStorageTerminal(int id, class_1661 inv, TileEntityStorageTerminal te) {
        this(StorageMod.storageTerminal, id, inv, te);
        this.addPlayerSlots(inv, 8, 120);
    }

    public ContainerStorageTerminal(class_3917<?> type, int id, class_1661 inv, TileEntityStorageTerminal te) {
        super(type, id);
        this.te = te;
        this.pinv = inv;
        this.addStorageSlots();
    }

    public boolean method_7604(class_1657 playerIn, int id) {
        if (id == 0) {
            return false;
        }
        int newC = id >> 1;
        this.te.setSorting(newC);
        return false;
    }

    public ContainerStorageTerminal(class_3917<?> type, int id, class_1661 inv) {
        this(type, id, inv, null);
    }

    protected void addStorageSlots() {
        this.addStorageSlots(5, 8, 18);
    }

    public ContainerStorageTerminal(int id, class_1661 inv) {
        this(StorageMod.storageTerminal, id, inv);
        this.addPlayerSlots(inv, 8, 120);
    }

    protected void addPlayerSlots(class_1661 playerInventory, int x, int y) {
        int i;
        this.playerSlotsStart = this.field_7761.size() - 1;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, j + i * 9 + 9, x + j * 18, y + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, x + i * 18, y + 58));
        }
    }

    public final void addStorageSlots(int lines, int x, int y) {
        this.storageSlotList.clear();
        this.lines = lines;
        for (int i = 0; i < lines; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new SlotStorage(this.te, i * 9 + j, x + j * 18, y + i * 18));
            }
        }
        this.scrollTo(0.0f);
    }

    protected final void addSlotToContainer(SlotStorage slotStorage) {
        this.storageSlotList.add(slotStorage);
    }

    public static String formatNumber(long number) {
        String slimResult;
        int width = 4;
        assert (number >= 0L);
        String numberString = Long.toString(number);
        int numberSize = numberString.length();
        if (numberSize <= width) {
            return numberString;
        }
        long base = number;
        double last = base * 1000L;
        int exponent = -1;
        String postFix = "";
        while (numberSize > width) {
            last = base;
            numberSize = Long.toString(base /= 1000L).length() + 1;
            postFix = String.valueOf(ENCODED_POSTFIXES[++exponent]);
        }
        String withPrecision = format.format(last / 1000.0) + postFix;
        String withoutPrecision = Long.toString(base) + postFix;
        String string = slimResult = withPrecision.length() <= width ? withPrecision : withoutPrecision;
        assert (slimResult.length() <= width);
        return slimResult;
    }

    public final void scrollTo(float p_148329_1_) {
        int i = (this.itemListClientSorted.size() + 9 - 1) / 9 - this.lines;
        int j = (int)((double)(p_148329_1_ * (float)i) + 0.5);
        if (j < 0) {
            j = 0;
        }
        for (int k = 0; k < this.lines; ++k) {
            for (int l = 0; l < 9; ++l) {
                int i1 = l + (k + j) * 9;
                if (i1 >= 0 && i1 < this.itemListClientSorted.size()) {
                    this.setSlotContents(l + k * 9, this.itemListClientSorted.get(i1));
                    continue;
                }
                this.setSlotContents(l + k * 9, null);
            }
        }
    }

    public final void setSlotContents(int id, StoredItemStack stack) {
        this.storageSlotList.get((int)id).stack = stack;
    }

    public final SlotStorage getSlotByID(int id) {
        return this.storageSlotList.get(id);
    }

    public void method_7623() {
        super.method_7623();
        if (this.te == null) {
            return;
        }
        Map<StoredItemStack, Long> itemsCount = this.te.getStacks();
        if (!this.itemsCount.equals(itemsCount)) {
            class_2499 list = new class_2499();
            this.itemList.clear();
            for (Map.Entry<StoredItemStack, Long> e : itemsCount.entrySet()) {
                StoredItemStack storedS = e.getKey();
                class_2487 tag = new class_2487();
                storedS.writeToNBT(tag);
                tag.method_10544("c", e.getValue().longValue());
                list.add((Object)tag);
                this.itemList.add(new StoredItemStack(e.getKey().getStack(), e.getValue()));
            }
            class_2487 mainTag = new class_2487();
            mainTag.method_10566("l", (class_2520)list);
            mainTag.method_10569("p", this.te.getSorting());
            mainTag.method_10582("s", this.te.getLastSearch());
            NetworkHandler.sendTo(this.pinv.field_7546, mainTag);
            this.itemsCount = new HashMap<StoredItemStack, Long>(itemsCount);
        }
    }

    public final void receiveClientTagPacket(class_2487 message) {
        class_2499 list = message.method_10554("l", 10);
        this.itemList.clear();
        for (int i = 0; i < list.size(); ++i) {
            class_2487 tag = list.method_10602(i);
            this.itemList.add(StoredItemStack.readFromNBT(tag));
        }
        this.itemListClient = new ArrayList<StoredItemStack>(this.itemList);
        this.pinv.method_5431();
        this.terminalData = message.method_10550("p");
        this.search = message.method_10558("s");
        if (this.onPacket != null) {
            this.onPacket.run();
        }
    }

    public final class_1799 method_7601(class_1657 playerIn, int index) {
        if (this.field_7761.size() > index) {
            if (index > this.playerSlotsStart && this.te != null) {
                if (this.field_7761.get(index) != null && ((class_1735)this.field_7761.get(index)).method_7681()) {
                    class_1735 slot = (class_1735)this.field_7761.get(index);
                    class_1799 slotStack = slot.method_7677();
                    StoredItemStack c = this.te.pushStack(new StoredItemStack(slotStack, slotStack.method_7947()));
                    class_1799 itemstack = c != null ? c.getActualStack() : class_1799.field_8037;
                    slot.method_7673(itemstack);
                    if (!playerIn.field_6002.field_9236) {
                        this.method_7623();
                    }
                }
            } else {
                return this.shiftClickItems(playerIn, index);
            }
        }
        return class_1799.field_8037;
    }

    protected class_1799 shiftClickItems(class_1657 playerIn, int index) {
        return class_1799.field_8037;
    }

    public static boolean areItemStacksEqual(class_1799 stack, class_1799 matchTo, boolean checkTag) {
        if (stack.method_7960() && matchTo.method_7960()) {
            return false;
        }
        if (!stack.method_7960() && !matchTo.method_7960() && stack.method_7909() == matchTo.method_7909()) {
            boolean equals = true;
            if (checkTag) {
                equals = equals && class_1799.method_7987((class_1799)stack, (class_1799)matchTo);
            }
            return equals;
        }
        return false;
    }

    public void sendMessage(class_2487 compound) {
        NetworkHandler.sendToServer(compound);
    }

    @Override
    public void receive(class_2487 message) {
        if (this.pinv.field_7546.method_7325()) {
            return;
        }
        if (message.method_10545("s")) {
            this.te.setLastSearch(message.method_10558("s"));
        }
        if (message.method_10545("a")) {
            class_3222 player = (class_3222)this.pinv.field_7546;
            player.method_14234();
            class_2487 d = message.method_10562("a");
            class_1799 clicked = class_1799.method_7915((class_2487)d.method_10562("s"));
            SlotAction act = SlotAction.VALUES[Math.abs(d.method_10550("a")) % SlotAction.VALUES.length];
            if (act == SlotAction.SPACE_CLICK) {
                for (int i = this.playerSlotsStart + 1; i < this.playerSlotsStart + 28; ++i) {
                    this.method_7601((class_1657)player, i);
                }
            } else if (act == SlotAction.PULL_OR_PUSH_STACK) {
                class_1799 stack = this.method_34255();
                if (!stack.method_7960()) {
                    StoredItemStack rem = this.te.pushStack(new StoredItemStack(stack));
                    class_1799 itemstack = rem == null ? class_1799.field_8037 : rem.getActualStack();
                    this.method_34254(itemstack);
                } else {
                    if (clicked.method_7960()) {
                        return;
                    }
                    StoredItemStack pulled = this.te.pullStack(new StoredItemStack(clicked), clicked.method_7914());
                    if (pulled != null) {
                        this.method_34254(pulled.getActualStack());
                    }
                }
            } else if (act == SlotAction.PULL_ONE) {
                class_1799 stack = this.method_34255();
                if (clicked.method_7960()) {
                    return;
                }
                if (d.method_10577("m")) {
                    StoredItemStack pulled = this.te.pullStack(new StoredItemStack(clicked), 1L);
                    if (pulled != null) {
                        class_1799 itemstack = pulled.getActualStack();
                        this.method_7616(itemstack, this.playerSlotsStart + 1, this.field_7761.size(), true);
                        if (itemstack.method_7947() > 0) {
                            this.te.pushOrDrop(itemstack);
                        }
                        player.method_31548().method_5431();
                    }
                } else if (!stack.method_7960()) {
                    StoredItemStack pulled;
                    if (ContainerStorageTerminal.areItemStacksEqual(stack, clicked, true) && stack.method_7947() + 1 <= stack.method_7914() && (pulled = this.te.pullStack(new StoredItemStack(clicked), 1L)) != null) {
                        stack.method_7933(1);
                    }
                } else {
                    StoredItemStack pulled = this.te.pullStack(new StoredItemStack(clicked), 1L);
                    if (pulled != null) {
                        this.method_34254(pulled.getActualStack());
                    }
                }
            } else if (act == SlotAction.GET_HALF) {
                class_1799 stack = this.method_34255();
                if (!stack.method_7960()) {
                    class_1799 stack1 = stack.method_7971(Math.max(Math.min(stack.method_7947(), stack.method_7914()) / 2, 1));
                    class_1799 itemstack = this.te.pushStack(stack1);
                    stack.method_7933(!itemstack.method_7960() ? itemstack.method_7947() : 0);
                    this.method_34254(stack);
                } else {
                    if (clicked.method_7960()) {
                        return;
                    }
                    long maxCount = 64L;
                    StoredItemStack clickedSt = new StoredItemStack(clicked);
                    for (int i = 0; i < this.itemList.size(); ++i) {
                        StoredItemStack e = this.itemList.get(i);
                        if (!e.equals((Object)clickedSt)) continue;
                        maxCount = e.getQuantity();
                    }
                    StoredItemStack pulled = this.te.pullStack(new StoredItemStack(clicked), Math.max(Math.min(maxCount, (long)clicked.method_7914()) / 2L, 1L));
                    if (pulled != null) {
                        this.method_34254(pulled.getActualStack());
                    }
                }
            } else if (act == SlotAction.GET_QUARTER) {
                class_1799 stack = this.method_34255();
                if (!stack.method_7960()) {
                    class_1799 stack1 = stack.method_7971(Math.max(Math.min(stack.method_7947(), stack.method_7914()) / 4, 1));
                    class_1799 itemstack = this.te.pushStack(stack1);
                    stack.method_7933(!itemstack.method_7960() ? itemstack.method_7947() : 0);
                    this.method_34254(stack);
                } else {
                    if (clicked.method_7960()) {
                        return;
                    }
                    long maxCount = 64L;
                    StoredItemStack clickedSt = new StoredItemStack(clicked);
                    for (int i = 0; i < this.itemList.size(); ++i) {
                        StoredItemStack e = this.itemList.get(i);
                        if (!e.equals((Object)clickedSt)) continue;
                        maxCount = e.getQuantity();
                    }
                    StoredItemStack pulled = this.te.pullStack(new StoredItemStack(clicked), Math.max(Math.min(maxCount, (long)clicked.method_7914()) / 4L, 1L));
                    if (pulled != null) {
                        this.method_34254(pulled.getActualStack());
                    }
                }
            } else {
                if (clicked.method_7960()) {
                    return;
                }
                StoredItemStack pulled = this.te.pullStack(new StoredItemStack(clicked), clicked.method_7914());
                if (pulled != null) {
                    class_1799 itemstack = pulled.getActualStack();
                    this.method_7616(itemstack, this.playerSlotsStart + 1, this.field_7761.size(), true);
                    if (itemstack.method_7947() > 0) {
                        this.te.pushOrDrop(itemstack);
                    }
                    player.method_31548().method_5431();
                }
            }
        }
        if (message.method_10545("c")) {
            class_2487 d = message.method_10562("c");
            this.te.setSorting(d.method_10550("d"));
        }
    }

    public void method_7654(class_1662 paramRecipeFinder) {
    }

    public void method_7657() {
    }

    public boolean method_7652(class_1860<? super class_1715> paramRecipe) {
        return false;
    }

    public int method_7655() {
        return 0;
    }

    public int method_7653() {
        return 0;
    }

    public int method_7656() {
        return 0;
    }

    @Environment(value=EnvType.CLIENT)
    public int method_7658() {
        return 0;
    }

    public boolean method_7597(class_1657 paramPlayerEntity) {
        return this.te == null || this.te.canInteractWith(paramPlayerEntity);
    }

    public class_5421 method_30264() {
        return class_5421.field_25763;
    }

    public boolean method_32339(int index) {
        return false;
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat format_ = new DecimalFormat(".#;0.#");
        format_.setDecimalFormatSymbols(symbols);
        format_.setRoundingMode(RoundingMode.DOWN);
        format = format_;
    }

    public static class SlotStorage {
        public int xDisplayPosition;
        public int yDisplayPosition;
        private final int slotIndex;
        public final TileEntityStorageTerminal inventory;
        public StoredItemStack stack;

        public SlotStorage(TileEntityStorageTerminal inventory, int slotIndex, int xPosition, int yPosition) {
            this.xDisplayPosition = xPosition;
            this.yDisplayPosition = yPosition;
            this.slotIndex = slotIndex;
            this.inventory = inventory;
        }

        public class_1799 pullFromSlot(long max) {
            if (this.stack == null || max < 1L || this.inventory == null) {
                return class_1799.field_8037;
            }
            StoredItemStack r = this.inventory.pullStack(this.stack, max);
            if (r != null) {
                return r.getActualStack();
            }
            return class_1799.field_8037;
        }

        public class_1799 pushStack(class_1799 pushStack) {
            if (this.inventory == null) {
                return pushStack;
            }
            StoredItemStack r = this.inventory.pushStack(new StoredItemStack(pushStack, pushStack.method_7947()));
            if (r != null) {
                return r.getActualStack();
            }
            return class_1799.field_8037;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }
    }

    public static enum SlotAction {
        PULL_OR_PUSH_STACK,
        PULL_ONE,
        SPACE_CLICK,
        SHIFT_PULL,
        GET_HALF,
        GET_QUARTER;

        public static final SlotAction[] VALUES;

        static {
            VALUES = SlotAction.values();
        }
    }
}

