/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.google.common.collect.Lists;
import com.tom.storagemod.NetworkHandler;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.StoredItemStack;
import com.tom.storagemod.gui.ContainerStorageTerminal;
import com.tom.storagemod.rei.IREIAutoFillTerminal;
import com.tom.storagemod.tile.TileEntityCraftingTerminal;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1715;
import net.minecraft.class_1731;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2955;
import net.minecraft.class_3222;

public class ContainerCraftingTerminal
extends ContainerStorageTerminal
implements NetworkHandler.IDataReceiver,
IREIAutoFillTerminal {
    private final class_1715 craftMatrix;
    private final class_1731 craftResult;
    private class_1735 craftingResultSlot;
    private final List<class_1712> listeners = Lists.newArrayList();

    public void method_7596(class_1712 listener) {
        super.method_7596(listener);
        this.listeners.add(listener);
    }

    public void method_7603(class_1712 listener) {
        super.method_7603(listener);
        this.listeners.remove(listener);
    }

    public ContainerCraftingTerminal(int id, class_1661 inv, TileEntityCraftingTerminal te) {
        super(StorageMod.craftingTerminalCont, id, inv, te);
        this.craftMatrix = te.getCraftingInv();
        this.craftResult = te.getCraftResult();
        this.init();
        this.addPlayerSlots(inv, 8, 174);
        te.registerCrafting(this);
    }

    public ContainerCraftingTerminal(int id, class_1661 inv) {
        super(StorageMod.craftingTerminalCont, id, inv);
        this.craftMatrix = new class_1715((class_1703)this, 3, 3);
        this.craftResult = new class_1731();
        this.init();
        this.addPlayerSlots(inv, 8, 174);
    }

    public void method_7595(class_1657 playerIn) {
        super.method_7595(playerIn);
        if (this.te != null) {
            ((TileEntityCraftingTerminal)this.te).unregisterCrafting(this);
        }
    }

    private void init() {
        int x = -4;
        int y = 94;
        this.craftingResultSlot = new class_1734(this.pinv.field_7546, this.craftMatrix, (class_1263)this.craftResult, 0, x + 124, y + 35){

            public void method_7667(class_1657 thePlayer, class_1799 stack) {
                if (thePlayer.field_6002.field_9236) {
                    return;
                }
                this.method_7669(stack);
                if (!ContainerCraftingTerminal.this.pinv.field_7546.method_5770().field_9236) {
                    ((TileEntityCraftingTerminal)ContainerCraftingTerminal.this.te).craft(thePlayer);
                }
            }
        };
        this.method_7621(this.craftingResultSlot);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.method_7621(new SlotCrafting((class_1263)this.craftMatrix, j + i * 3, x + 30 + j * 18, y + 17 + i * 18));
            }
        }
    }

    @Override
    protected void addStorageSlots() {
        this.addStorageSlots(5, 8, 18);
    }

    public boolean method_7613(class_1799 stack, class_1735 slotIn) {
        return slotIn.field_7871 != this.craftResult && super.method_7613(stack, slotIn);
    }

    @Override
    public class_1799 shiftClickItems(class_1657 playerIn, int index) {
        class_1799 itemstack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 itemstack1 = slot.method_7677();
            itemstack = itemstack1.method_7972();
            if (index == 0) {
                if (this.te == null) {
                    return class_1799.field_8037;
                }
                ((TileEntityCraftingTerminal)this.te).craftShift(playerIn);
                if (!playerIn.field_6002.field_9236) {
                    this.method_7623();
                }
                return class_1799.field_8037;
            }
            if (index > 0 && index < 10) {
                if (this.te == null) {
                    return class_1799.field_8037;
                }
                class_1799 stack = ((TileEntityCraftingTerminal)this.te).pushStack(itemstack);
                slot.method_7673(stack);
                if (!playerIn.field_6002.field_9236) {
                    this.method_7623();
                }
            }
            slot.method_7667(playerIn, itemstack1);
        }
        return class_1799.field_8037;
    }

    public void onCraftMatrixChanged() {
        for (int i = 0; i < this.field_7761.size(); ++i) {
            class_1735 slot = (class_1735)this.field_7761.get(i);
            if (!(slot instanceof SlotCrafting) && slot != this.craftingResultSlot) continue;
            for (class_1712 listener : this.listeners) {
                if (!(listener instanceof class_3222)) continue;
                ((class_3222)listener).field_13987.method_14364((class_2596)new class_2653(this.field_7763, this.method_37422(), i, slot.method_7677()));
            }
        }
    }

    @Override
    public boolean method_7604(class_1657 playerIn, int id) {
        if (this.te != null && id == 0) {
            ((TileEntityCraftingTerminal)this.te).clear();
        } else {
            super.method_7604(playerIn, id);
        }
        return false;
    }

    @Override
    public void method_7654(class_1662 itemHelperIn) {
        this.craftMatrix.method_7683(itemHelperIn);
    }

    @Override
    public void method_7657() {
        this.craftMatrix.method_5448();
        this.craftResult.method_5448();
    }

    @Override
    public boolean method_7652(class_1860<? super class_1715> recipeIn) {
        return recipeIn.method_8115((class_1263)this.craftMatrix, this.pinv.field_7546.field_6002);
    }

    @Override
    public int method_7655() {
        return 0;
    }

    @Override
    public int method_7653() {
        return this.craftMatrix.method_17398();
    }

    @Override
    public int method_7656() {
        return this.craftMatrix.method_17397();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int method_7658() {
        return 10;
    }

    public void method_17697(boolean p_217056_1_, class_1860<?> p_217056_2_, class_3222 p_217056_3_) {
        new class_2955(this){
            {
                this.field_13347 = new TerminalRecipeItemHelper();
            }

            protected void method_12824(class_1735 slotToFill, class_1799 ingredientIn) {
                StoredItemStack st;
                int i = this.field_13350.method_7371(ingredientIn);
                if (i != -1) {
                    class_1799 itemstack = this.field_13350.method_5438(i).method_7972();
                    if (!itemstack.method_7960()) {
                        if (itemstack.method_7947() > 1) {
                            this.field_13350.method_5434(i, 1);
                        } else {
                            this.field_13350.method_5441(i);
                        }
                        itemstack.method_7939(1);
                        if (slotToFill.method_7677().method_7960()) {
                            slotToFill.method_7673(itemstack);
                        } else {
                            slotToFill.method_7677().method_7933(1);
                        }
                    }
                } else if (ContainerCraftingTerminal.this.te != null && (st = ContainerCraftingTerminal.this.te.pullStack(new StoredItemStack(ingredientIn), 1L)) != null) {
                    if (slotToFill.method_7677().method_7960()) {
                        slotToFill.method_7673(st.getActualStack());
                    } else {
                        slotToFill.method_7677().method_7933(1);
                    }
                }
            }

            protected void method_12822(boolean bool) {
                ((TileEntityCraftingTerminal)ContainerCraftingTerminal.this.te).clear();
                ContainerCraftingTerminal.this.method_7657();
            }
        }.method_12826(p_217056_3_, p_217056_2_, p_217056_1_);
    }

    @Override
    public void receive(class_2487 message) {
        super.receive(message);
        if (message.method_10545("i")) {
            class_1799[][] stacks = new class_1799[9][];
            class_2499 list = message.method_10554("i", 10);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 nbttagcompound = list.method_10602(i);
                byte slot = nbttagcompound.method_10571("s");
                int l = nbttagcompound.method_10571("l");
                stacks[slot] = new class_1799[l];
                for (int j = 0; j < l; ++j) {
                    class_2487 tag = nbttagcompound.method_10562("i" + j);
                    stacks[slot][j] = class_1799.method_7915((class_2487)tag);
                }
            }
            ((TileEntityCraftingTerminal)this.te).handlerItemTransfer(this.pinv.field_7546, stacks);
        }
    }

    @Override
    public boolean method_32339(int id) {
        return id > 0 && id < 10;
    }

    @Override
    public List<StoredItemStack> getStoredItems() {
        return this.itemList;
    }

    public static class SlotCrafting
    extends class_1735 {
        public SlotCrafting(class_1263 inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }
    }

    public class TerminalRecipeItemHelper
    extends class_1662 {
        public void method_7409() {
            super.method_7409();
            ContainerCraftingTerminal.this.itemList.forEach(e -> this.method_7404(e.getActualStack()));
        }
    }
}

