/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod;

import com.tom.storagemod.Config;
import com.tom.storagemod.NetworkHandler;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.StorageTags;
import com.tom.storagemod.gui.GuiCraftingTerminal;
import com.tom.storagemod.gui.GuiFiltered;
import com.tom.storagemod.gui.GuiInventoryLink;
import com.tom.storagemod.gui.GuiLevelEmitter;
import com.tom.storagemod.gui.GuiStorageTerminal;
import com.tom.storagemod.item.ItemWirelessTerminal;
import com.tom.storagemod.model.BakedPaintedModel;
import com.tom.storagemod.tile.TileEntityPainted;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.model.ModelProviderContext;
import net.fabricmc.fabric.api.client.model.ModelProviderException;
import net.fabricmc.fabric.api.client.model.ModelResourceProvider;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1074;
import net.minecraft.class_1100;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3929;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_746;

public class StorageModClient
implements ClientModInitializer {
    protected static final class_2960 PAINT = new class_2960("toms_storage", "paint");

    public void onInitializeClient() {
        class_3929.method_17542(StorageMod.storageTerminal, GuiStorageTerminal::new);
        class_3929.method_17542(StorageMod.craftingTerminalCont, GuiCraftingTerminal::new);
        class_3929.method_17542(StorageMod.filteredConatiner, GuiFiltered::new);
        class_3929.method_17542(StorageMod.levelEmitterConatiner, GuiLevelEmitter::new);
        class_3929.method_17542(StorageMod.inventoryLink, GuiInventoryLink::new);
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)StorageMod.paintedTrim, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)StorageMod.invCablePainted, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)StorageMod.levelEmitter, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)StorageMod.invCableConnectorPainted, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)StorageMod.invProxyPainted, class_1921.method_23583());
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkHandler.DATA_S2C, (mc, h, buf, rp) -> {
            class_2487 tag = buf.method_30617();
            mc.method_20493(() -> {
                if (mc.field_1755 instanceof NetworkHandler.IDataReceiver) {
                    ((NetworkHandler.IDataReceiver)mc.field_1755).receive(tag);
                }
            });
        });
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(rm -> new ModelResourceProvider(){

            public class_1100 loadModelResource(class_2960 resourceId, ModelProviderContext context) throws ModelProviderException {
                if (resourceId.equals((Object)PAINT)) {
                    return new BakedPaintedModel();
                }
                return null;
            }
        });
        ColorProviderRegistry.BLOCK.register((state, world, pos, tintIndex) -> {
            if (world != null) {
                try {
                    class_2680 mimicBlock = ((TileEntityPainted)world.method_8321(pos)).getPaintedBlockState();
                    return class_310.method_1551().method_1505().method_1697(mimicBlock, world, pos, tintIndex);
                }
                catch (Exception var8) {
                    return -1;
                }
            }
            return -1;
        }, (Object[])new class_2248[]{StorageMod.paintedTrim, StorageMod.invCablePainted, StorageMod.invCableConnectorPainted, StorageMod.invProxyPainted});
        WorldRenderEvents.BEFORE_BLOCK_OUTLINE.register((ctx, hr) -> {
            class_310 mc = class_310.method_1551();
            class_746 player = mc.field_1724;
            if (player == null) {
                return true;
            }
            if (!ItemWirelessTerminal.isPlayerHolding((class_1657)player)) {
                return true;
            }
            class_3965 lookingAt = (class_3965)player.method_5745((double)StorageMod.CONFIG.wirelessRange, 0.0f, true);
            class_2680 state = mc.field_1687.method_8320(lookingAt.method_17777());
            if (state.method_26164(StorageTags.REMOTE_ACTIVATE)) {
                class_2338 pos = lookingAt.method_17777();
                class_243 renderPos = mc.field_1773.method_19418().method_19326();
                class_4588 buf = mc.method_22940().method_23000().getBuffer(class_1921.method_23594());
                StorageModClient.drawShapeOutline(ctx.matrixStack(), buf, state.method_26220((class_1922)player.field_6002, pos), (double)pos.method_10263() - renderPos.field_1352, (double)pos.method_10264() - renderPos.field_1351, (double)pos.method_10260() - renderPos.field_1350, 1.0f, 1.0f, 1.0f, 0.4f);
                mc.method_22940().method_23000().method_22994(class_1921.method_23594());
                return false;
            }
            return true;
        });
        try {
            Class<?> clz = Class.forName("com.kqp.inventorytabs.api.TabProviderRegistry");
            Method regSimpleBlock = clz.getDeclaredMethod("registerSimpleBlock", class_2248.class);
            regSimpleBlock.invoke(null, new Object[]{StorageMod.terminal});
            regSimpleBlock.invoke(null, new Object[]{StorageMod.craftingTerminal});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ClientLoginNetworking.registerGlobalReceiver((class_2960)StorageMod.id("config"), (mc, handler, buf, fc) -> {
            Config read;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new ByteBufInputStream((ByteBuf)buf));){
                read = (Config)StorageMod.gson.fromJson((Reader)reader, Config.class);
            }
            catch (Exception e) {
                StorageMod.LOGGER.warn("Error loading server config", (Throwable)e);
                return CompletableFuture.completedFuture(null);
            }
            StorageMod.CONFIG = read;
            StorageMod.LOGGER.info("Received server config");
            return CompletableFuture.completedFuture(PacketByteBufs.empty());
        });
    }

    private static void drawShapeOutline(class_4587 matrices, class_4588 vertexConsumer, class_265 voxelShape, double d, double e, double f, float g, float h, float i, float j) {
        class_4587.class_4665 entry = matrices.method_23760();
        voxelShape.method_1104((k, l, m, n, o, p) -> {
            float q = (float)(n - k);
            float r = (float)(o - l);
            float s = (float)(p - m);
            float t = class_3532.method_15355((float)(q * q + r * r + s * s));
            vertexConsumer.method_22918(entry.method_23761(), (float)(k + d), (float)(l + e), (float)(m + f)).method_22915(g, h, i, j).method_23763(entry.method_23762(), q /= t, r /= t, s /= t).method_1344();
            vertexConsumer.method_22918(entry.method_23761(), (float)(n + d), (float)(o + e), (float)(p + f)).method_22915(g, h, i, j).method_23763(entry.method_23762(), q, r, s).method_1344();
        });
    }

    public static void tooltip(String key, List<class_2561> tooltip, Object ... args) {
        StorageModClient.tooltip(key, true, tooltip, args);
    }

    public static void tooltip(String key, boolean shift, List<class_2561> tooltip, Object ... args) {
        if (class_437.method_25442()) {
            String[] sp = class_1074.method_4662((String)("tooltip.toms_storage." + key), (Object[])args).split("\\\\");
            for (int i = 0; i < sp.length; ++i) {
                tooltip.add((class_2561)class_2561.method_43470((String)sp[i]));
            }
        } else if (shift) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.toms_storage.hold_shift_for_info").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}));
        }
    }
}

