package mods.immibis.core.api.util;

import java.util.logging.Level;
import java.util.logging.Logger;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiErrorScreen;
import cpw.mods.fml.client.CustomModLoadingErrorDisplayException;
import cpw.mods.fml.relauncher.FMLRelauncher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ErrorScreen {
	@SideOnly(Side.CLIENT)
	private static class ErrorScreenException extends CustomModLoadingErrorDisplayException {
		private static final long serialVersionUID = 1L;
		
		public String[] message;
		
	    public ErrorScreenException(String[] message) {
	    	this.message = message;
	    }
	    
	    @Override
		public void initGui(GuiErrorScreen errorScreen, FontRenderer fontRenderer) {
		}

		@Override
		public void drawScreen(GuiErrorScreen errorScreen, FontRenderer fontRenderer, int mouseRelX, int mouseRelY, float tickTime) {
			// errorScreen.drawGradientRect(0, 0, errorScreen.width, errorScreen.height, 0xFF402020, 0xFF501010);
			errorScreen.drawGradientRect(0, 0, errorScreen.width, errorScreen.height, 0xFF402020, 0xFFFF1010);
			    
			int spacing = fontRenderer.FONT_HEIGHT + fontRenderer.FONT_HEIGHT/2;
			
			int y = errorScreen.height/2 - message.length*spacing/2;
			for(String line : message) {
				errorScreen.drawCenteredString(fontRenderer, line, errorScreen.width/2, y, 0xFFFFFF);
				y += spacing;
			}
		}
	}
	
	@SideOnly(Side.CLIENT)
	private static void displayFatalErrorClient(final String... msg) {
		throw new ErrorScreenException(msg);
	}
	
	private static void sleepForever() {
		while(true) {
			try {
				Thread.sleep(10000);
			} catch(InterruptedException e) {
				Thread.currentThread().interrupt();
				return;
			}
		}
	}
	
	public static void displayFatalError(final String... msg) {
		if(FMLRelauncher.side().equals("CLIENT"))
			displayFatalErrorClient(msg);
		
		else {
			// only logging is shown in the dedicated server GUI
			Logger l = Logger.getLogger("Minecraft-Server");
			l.log(Level.SEVERE, "");
			for(String line : msg)
				l.log(Level.SEVERE, line);
			
			System.err.println();
			for(String line : msg)
				System.err.println(line);
			
			sleepForever();
		}
	}
}
