package mods.immibis.core;

import java.util.Arrays;
import java.util.Map;

import mods.immibis.core.api.porting.SidedProxy;
import mods.immibis.core.porting.ClientProxy142;
import mods.immibis.core.porting.ServerProxy142;

import com.google.common.base.Throwables;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;

import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.relauncher.FMLRelauncher;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;

public class ICCoreMod implements IFMLLoadingPlugin {

	@Override
	public String[] getLibraryRequestClass() {
		return new String[0];
	}

	@Override
	public String[] getASMTransformerClass() {
		return new String[0];
	}

	@Override
	public String getModContainerClass() {
		return "mods.immibis.core.ICCoreMod$ModContainer";
	}

	@Override
	public String getSetupClass() {
		return null;
	}

	@Override
	public void injectData(Map<String, Object> data) {
	}
	
	public static class ModContainer extends DummyModContainer {
		public static SidedProxy sidedProxy;
	
		public ModContainer() {
			super(new ModMetadata());
			
			getMetadata().authorList = Arrays.asList("immibis");
			getMetadata().modId = ImmibisCore.MODID_COREMOD;
			getMetadata().name = ImmibisCore.NAME;
			getMetadata().version = ImmibisCore.VERSION;
			
			if(FMLRelauncher.side().equals("CLIENT"))
				sidedProxy = createClientProxy();
			else
				sidedProxy = createServerProxy();
		}
		
		private SidedProxy createClientProxy() {return new ClientProxy142();}
		private SidedProxy createServerProxy() {return new ServerProxy142();}
		
		private LoadController controller;
		
		@Override
		public boolean registerBus(EventBus bus, LoadController controller) {
			bus.register(this);
			this.controller = controller;
			return true;
		}
		
		@Subscribe
		public void construct(FMLConstructionEvent evt) {
			try {
				ImmibisCore.sidedProxy = sidedProxy;
				ImmibisCore.instance = new ImmibisCore();
			} catch(Throwable t) {
				controller.errorOccurred(this, t);
	            Throwables.propagateIfPossible(t);
			}
		}
		
		@Subscribe
		public void preinit(FMLPreInitializationEvent evt) {
			try {
				ImmibisCore.instance.preInit(evt);
			} catch(Throwable t) {
				controller.errorOccurred(this, t);
	            Throwables.propagateIfPossible(t);
			}
		}
		
		@Subscribe
		public void init(FMLInitializationEvent evt) {
			try {
				ImmibisCore.instance.init(evt);
			} catch(Throwable t) {
				controller.errorOccurred(this, t);
	            Throwables.propagateIfPossible(t);
			}
		}
		
		@Subscribe
		public void postinit(FMLPostInitializationEvent evt) {
			try {
				ImmibisCore.instance.postInit(evt);
			} catch(Throwable t) {
				controller.errorOccurred(this, t);
	            Throwables.propagateIfPossible(t);
			}
		}
		
		@Subscribe
		public void serverStarting(FMLServerStartingEvent evt) {
			try {
				ImmibisCore.instance.serverStarting(evt);
			} catch(Throwable t) {
				controller.errorOccurred(this, t);
	            Throwables.propagateIfPossible(t);
			}
		}
	}

}
