/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import mods.tinker.tconstruct.common.TContent;
import mods.tinker.tconstruct.crystal.TheftValueTracker;
import mods.tinker.tconstruct.library.util.ValueCoordTuple;
import mods.tinker.tconstruct.util.PHConstruct;
import mods.tinker.tconstruct.worldgen.OreberryBushGen;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class TBaseWorldGenerator
implements IWorldGenerator {
    WorldGenMinable copper;
    WorldGenMinable tin;
    WorldGenMinable aluminum;
    WorldGenMinable cobalt;
    WorldGenMinable ardite;
    OreberryBushGen ironBush;
    OreberryBushGen goldBush;
    OreberryBushGen copperBush;
    OreberryBushGen tinBush;
    OreberryBushGen aluminumBush;
    OreberryBushGen silverBush;

    public TBaseWorldGenerator() {
        this.copper = new WorldGenMinable(TContent.oreSlag.field_71990_ca, 3, 8, Block.field_71981_t.field_71990_ca);
        this.tin = new WorldGenMinable(TContent.oreSlag.field_71990_ca, 4, 8, Block.field_71981_t.field_71990_ca);
        this.aluminum = new WorldGenMinable(TContent.oreSlag.field_71990_ca, 5, 6, Block.field_71981_t.field_71990_ca);
        this.cobalt = new WorldGenMinable(TContent.oreSlag.field_71990_ca, 1, 3, Block.field_72012_bb.field_71990_ca);
        this.ardite = new WorldGenMinable(TContent.oreSlag.field_71990_ca, 2, 3, Block.field_72012_bb.field_71990_ca);
        this.ironBush = new OreberryBushGen(TContent.oreBerry.field_71990_ca, 12, 12, new int[0]);
        this.goldBush = new OreberryBushGen(TContent.oreBerry.field_71990_ca, 13, 6, new int[0]);
        this.copperBush = new OreberryBushGen(TContent.oreBerry.field_71990_ca, 14, 12, new int[0]);
        this.tinBush = new OreberryBushGen(TContent.oreBerry.field_71990_ca, 15, 12, new int[0]);
        this.aluminumBush = new OreberryBushGen(TContent.oreBerrySecond.field_71990_ca, 12, 14, new int[0]);
        this.silverBush = new OreberryBushGen(TContent.oreBerrySecond.field_71990_ca, 13, 8, new int[0]);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        this.initializeChunkData(chunkX, chunkZ, world.field_73011_w.field_76574_g);
        if (world.field_73011_w.field_76575_d) {
            this.generateNether(random, chunkX * 16, chunkZ * 16, world);
        } else if (world.field_73011_w.field_76577_b != WorldType.field_77138_c) {
            this.generateSurface(random, chunkX * 16, chunkZ * 16, world);
            if (world.field_73011_w.field_76574_g == 0) {
                this.generateOreBushes(random, chunkX * 16, chunkZ * 16, world);
            }
        }
        if (PHConstruct.superfunWorld && world.field_73011_w.field_76574_g == 0) {
            this.superfunGenerate(random, chunkX * 16, chunkZ * 16, world);
        }
        if (PHConstruct.worldBorder) {
            this.generateChunkBorder(random, chunkX * 16, chunkZ * 16, world);
        }
    }

    void initializeChunkData(int chunkX, int chunkZ, int worldID) {
        ValueCoordTuple coord = new ValueCoordTuple(worldID, chunkX, chunkZ);
        TheftValueTracker.crystallinity.put(coord, 0);
    }

    void generateSurface(Random random, int xChunk, int zChunk, World world) {
        String biomeName = world.func_72959_q().func_76935_a((int)xChunk, (int)zChunk).field_76791_y;
        this.generateUndergroundOres(random, xChunk, zChunk, world);
        if (biomeName == "Extreme Hills Edge" || biomeName == "Extreme Hills") {
            this.generateUndergroundOres(random, xChunk, zChunk, world);
        }
    }

    void generateUndergroundOres(Random random, int xChunk, int zChunk, World world) {
        int zPos;
        int yPos;
        int xPos;
        int q;
        if (PHConstruct.generateCopper) {
            for (q = 0; q <= PHConstruct.copperuDensity; ++q) {
                xPos = xChunk + random.nextInt(16);
                yPos = PHConstruct.copperuMinY + random.nextInt(PHConstruct.copperuMaxY - PHConstruct.copperuMinY);
                zPos = zChunk + random.nextInt(16);
                this.copper.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
        if (PHConstruct.generateTin) {
            for (q = 0; q <= PHConstruct.tinuDensity; ++q) {
                xPos = xChunk + random.nextInt(16);
                yPos = PHConstruct.tinuMinY + random.nextInt(PHConstruct.tinuMaxY - PHConstruct.tinuMinY);
                zPos = zChunk + random.nextInt(16);
                this.tin.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
        if (PHConstruct.generateAluminum) {
            for (q = 0; q <= PHConstruct.aluminumuDensity; ++q) {
                xPos = xChunk + random.nextInt(16);
                yPos = PHConstruct.aluminumuMinY + random.nextInt(PHConstruct.aluminumuMaxY - PHConstruct.aluminumuMinY);
                zPos = zChunk + random.nextInt(16);
                this.aluminum.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
    }

    void generateOreBushes(Random random, int xChunk, int zChunk, World world) {
        int zPos;
        int yPos;
        int xPos;
        int i;
        if (PHConstruct.generateIronBush && random.nextInt(PHConstruct.ironBushRarity + 1) == 0) {
            for (i = 0; i < PHConstruct.ironBushDensity; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = PHConstruct.seaLevel - 32;
                zPos = zChunk + random.nextInt(16);
                if ((yPos = this.findAdequateLocation(world, xPos, yPos, zPos, PHConstruct.seaLevel, 0)) == -1) continue;
                this.ironBush.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
        if (PHConstruct.generateGoldBush && random.nextInt(PHConstruct.goldBushRarity + 1) == 0) {
            for (i = 0; i < PHConstruct.goldBushDensity; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = 16;
                zPos = zChunk + random.nextInt(16);
                if ((yPos = this.findAdequateLocation(world, xPos, yPos, zPos, 32, 0)) == -1) continue;
                this.goldBush.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
        if (PHConstruct.generateCopperBush && random.nextInt(PHConstruct.copperBushRarity + 1) == 0) {
            for (i = 0; i < PHConstruct.copperBushDensity; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = (PHConstruct.copperBushMaxY + PHConstruct.copperBushMinY) / 2;
                zPos = zChunk + random.nextInt(16);
                if ((yPos = this.findAdequateLocation(world, xPos, yPos, zPos, PHConstruct.copperBushMaxY, PHConstruct.copperBushMinY)) == -1) continue;
                this.copperBush.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
        if (PHConstruct.generateTinBush && random.nextInt(PHConstruct.tinBushRarity + 1) == 0) {
            for (i = 0; i < PHConstruct.tinBushDensity; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = (PHConstruct.tinBushMaxY + PHConstruct.tinBushMinY) / 2;
                zPos = zChunk + random.nextInt(16);
                if ((yPos = this.findAdequateLocation(world, xPos, yPos, zPos, PHConstruct.tinBushMaxY, PHConstruct.tinBushMinY)) == -1) continue;
                this.tinBush.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
        if (PHConstruct.generateAluminumBush && random.nextInt(PHConstruct.aluminumBushRarity + 1) == 0) {
            for (i = 0; i < PHConstruct.aluminumBushDensity; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = (PHConstruct.aluminumBushMaxY + PHConstruct.aluminumBushMinY) / 2;
                zPos = zChunk + random.nextInt(16);
                if ((yPos = this.findAdequateLocation(world, xPos, yPos, zPos, PHConstruct.aluminumBushMaxY, PHConstruct.aluminumBushMinY)) == -1) continue;
                this.aluminumBush.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
        if (PHConstruct.generateEssenceBush && random.nextInt(PHConstruct.essenceBushRarity) == 0) {
            for (i = 0; i < PHConstruct.silverBushDensity; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = PHConstruct.seaLevel - 16;
                zPos = zChunk + random.nextInt(16);
                if ((yPos = this.findAdequateLocation(world, xPos, yPos, zPos, 32, 0)) == -1) continue;
                this.silverBush.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
    }

    void generateNether(Random random, int xChunk, int zChunk, World world) {
        if (PHConstruct.generateNetherOres) {
            int zPos;
            int yPos;
            int xPos;
            int i;
            for (i = 0; i < PHConstruct.netherDensity; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = random.nextInt(64) + 32;
                zPos = zChunk + random.nextInt(16);
                this.cobalt.func_76484_a(world, random, xPos, yPos, zPos);
                xPos = xChunk + random.nextInt(16);
                yPos = random.nextInt(64) + 32;
                zPos = zChunk + random.nextInt(16);
                this.ardite.func_76484_a(world, random, xPos, yPos, zPos);
            }
            for (i = 0; i < PHConstruct.netherDensity; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = random.nextInt(128);
                zPos = zChunk + random.nextInt(16);
                this.cobalt.func_76484_a(world, random, xPos, yPos, zPos);
                xPos = xChunk + random.nextInt(16);
                yPos = random.nextInt(128);
                zPos = zChunk + random.nextInt(16);
                this.ardite.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
    }

    int findAdequateLocation(World world, int x, int y, int z, int heightLimit, int depthLimit) {
        int height = y;
        do {
            if (world.func_72798_a(x, height, z) != 0 || world.func_72798_a(x, height + 1, z) == 0) continue;
            return height + 1;
        } while (++height < heightLimit);
        height = y;
        do {
            if (world.func_72798_a(x, height, z) != 0 || world.func_72798_a(x, height - 1, z) == 0) continue;
            return height - 1;
        } while (--height > depthLimit);
        return -1;
    }

    void superfunGenerate(Random random, int chunkX, int chunkZ, World world) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 128; ++y) {
                    int blockID = world.func_72798_a(x + chunkX, y, z + chunkZ);
                    Block block = Block.field_71973_m[blockID];
                    if (block == null) continue;
                    if (block.field_72018_cp == Material.field_76257_i) {
                        world.func_72832_d(x + chunkX, y, z + chunkZ, Block.field_71938_D.field_71990_ca, 0, 0);
                    }
                    if (block.field_72018_cp == Material.field_76245_d) {
                        world.func_72832_d(x + chunkX, y, z + chunkZ, Block.field_72012_bb.field_71990_ca, 0, 0);
                    }
                    if (block.field_71990_ca == Block.field_71981_t.field_71990_ca) {
                        world.func_72832_d(x + chunkX, y, z + chunkZ, Block.field_72082_bJ.field_71990_ca, 0, 0);
                    }
                    if (y > 40 && (block.field_72018_cp == Material.field_76248_c || block.field_72018_cp == Material.field_76247_b)) {
                        world.func_72832_d(x + chunkX, y, z + chunkZ, Block.field_72013_bc.field_71990_ca, 0, 0);
                    }
                    if (block.field_72018_cp != Material.field_76251_o) continue;
                    world.func_72832_d(x + chunkX, y, z + chunkZ, Block.field_72006_bl.field_71990_ca, 0, 0);
                }
            }
        }
    }

    void generateChunkBorder(Random random, int chunkX, int chunkZ, World world) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (x + chunkX != PHConstruct.worldBorderSize && x + chunkX != -PHConstruct.worldBorderSize && z + chunkZ != PHConstruct.worldBorderSize && z + chunkZ != -PHConstruct.worldBorderSize) continue;
                for (int y = 0; y < 256; ++y) {
                    world.func_72832_d(x + chunkX, y, z + chunkZ, Block.field_71986_z.field_71990_ca, 0, 0);
                }
            }
        }
    }
}

