/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.library.blocks;

import java.util.Random;
import mods.tinker.tconstruct.library.blocks.InventoryLogic;
import mods.tinker.tconstruct.library.util.IActiveLogic;
import mods.tinker.tconstruct.library.util.IFacingLogic;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class InventoryBlock
extends BlockContainer {
    protected Random rand = new Random();
    public Icon[] icons;

    protected InventoryBlock(int id, Material material) {
        super(id, material);
    }

    public TileEntity func_72274_a(World var1) {
        return null;
    }

    public abstract TileEntity createTileEntity(World var1, int var2);

    public abstract Integer getGui(World var1, int var2, int var3, int var4, EntityPlayer var5);

    public abstract Object getModInstance();

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float clickX, float clickY, float clickZ) {
        if (player.func_70093_af()) {
            return false;
        }
        Integer integer = this.getGui(world, x, y, z, player);
        if (integer == null || integer == -1) {
            return false;
        }
        if (!world.field_72995_K) {
            player.openGui(this.getModInstance(), integer.intValue(), world, x, y, z);
        }
        return true;
    }

    public void func_71852_a(World par1World, int x, int y, int z, int par5, int meta) {
        TileEntity te = par1World.func_72796_p(x, y, z);
        if (te != null && te instanceof InventoryLogic) {
            InventoryLogic logic = (InventoryLogic)te;
            for (int iter = 0; iter < logic.func_70302_i_(); ++iter) {
                ItemStack stack = logic.func_70301_a(iter);
                if (stack == null || !logic.canDropInventorySlot(iter)) continue;
                float jumpX = this.rand.nextFloat() * 0.8f + 0.1f;
                float jumpY = this.rand.nextFloat() * 0.8f + 0.1f;
                float jumpZ = this.rand.nextFloat() * 0.8f + 0.1f;
                while (stack.field_77994_a > 0) {
                    int itemSize = this.rand.nextInt(21) + 10;
                    if (itemSize > stack.field_77994_a) {
                        itemSize = stack.field_77994_a;
                    }
                    stack.field_77994_a -= itemSize;
                    EntityItem entityitem = new EntityItem(par1World, (double)((float)x + jumpX), (double)((float)y + jumpY), (double)((float)z + jumpZ), new ItemStack(stack.field_77993_c, itemSize, stack.func_77960_j()));
                    if (stack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                    }
                    float offset = 0.05f;
                    entityitem.field_70159_w = (float)this.rand.nextGaussian() * offset;
                    entityitem.field_70181_x = (float)this.rand.nextGaussian() * offset + 0.2f;
                    entityitem.field_70179_y = (float)this.rand.nextGaussian() * offset;
                    par1World.func_72838_d((Entity)entityitem);
                }
            }
        }
        super.func_71852_a(par1World, x, y, z, par5, meta);
    }

    public int func_85104_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        TileEntity logic = world.func_72796_p(x, y, z);
        if (logic instanceof IFacingLogic) {
            IFacingLogic direction = (IFacingLogic)logic;
            direction.setDirection(side);
        }
        return meta;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLiving entityliving, ItemStack stack) {
        TileEntity logic = world.func_72796_p(x, y, z);
        if (logic instanceof IFacingLogic) {
            IFacingLogic direction = (IFacingLogic)logic;
            if (entityliving == null) {
                direction.setDirection(0.0f, 0.0f, null);
            } else {
                direction.setDirection(entityliving.field_70177_z * 4.0f, entityliving.field_70125_A, entityliving);
            }
        }
    }

    public static boolean isActive(IBlockAccess world, int x, int y, int z) {
        TileEntity logic = world.func_72796_p(x, y, z);
        if (logic instanceof IActiveLogic) {
            return ((IActiveLogic)logic).getActive();
        }
        return false;
    }

    public int func_71899_b(int meta) {
        return meta;
    }

    public abstract String[] getTextureNames();

    public void func_94332_a(IconRegister iconRegister) {
        String[] textureNames = this.getTextureNames();
        this.icons = new Icon[textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("tinker:" + textureNames[i]);
        }
    }
}

