/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.items.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.tinker.tconstruct.common.TContent;
import mods.tinker.tconstruct.library.ActiveToolMod;
import mods.tinker.tconstruct.library.TConstructRegistry;
import mods.tinker.tconstruct.library.tools.AbilityHelper;
import mods.tinker.tconstruct.library.tools.Weapon;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class Scythe
extends Weapon {
    static Material[] materials = new Material[]{Material.field_76232_D, Material.field_76268_x, Material.field_76266_z, Material.field_76254_j, Material.field_76255_k, Material.field_76257_i};

    public Scythe(int itemID) {
        super(itemID, 4);
        this.func_77655_b("InfiTool.Scythe");
    }

    @Override
    protected Material[] getEffectiveMaterials() {
        return materials;
    }

    @Override
    public Item getHeadItem() {
        return TContent.scytheBlade;
    }

    @Override
    public Item getHandleItem() {
        return TContent.toughRod;
    }

    @Override
    public Item getAccessoryItem() {
        return TContent.toughBinding;
    }

    @Override
    public Item getExtraItem() {
        return TContent.toughRod;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 10;
    }

    @Override
    public int getPartAmount() {
        return 4;
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_scythe_head";
            }
            case 1: {
                return "_scythe_head_broken";
            }
            case 2: {
                return "_scythe_handle";
            }
            case 3: {
                return "_scythe_binding";
            }
            case 4: {
                return "_scythe_accessory";
            }
        }
        return "";
    }

    @Override
    public float getDurabilityModifier() {
        return 3.0f;
    }

    @Override
    public float getRepairCost() {
        return 4.0f;
    }

    @Override
    public String getEffectSuffix() {
        return "_scythe_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "scythe";
    }

    @Override
    public int durabilityTypeAccessory() {
        return 1;
    }

    @Override
    public int durabilityTypeExtra() {
        return 1;
    }

    @Override
    public float getDamageModifier() {
        return 0.75f;
    }

    @Override
    public String[] toolCategories() {
        return new String[]{"weapon", "melee", "harvest"};
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        World world = player.field_70170_p;
        int blockID = world.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int yPos = y - 1; yPos <= y + 1; ++yPos) {
                for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                    int localblockID;
                    Block block;
                    if (tags.func_74767_n("Broken")) continue;
                    boolean cancelHarvest = false;
                    for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                        if (!mod.beforeBlockBreak(this, stack, xPos, yPos, zPos, (EntityLiving)player)) continue;
                        cancelHarvest = true;
                    }
                    if (cancelHarvest || (block = Block.field_71973_m[localblockID = world.func_72798_a(xPos, yPos, zPos)]) == null) continue;
                    for (int iter = 0; iter < materials.length; ++iter) {
                        if (materials[iter] != block.field_72018_cp) continue;
                        int localMeta = world.func_72805_g(xPos, yPos, zPos);
                        if (!player.field_71075_bZ.field_75098_d) {
                            block.func_71893_a(world, player, xPos, yPos, zPos, localMeta);
                            block.func_71846_a(world, x, y, z, localMeta, player);
                            this.func_77660_a(stack, world, localblockID, xPos, yPos, zPos, (EntityLiving)player);
                        }
                        world.func_94571_i(xPos, yPos, zPos);
                    }
                }
            }
        }
        if (!world.field_72995_K) {
            world.func_72926_e(2001, x, y, z, blockID + (meta << 12));
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        AxisAlignedBB box = AxisAlignedBB.func_72332_a().func_72299_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70165_t + 1.0, entity.field_70163_u + 1.0, entity.field_70161_v + 1.0).func_72314_b(1.0, 1.0, 1.0);
        List list = player.field_70170_p.func_72839_b((Entity)player, box);
        for (Object o : list) {
            AbilityHelper.onLeftClickEntity(stack, (EntityLiving)player, (Entity)o, this);
        }
        return true;
    }
}

