/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.items.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.tinker.tconstruct.common.TContent;
import mods.tinker.tconstruct.library.ActiveToolMod;
import mods.tinker.tconstruct.library.TConstructRegistry;
import mods.tinker.tconstruct.library.tools.AbilityHelper;
import mods.tinker.tconstruct.library.tools.HarvestTool;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class LumberAxe
extends HarvestTool {
    static Material[] materials = new Material[]{Material.field_76245_d, Material.field_76255_k, Material.field_76265_p, Material.field_76268_x, Material.field_76266_z};

    public LumberAxe(int itemID) {
        super(itemID, 0);
        this.func_77655_b("InfiTool.LumberAxe");
    }

    @Override
    protected Material[] getEffectiveMaterials() {
        return materials;
    }

    @Override
    protected String getHarvestType() {
        return "axe";
    }

    @Override
    public float getRepairCost() {
        return 4.0f;
    }

    @Override
    public float getDurabilityModifier() {
        return 2.5f;
    }

    @Override
    public String getToolName() {
        return "Lumber Axe";
    }

    @Override
    public boolean func_77660_a(ItemStack itemstack, World world, int bID, int x, int y, int z, EntityLiving player) {
        Block block = Block.field_71973_m[bID];
        if (block != null && block.field_72018_cp == Material.field_76257_i) {
            return false;
        }
        return AbilityHelper.onBlockChanged(itemstack, world, bID, x, y, z, player, this.random);
    }

    @Override
    public float getStrVsBlock(ItemStack stack, Block block, int meta) {
        if (!stack.func_77942_o()) {
            return 1.0f;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74767_n("Broken")) {
            return 0.1f;
        }
        Material[] materials = this.getEffectiveMaterials();
        for (int i = 0; i < materials.length; ++i) {
            if (materials[i] != block.field_72018_cp) continue;
            float mineSpeed = tags.func_74762_e("MiningSpeed");
            int heads = 1;
            if (tags.func_74764_b("MiningSpeed2")) {
                mineSpeed += (float)tags.func_74762_e("MiningSpeed2");
                ++heads;
            }
            if (tags.func_74764_b("MiningSpeedHandle")) {
                mineSpeed += (float)tags.func_74762_e("MiningSpeedHandle");
                ++heads;
            }
            if (tags.func_74764_b("MiningSpeedExtra")) {
                mineSpeed += (float)tags.func_74762_e("MiningSpeedExtra");
                ++heads;
            }
            float trueSpeed = mineSpeed / ((float)heads * 300.0f);
            int hlvl = MinecraftForge.getBlockHarvestLevel((Block)block, (int)meta, (String)this.getHarvestType());
            int durability = tags.func_74762_e("Damage");
            float stonebound = tags.func_74760_g("Shoddy");
            float bonusLog = (float)Math.log((float)durability / 72.0f + 1.0f) * 2.0f * stonebound;
            trueSpeed += bonusLog;
            if (hlvl <= tags.func_74762_e("HarvestLevel")) {
                return trueSpeed;
            }
            return 0.1f;
        }
        return super.getStrVsBlock(stack, block, meta);
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        World world = player.field_70170_p;
        int woodID = world.func_72798_a(x, y, z);
        Block wood = Block.field_71973_m[woodID];
        if (wood.isWood(world, x, y, z)) {
            int height = y;
            boolean foundTop = false;
            do {
                int blockID;
                if ((blockID = world.func_72798_a(x, ++height, z)) == woodID) continue;
                --height;
                foundTop = true;
            } while (!foundTop);
            int numLeaves = 0;
            if (height - y < 30) {
                for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
                    for (int yPos = height - 1; yPos <= height + 1; ++yPos) {
                        for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                            Block leaves = Block.field_71973_m[world.func_72798_a(xPos, yPos, zPos)];
                            if (leaves == null || !leaves.isLeaves(world, xPos, yPos, zPos)) continue;
                            ++numLeaves;
                        }
                    }
                }
            }
            NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
            int meta = world.func_72805_g(x, y, z);
            if (numLeaves > 3) {
                this.breakTree(world, x, y, z, stack, tags, woodID, meta, player);
            } else {
                this.destroyWood(world, x, y, z, stack, tags, player);
            }
            if (!world.field_72995_K) {
                world.func_72926_e(2001, x, y, z, woodID + (meta << 12));
            }
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    void breakTree(World world, int x, int y, int z, ItemStack stack, NBTTagCompound tags, int bID, int meta, EntityPlayer player) {
        for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int yPos = y; yPos <= y + 1; ++yPos) {
                for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                    Block block;
                    int hlvl;
                    int localblockID;
                    if (tags.func_74767_n("Broken") || bID != (localblockID = world.func_72798_a(xPos, yPos, zPos)) || (hlvl = MinecraftForge.getBlockHarvestLevel((Block)(block = Block.field_71973_m[localblockID]), (int)(meta = world.func_72805_g(xPos, yPos, zPos)), (String)this.getHarvestType())) > tags.func_74762_e("HarvestLevel")) continue;
                    boolean cancelHarvest = false;
                    for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                        if (!mod.beforeBlockBreak(this, stack, xPos, yPos, zPos, (EntityLiving)player)) continue;
                        cancelHarvest = true;
                    }
                    if (cancelHarvest) {
                        this.breakTree(world, xPos, yPos, zPos, stack, tags, bID, meta, player);
                        continue;
                    }
                    if (localblockID != bID || world.func_72805_g(xPos, yPos, zPos) % 4 != meta % 4) continue;
                    if (!player.field_71075_bZ.field_75098_d) {
                        block.func_71893_a(world, player, xPos, yPos, zPos, meta);
                        block.func_71846_a(world, x, y, z, meta, player);
                        this.func_77660_a(stack, world, localblockID, xPos, yPos, zPos, (EntityLiving)player);
                    }
                    world.func_94571_i(xPos, yPos, zPos);
                    this.breakTree(world, xPos, yPos, zPos, stack, tags, bID, meta, player);
                }
            }
        }
    }

    void destroyWood(World world, int x, int y, int z, ItemStack stack, NBTTagCompound tags, EntityPlayer player) {
        for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int yPos = y - 1; yPos <= y + 1; ++yPos) {
                for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                    int meta;
                    int localblockID;
                    Block block;
                    int hlvl;
                    if (tags.func_74767_n("Broken") || (hlvl = MinecraftForge.getBlockHarvestLevel((Block)(block = Block.field_71973_m[localblockID = world.func_72798_a(xPos, yPos, zPos)]), (int)(meta = world.func_72805_g(xPos, yPos, zPos)), (String)this.getHarvestType())) > tags.func_74762_e("HarvestLevel")) continue;
                    boolean cancelHarvest = false;
                    for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                        if (!mod.beforeBlockBreak(this, stack, xPos, yPos, zPos, (EntityLiving)player)) continue;
                        cancelHarvest = true;
                    }
                    if (cancelHarvest || block == null || block.field_72018_cp != Material.field_76245_d) continue;
                    world.func_94571_i(xPos, yPos, zPos);
                    if (player.field_71075_bZ.field_75098_d) continue;
                    block.func_71893_a(world, player, xPos, yPos, zPos, meta);
                    this.func_77660_a(stack, world, localblockID, xPos, yPos, zPos, (EntityLiving)player);
                }
            }
        }
    }

    @Override
    public Item getHeadItem() {
        return TContent.broadAxeHead;
    }

    @Override
    public Item getHandleItem() {
        return TContent.toughRod;
    }

    @Override
    public Item getAccessoryItem() {
        return TContent.heavyPlate;
    }

    @Override
    public Item getExtraItem() {
        return TContent.toughBinding;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 10;
    }

    @Override
    public int getPartAmount() {
        return 4;
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_lumberaxe_head";
            }
            case 1: {
                return "_lumberaxe_head_broken";
            }
            case 2: {
                return "_lumberaxe_handle";
            }
            case 3: {
                return "_lumberaxe_shield";
            }
            case 4: {
                return "_lumberaxe_binding";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_lumberaxe_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "lumberaxe";
    }

    @Override
    public int durabilityTypeAccessory() {
        return 2;
    }

    @Override
    public int durabilityTypeExtra() {
        return 1;
    }
}

