/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.items.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.tinker.tconstruct.common.TContent;
import mods.tinker.tconstruct.library.crafting.ToolBuilder;
import mods.tinker.tconstruct.library.tools.ToolCore;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class Arrow
extends ToolCore {
    public Arrow(int id) {
        super(id, 3);
        this.func_77655_b("InfiTool.Arrow");
        this.func_77625_d(64);
        this.func_77656_e(0);
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_arrow_head";
            }
            case 1: {
                return "";
            }
            case 2: {
                return "_arrow_shaft";
            }
            case 3: {
                return "_arrow_fletching";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_arrow_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "arrow";
    }

    @Override
    public void registerPartPaths(int index, String[] location) {
        this.headStrings.put(index, location[0]);
        this.handleStrings.put(index, location[2]);
    }

    @Override
    public void registerAlternatePartPaths(int index, String[] location) {
        this.accessoryStrings.put(index, location[3]);
    }

    @Override
    public Item getHeadItem() {
        return TContent.arrowhead;
    }

    @Override
    public Item getAccessoryItem() {
        return TContent.fletching;
    }

    @Override
    public String[] toolCategories() {
        return new String[]{"ammo"};
    }

    @Override
    public void func_77633_a(int id, CreativeTabs tab, List list) {
        Item accessory = this.getAccessoryItem();
        ItemStack accessoryStack = accessory != null ? new ItemStack(this.getAccessoryItem(), 1, 0) : null;
        Item extra = this.getExtraItem();
        ItemStack extraStack = extra != null ? new ItemStack(extra, 1, 0) : null;
        ItemStack tool = ToolBuilder.instance.buildTool(new ItemStack(this.getHeadItem(), 1, 3), new ItemStack(this.getHandleItem(), 1, 0), accessoryStack, extraStack, "");
        if (tool == null) {
            System.out.println("Creative builder failed tool for Vanilla style" + this.getToolName());
            System.out.println("Make sure you do not have item ID conflicts");
        } else {
            tool.field_77994_a = 1;
            tool.func_77978_p().func_74775_l("InfiTool").func_74757_a("Built", true);
            list.add(tool);
        }
        accessory = this.getAccessoryItem();
        accessoryStack = accessory != null ? new ItemStack(this.getAccessoryItem(), 1, this.random.nextInt(4)) : null;
        extra = this.getExtraItem();
        extraStack = extra != null ? new ItemStack(extra, 1, 0) : null;
        tool = ToolBuilder.instance.buildTool(new ItemStack(this.getHeadItem(), 1, this.random.nextInt(18)), new ItemStack(this.getHandleItem(), 1, this.random.nextInt(18)), accessoryStack, extraStack, "Random Streamer");
        if (tool == null) {
            System.out.println("Creative builder failed tool for Vanilla style" + this.getToolName());
            System.out.println("Make sure you do not have item ID conflicts");
        } else {
            tool.field_77994_a = 1;
            tool.func_77978_p().func_74775_l("InfiTool").func_74757_a("Built", true);
            list.add(tool);
        }
        super.func_77633_a(id, tab, list);
    }

    @Override
    public void buildTool(int id, String name, List list) {
        Item accessory = this.getAccessoryItem();
        ItemStack accessoryStack = accessory != null ? new ItemStack(this.getAccessoryItem(), 1, 0) : null;
        Item extra = this.getExtraItem();
        ItemStack extraStack = extra != null ? new ItemStack(this.getExtraItem(), 1, id) : null;
        ItemStack tool = ToolBuilder.instance.buildTool(new ItemStack(this.getHeadItem(), 1, id), new ItemStack(this.getHandleItem(), 1, id), accessoryStack, extraStack, name + this.getToolName());
        if (tool == null) {
            System.out.println("Creative builder failed tool for " + name + this.getToolName());
            System.out.println("Make sure you do not have item ID conflicts");
        } else {
            tool.field_77994_a = 1;
            tool.func_77978_p().func_74775_l("InfiTool").func_74757_a("Built", true);
            list.add(tool);
        }
    }

    @Override
    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float clickX, float clickY, float clickZ) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound tags = stack.func_77978_p();
        if (tags.func_74764_b("charge")) {
            String color = "";
            int power = tags.func_74762_e("charge");
            if (power != 0) {
                color = power <= this.getMaxCharge(stack) / 3 ? "\u00a74" : (power > this.getMaxCharge(stack) * 2 / 3 ? "\u00a72" : "\u00a76");
            }
            String charge = color + tags.func_74762_e("charge") + "/" + this.getMaxCharge(stack) + " EU";
            list.add(charge);
        }
        if (tags.func_74764_b("InfiTool")) {
            boolean broken = tags.func_74775_l("InfiTool").func_74767_n("Broken");
            if (broken) {
                list.add("\u00a7oBroken");
            } else {
                int unbreaking;
                String reinforced;
                String handleName;
                int head = tags.func_74775_l("InfiTool").func_74762_e("Head");
                int handle = tags.func_74775_l("InfiTool").func_74762_e("Handle");
                String headName = this.getAbilityNameForType(head);
                if (!headName.equals("")) {
                    list.add(Arrow.getStyleForType(head) + headName);
                }
                if (!(handleName = this.getAbilityNameForType(handle)).equals("") && handle != head) {
                    list.add(Arrow.getStyleForType(handle) + handleName);
                }
                if (!(reinforced = this.getReinforcedName(head, handle, 0, 0, unbreaking = tags.func_74775_l("InfiTool").func_74762_e("Unbreaking"))).equals("")) {
                    list.add(reinforced);
                }
                boolean displayToolTips = true;
                int tipNum = 0;
                while (displayToolTips) {
                    String tooltip = "Tooltip" + ++tipNum;
                    if (tags.func_74775_l("InfiTool").func_74764_b(tooltip)) {
                        String tipName = tags.func_74775_l("InfiTool").func_74779_i(tooltip);
                        if (tipName.equals("")) continue;
                        list.add(tipName);
                        continue;
                    }
                    displayToolTips = false;
                }
            }
        }
    }
}

