/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.entity.ai;

import mods.tinker.tconstruct.entity.GolemBase;
import mods.tinker.tconstruct.entity.ai.GolemAIBase;
import net.minecraft.block.Block;
import net.minecraft.block.StepSound;
import net.minecraft.util.MathHelper;

public class GAIFellTree
extends GolemAIBase {
    private int counter;
    private int logID;
    private int blockStrength;
    private int cutX;
    private int cutY;
    private int cutZ;
    public static int cutRange = 4;
    public static double cutSpeed = 2.5;

    public GAIFellTree(GolemBase doll) {
        super(doll);
        this.func_75248_a(3);
    }

    @Override
    public boolean func_75250_a() {
        if (this.golem.paused) {
            return false;
        }
        int golemX = MathHelper.func_76128_c((double)this.golem.field_70165_t);
        int golemY = MathHelper.func_76128_c((double)(this.golem.field_70163_u + (double)this.golem.func_70047_e()));
        int golemZ = MathHelper.func_76128_c((double)this.golem.field_70161_v);
        int logCount = 0;
        int leavesCount = 0;
        int targetX = cutRange;
        int targetY = 0;
        int targetZ = cutRange;
        boolean isTarget = false;
        for (int iterX = -cutRange; iterX <= cutRange; ++iterX) {
            for (int iterZ = -cutRange; iterZ <= cutRange; ++iterZ) {
                int cbid;
                int cbid2;
                int bid;
                Block log;
                int dy = 0;
                int distanceToBlock = Math.abs(iterX) + Math.abs(iterZ);
                if (distanceToBlock > cutRange || (log = Block.field_71973_m[bid = this.world.func_72798_a(golemX + iterX, golemY + dy, golemZ + iterZ)]) == null || !log.isWood(this.world, golemX + iterX, golemY + dy, golemZ + iterZ) || Math.abs(targetX) + Math.abs(targetZ) <= distanceToBlock) continue;
                while (golemY + dy > 0 && (cbid2 = this.world.func_72798_a(golemX + iterX, golemY + dy - 1, golemZ + iterZ)) == bid) {
                    --dy;
                }
                int lCount = 0;
                int blockCount = 0;
                while (golemY + dy < this.world.func_72800_K() && (cbid = this.world.func_72798_a(golemX + iterX, golemY + dy, golemZ + iterZ)) == bid) {
                    int[][] coords = new int[][]{{golemX + iterX + 1, golemY + dy, golemZ + iterZ}, {golemX + iterX - 1, golemY + dy, golemZ + iterZ}, {golemX + iterX, golemY + dy, golemZ + iterZ + 1}, {golemX + iterX, golemY + dy, golemZ + iterZ - 1}};
                    for (int i = 0; i < 4; ++i) {
                        Block leaves = Block.field_71973_m[this.world.func_72798_a(coords[i][0], coords[i][1], coords[i][2])];
                        if (leaves == null || !leaves.isLeaves(this.world, coords[i][0], coords[i][1], coords[i][2])) continue;
                        ++blockCount;
                    }
                    ++lCount;
                    ++dy;
                }
                if (blockCount < 4) continue;
                targetX = iterX;
                targetY = dy - 1;
                targetZ = iterZ;
                isTarget = true;
                logCount = blockCount;
                leavesCount = lCount;
                this.logID = bid;
            }
        }
        this.golem.targetX = golemX + targetX;
        this.golem.targetY = golemY + targetY;
        this.golem.targetZ = golemZ + targetZ;
        this.golem.targetLock = isTarget;
        if (!isTarget) {
            return false;
        }
        this.golem.teleport((double)this.golem.targetX + 0.5, this.golem.targetY + 1, (double)this.golem.targetZ + 0.5);
        this.golem.func_70661_as().func_75499_g();
        return true;
    }

    public void func_75249_e() {
        this.counter = 0;
    }

    public boolean func_75253_b() {
        if (this.golem.paused) {
            return false;
        }
        if (Math.abs(MathHelper.func_76128_c((double)(this.golem.field_70165_t - (double)this.golem.targetX))) + Math.abs(MathHelper.func_76128_c((double)(this.golem.field_70163_u - (double)this.golem.targetY))) + Math.abs(MathHelper.func_76128_c((double)(this.golem.field_70161_v - (double)this.golem.targetZ))) > cutRange) {
            System.out.println("Too far away");
            return false;
        }
        if (!this.golem.targetLock) {
            System.out.println("Target lost");
            return false;
        }
        return true;
    }

    public void func_75251_c() {
        this.golem.targetLock = false;
    }

    public void func_75246_d() {
        Block b;
        if (this.counter == 0) {
            Block b2;
            boolean isCutting = false;
            for (int dx = -cutRange; dx <= cutRange; ++dx) {
                for (int dz = -cutRange; dz <= cutRange; ++dz) {
                    if (Math.abs(dx) + Math.abs(dz) > cutRange) continue;
                    if (this.world.func_72798_a(this.golem.targetX + dx, this.golem.targetY, this.golem.targetZ + dz) == this.logID) {
                        this.cutX = this.golem.targetX + dx;
                        this.cutY = this.golem.targetY;
                        this.cutZ = this.golem.targetZ + dz;
                        isCutting = true;
                    }
                    if (isCutting) break;
                }
                if (isCutting) break;
            }
            if (!isCutting) {
                this.cutX = this.golem.targetX;
                this.cutY = this.golem.targetY--;
                this.cutZ = this.golem.targetZ;
                if (this.world.func_72798_a(this.golem.targetX, this.golem.targetY, this.golem.targetZ) == this.logID) {
                    isCutting = true;
                } else {
                    isCutting = false;
                    this.golem.targetLock = false;
                    return;
                }
            }
            this.blockStrength = (b2 = Block.field_71973_m[this.world.func_72798_a(this.cutX, this.cutY, this.cutZ)]) == null ? 0 : MathHelper.func_76128_c((double)(1.0 + 30.0 * (double)b2.func_71934_m(this.world, this.cutX, this.cutY, this.cutZ) / cutSpeed));
            int n = this.blockStrength = this.blockStrength < 0 ? 0 : this.blockStrength;
        }
        if (this.counter >= this.blockStrength) {
            Block b3 = Block.field_71973_m[this.world.func_72798_a(this.cutX, this.cutY, this.cutZ)];
            if (b3 != null) {
                this.world.func_94578_a(this.cutX, this.cutY, this.cutZ, true);
            }
            this.counter = 0;
            return;
        }
        if (this.counter % 4 == 0 && (b = Block.field_71973_m[this.world.func_72798_a(this.golem.targetX, this.golem.targetY, this.golem.targetZ)]) != null) {
            StepSound stepsound = b.field_72020_cn;
            this.world.func_72908_a((double)((float)this.golem.targetX + 0.5f), (double)((float)this.golem.targetY + 0.5f), (double)((float)this.golem.targetZ + 0.5f), stepsound.func_72676_a(), (stepsound.func_72677_b() + 1.0f) / 8.0f, stepsound.func_72678_c() * 0.5f);
        }
        this.golem.func_70671_ap().func_75650_a((double)this.cutX + 0.5, (double)this.cutY + 0.5, (double)this.cutZ + 0.5, 20.0f, (float)this.golem.func_70646_bf());
        ++this.counter;
    }
}

