/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.client.gui;

import java.util.ArrayList;
import java.util.List;
import mods.tinker.tconstruct.blocks.logic.SmelteryLogic;
import mods.tinker.tconstruct.client.gui.NewContainerGui;
import mods.tinker.tconstruct.inventory.ActiveContainer;
import mods.tinker.tconstruct.inventory.SmelteryContainer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class SmelteryGui
extends NewContainerGui {
    public SmelteryLogic logic;
    String username;
    boolean isScrolling = false;
    boolean wasClicking;
    float currentScroll = 0.0f;
    int slotPos = 0;
    int prevSlotPos = 0;

    public SmelteryGui(InventoryPlayer inventoryplayer, SmelteryLogic smeltery, World world, int x, int y, int z) {
        super((ActiveContainer)smeltery.getGuiContainer(inventoryplayer, world, x, y, z));
        this.logic = smeltery;
        this.username = inventoryplayer.field_70458_d.field_71092_bJ;
        this.xSize = 248;
        smeltery.updateFuelDisplay();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float par3) {
        super.func_73863_a(mouseX, mouseY, par3);
        this.updateScrollbar(mouseX, mouseY, par3);
    }

    protected void updateScrollbar(int mouseX, int mouseY, float par3) {
        if (this.logic.layers > 2) {
            boolean mouseDown = Mouse.isButtonDown((int)0);
            int lefto = this.guiLeft;
            int topo = this.guiTop;
            int xScroll = lefto + 67;
            int yScroll = topo + 8;
            int scrollWidth = xScroll + 14;
            int scrollHeight = yScroll + 144;
            if (!this.wasClicking && mouseDown && mouseX >= xScroll && mouseY >= yScroll && mouseX < scrollWidth && mouseY < scrollHeight) {
                this.isScrolling = true;
            }
            if (!mouseDown) {
                this.isScrolling = false;
            }
            if (this.wasClicking && !this.isScrolling && this.slotPos != this.prevSlotPos) {
                this.prevSlotPos = this.slotPos;
            }
            this.wasClicking = mouseDown;
            if (this.isScrolling) {
                int s;
                this.currentScroll = ((float)(mouseY - yScroll) - 7.5f) / ((float)(scrollHeight - yScroll) - 15.0f);
                if (this.currentScroll < 0.0f) {
                    this.currentScroll = 0.0f;
                }
                if (this.currentScroll > 1.0f) {
                    this.currentScroll = 1.0f;
                }
                if ((s = ((SmelteryContainer)this.container).scrollTo(this.currentScroll)) != -1) {
                    this.slotPos = s;
                }
            }
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"crafters.Smeltery"), 86, 5, 0x404040);
        this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 90, this.ySize - 96 + 2, 0x404040);
        int base = 0;
        int cornerX = (this.field_73880_f - this.xSize) / 2 + 36;
        int cornerY = (this.field_73881_g - this.ySize) / 2;
        for (LiquidStack liquid : this.logic.moltenMetal) {
            int basePos = 54;
            boolean initialLiquidSize = false;
            int liquidSize = 0;
            if (this.logic.getCapacity() > 0) {
                int total = this.logic.getTotalLiquid();
                int liquidLayers = (total / 20000 + 1) * 20000;
                liquidSize = liquid.amount * 52 / liquidLayers;
                if (liquidSize == 0) {
                    liquidSize = 1;
                }
                base += liquidSize;
            }
            int leftX = cornerX + basePos;
            int topY = cornerY + 68 - base;
            int sizeX = 52;
            int sizeY = liquidSize;
            if (mouseX < leftX || mouseX > leftX + sizeX || mouseY < topY || mouseY >= topY + sizeY) continue;
            this.drawLiquidStackTooltip(liquid, mouseX - cornerX + 36, mouseY - cornerY);
        }
        if (this.logic.fuelGague > 0) {
            int leftX = cornerX + 117;
            int topY = cornerY + 68 - this.logic.getScaledFuelGague(52);
            int sizeX = 12;
            int sizeY = this.logic.getScaledFuelGague(52);
            if (mouseX >= leftX && mouseX <= leftX + sizeX && mouseY >= topY && mouseY < topY + sizeY) {
                this.drawLiquidStackTooltip(new LiquidStack(Block.field_71938_D.field_71990_ca, this.logic.fuelAmount, 0), mouseX - cornerX + 36, mouseY - cornerY);
            }
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        int slotSize;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b("/mods/tinker/textures/gui/smeltery.png");
        int cornerX = (this.field_73880_f - this.xSize) / 2 + 36;
        int cornerY = (this.field_73881_g - this.ySize) / 2;
        this.func_73729_b(cornerX + 46, cornerY, 0, 0, 176, this.ySize);
        if (this.logic.fuelGague > 0) {
            this.field_73882_e.field_71446_o.func_98187_b("/terrain.png");
            Icon lavaIcon = Block.field_71938_D.func_71858_a(0, 0);
            int fuel = this.logic.getScaledFuelGague(52);
            int count = 0;
            while (fuel > 0) {
                int size = fuel >= 16 ? 16 : fuel;
                fuel -= size;
                this.func_94065_a(cornerX + 117, cornerY + 68 - size - 16 * count, lavaIcon, 12, size);
                ++count;
            }
        }
        int base = 0;
        for (LiquidStack liquid : this.logic.moltenMetal) {
            int total;
            int liquidLayers;
            Icon renderIndex;
            if (liquid.itemID < 4096) {
                Block liquidBlock = Block.field_71973_m[liquid.itemID];
                this.field_73882_e.field_71446_o.func_98187_b("/terrain.png");
                renderIndex = liquidBlock.func_71858_a(0, liquid.itemMeta);
            } else {
                Item liquidItem = Item.field_77698_e[liquid.itemID];
                this.field_73882_e.field_71446_o.func_98187_b("/gui/items.png");
                renderIndex = liquidItem.func_77617_a(liquid.itemMeta);
            }
            int basePos = 54;
            if (this.logic.getCapacity() <= 0 || (liquidLayers = ((total = this.logic.getTotalLiquid()) / 20000 + 1) * 20000) <= 0) continue;
            int liquidSize = liquid.amount * 52 / liquidLayers;
            if (liquidSize == 0) {
                liquidSize = 1;
            }
            while (liquidSize > 0) {
                int size = liquidSize >= 16 ? 16 : liquidSize;
                this.func_94065_a(cornerX + basePos, cornerY + 68 - size - base, renderIndex, 16, size);
                this.func_94065_a(cornerX + basePos + 16, cornerY + 68 - size - base, renderIndex, 16, size);
                this.func_94065_a(cornerX + basePos + 32, cornerY + 68 - size - base, renderIndex, 16, size);
                this.func_94065_a(cornerX + basePos + 48, cornerY + 68 - size - base, renderIndex, 4, size);
                liquidSize -= size;
                base += size;
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b("/mods/tinker/textures/gui/smeltery.png");
        this.func_73729_b(cornerX + 54, cornerY + 16, 176, 76, 52, 52);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b("/mods/tinker/textures/gui/smelteryside.png");
        if (this.logic.layers > 0) {
            if (this.logic.layers == 1) {
                this.func_73729_b(cornerX - 46, cornerY, 0, 0, 98, 43);
                this.func_73729_b(cornerX - 46, cornerY + 43, 0, 133, 98, 25);
            } else if (this.logic.layers == 2) {
                this.func_73729_b(cornerX - 46, cornerY, 0, 0, 98, 61);
                this.func_73729_b(cornerX - 46, cornerY + 61, 0, 97, 98, 61);
            } else {
                this.func_73729_b(cornerX - 46, cornerY, 0, 0, 98, this.ySize - 8);
            }
            this.func_73729_b(cornerX + 32, (int)((float)(cornerY + 8) + 127.0f * this.currentScroll), 98, 0, 12, 15);
        }
        if ((slotSize = this.logic.layers * 9) > 24) {
            slotSize = 24;
        }
        for (int iter = 0; iter < slotSize; ++iter) {
            int slotTemp = this.logic.getTempForSlot(iter + this.slotPos * 3) - 20;
            int maxTemp = this.logic.getMeltingPointForSlot(iter + this.slotPos * 3) - 20;
            if (slotTemp <= 0 || maxTemp <= 0) continue;
            int size = 16 * slotTemp / maxTemp + 1;
            this.func_73729_b(cornerX - 38 + iter % 3 * 22, cornerY + 8 + iter / 3 * 18 + 16 - size, 98, 31 - size, 5, size);
        }
    }

    protected void drawLiquidStackTooltip(LiquidStack par1ItemStack, int par2, int par3) {
        this.field_73735_i = 100.0f;
        List list = this.getLiquidTooltip(par1ItemStack, this.field_73882_e.field_71474_y.field_82882_x);
        for (int k = 0; k < list.size(); ++k) {
            list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
        }
        this.drawToolTip(list, par2, par3);
        this.field_73735_i = 0.0f;
    }

    public List getLiquidTooltip(LiquidStack liquid, boolean par2) {
        ArrayList<String> list = new ArrayList<String>();
        if (liquid.itemID == Block.field_71938_D.field_71990_ca) {
            list.add("\u00a7fFuel");
            int mB = liquid.amount;
            if (mB > 0) {
                list.add("mB: " + mB);
            }
        } else {
            String name = LiquidDictionary.findLiquidName((LiquidStack)liquid);
            list.add("\u00a7f" + name);
            if (name.equals("Liquified Emerald")) {
                float emeralds = (float)liquid.amount / 320.0f;
                list.add("Emeralds: " + emeralds);
            } else {
                int mB;
                int ingots = liquid.amount / 144;
                if (ingots > 0) {
                    list.add("Ingots: " + ingots);
                }
                if ((mB = liquid.amount % 144) > 0) {
                    if (mB % 72 == 0) {
                        list.add("Chunks: " + liquid.amount % 144 / 72);
                    } else if (mB % 16 == 0) {
                        list.add("Nuggets: " + liquid.amount % 144 / 16);
                    } else {
                        list.add("mB: " + mB);
                    }
                }
            }
        }
        return list;
    }

    protected void drawToolTip(List par1List, int par2, int par3) {
        if (!par1List.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : par1List) {
                int l = this.field_73886_k.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = par2 + 12;
            int j1 = par3 - 12;
            int k1 = 8;
            if (par1List.size() > 1) {
                k1 += 2 + (par1List.size() - 1) * 10;
            }
            if (i1 + k > this.field_73880_f) {
                i1 -= 28 + k;
            }
            if (j1 + k1 + 6 > this.field_73881_g) {
                j1 = this.field_73881_g - k1 - 6;
            }
            this.field_73735_i = 300.0f;
            SmelteryGui.itemRenderer.field_77023_b = 300.0f;
            int l1 = -267386864;
            this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < par1List.size(); ++k2) {
                String s1 = (String)par1List.get(k2);
                this.field_73886_k.func_78261_a(s1, i1, j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.field_73735_i = 0.0f;
            SmelteryGui.itemRenderer.field_77023_b = 0.0f;
        }
    }

    public void drawLiquidRect(int par1, int par2, Icon par3Icon, int par4, int par5) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + par5), (double)this.field_73735_i, (double)par3Icon.func_94209_e(), (double)par3Icon.func_94210_h());
        tessellator.func_78374_a((double)(par1 + par4), (double)(par2 + par5), (double)this.field_73735_i, (double)par3Icon.func_94212_f(), (double)par3Icon.func_94210_h());
        tessellator.func_78374_a((double)(par1 + par4), (double)(par2 + 0), (double)this.field_73735_i, (double)par3Icon.func_94212_f(), (double)par3Icon.func_94206_g());
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + 0), (double)this.field_73735_i, (double)par3Icon.func_94209_e(), (double)par3Icon.func_94206_g());
        tessellator.func_78381_a();
    }
}

