/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.client.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import mods.tinker.tconstruct.blocks.logic.LavaTankLogic;
import mods.tinker.tconstruct.client.TProxyClient;
import mods.tinker.tconstruct.client.block.BlockSkinRenderHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public class TankRender
implements ISimpleBlockRenderingHandler {
    public static int tankModelID = RenderingRegistry.getNextAvailableRenderId();

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (modelID == tankModelID) {
            TProxyClient.renderStandardInvBlock(renderer, block, metadata);
            if (metadata == 0) {
                renderer.func_83020_a(0.1875, 0.0, 0.1875, 0.8125, 0.125, 0.8125);
                this.renderDoRe(renderer, block, metadata);
            }
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelID, RenderBlocks renderer) {
        if (modelID == tankModelID) {
            int meta;
            LavaTankLogic logic = (LavaTankLogic)world.func_72796_p(x, y, z);
            if (logic.containsLiquid()) {
                LiquidStack liquid = logic.tank.getLiquid();
                renderer.func_83020_a(0.001, 0.001, 0.001, 0.999, (double)logic.getLiquidAmountScaled(), 0.999);
                if (liquid.itemID < 4096) {
                    Block liquidBlock = Block.field_71973_m[liquid.itemID];
                    BlockSkinRenderHelper.renderMetadataBlock(liquidBlock, liquid.itemMeta, x, y, z, renderer, world);
                } else {
                    Item liquidItem = Item.field_77698_e[liquid.itemID];
                    BlockSkinRenderHelper.renderFakeBlock(liquidItem.func_77617_a(liquid.itemMeta), x, y, z, renderer, world);
                }
            }
            if ((meta = world.func_72805_g(x, y, z)) == 0 && world.func_72798_a(x, y + 1, z) == 0) {
                renderer.func_83020_a(0.1875, 0.0, 0.1875, 0.8125, 0.125, 0.8125);
                renderer.func_78570_q(block, x, y + 1, z);
            }
            renderer.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            renderer.func_78570_q(block, x, y, z);
        }
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return tankModelID;
    }

    private void renderDoRe(RenderBlocks renderblocks, Block block, int meta) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderblocks.func_78613_a(block, 0.0, 0.0, 0.0, block.func_71858_a(0, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderblocks.func_78617_b(block, 0.0, 0.0, 0.0, block.func_71858_a(1, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderblocks.func_78611_c(block, 0.0, 0.0, 0.0, block.func_71858_a(2, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderblocks.func_78622_d(block, 0.0, 0.0, 0.0, block.func_71858_a(3, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderblocks.func_78573_e(block, 0.0, 0.0, 0.0, block.func_71858_a(4, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderblocks.func_78605_f(block, 0.0, 0.0, 0.0, block.func_71858_a(5, meta));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }
}

