/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.client.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import mods.tinker.tconstruct.blocks.logic.SmelteryLogic;
import mods.tinker.tconstruct.client.TProxyClient;
import mods.tinker.tconstruct.client.block.BlockSkinRenderHelper;
import mods.tinker.tconstruct.library.crafting.Smeltery;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.liquids.LiquidStack;

public class SmelteryRender
implements ISimpleBlockRenderingHandler {
    public static int smelteryModel = RenderingRegistry.getNextAvailableRenderId();

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (modelID == smelteryModel) {
            TProxyClient.renderStandardInvBlock(renderer, block, metadata);
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelID, RenderBlocks renderer) {
        if (modelID == smelteryModel) {
            if (world.func_72805_g(x, y, z) == 0) {
                return this.renderSmeltery(world, x, y, z, block, modelID, renderer);
            }
            renderer.func_78570_q(block, x, y, z);
        }
        return true;
    }

    public boolean renderSmeltery(IBlockAccess world, int x, int y, int z, Block block, int modelID, RenderBlocks renderer) {
        renderer.func_78570_q(block, x, y, z);
        SmelteryLogic logic = (SmelteryLogic)world.func_72796_p(x, y, z);
        if (logic.validStructure) {
            int posX = logic.centerPos.x - 1;
            int posY = logic.centerPos.y;
            int posZ = logic.centerPos.z - 1;
            if (logic.func_70302_i_() > 0) {
                for (int i = 0; i < logic.layers; ++i) {
                    this.renderLayer(logic, i * 9, posX, posY + i, posZ, renderer, world);
                }
            }
            float base = 0.0f;
            int yBase = 0;
            int liquidBase = 0;
            for (LiquidStack liquid : logic.moltenMetal) {
                int liquidSize = liquid.amount;
                while (liquidSize > 0) {
                    float maxZ;
                    float maxX;
                    float minZ;
                    float minX;
                    int i;
                    int room = 20000 - liquidBase;
                    int countSize = liquidSize > room ? room : liquidSize;
                    liquidSize -= countSize;
                    float height = countSize > 20000 ? 1.0f : (float)countSize / 20000.0f;
                    float renderBase = base;
                    float renderHeight = height + base;
                    base += height;
                    liquidBase += countSize;
                    if (liquid.itemID < 4096) {
                        Block liquidBlock = Block.field_71973_m[liquid.itemID];
                        for (i = 0; i < 9; ++i) {
                            minX = i % 3 == 0 ? -0.001f : 0.0f;
                            minZ = i / 3 == 0 ? -0.001f : 0.0f;
                            maxX = i % 3 == 2 ? 1.001f : 1.0f;
                            maxZ = i / 3 == 2 ? 1.001f : 1.0f;
                            renderer.func_83020_a((double)minX, (double)renderBase, (double)minZ, (double)maxX, (double)renderHeight, (double)maxZ);
                            BlockSkinRenderHelper.renderMetadataBlock(liquidBlock, liquid.itemMeta, posX + i % 3, posY + yBase, posZ + i / 3, renderer, world);
                        }
                    } else {
                        Item liquidItem = Item.field_77698_e[liquid.itemID];
                        for (i = 0; i < 9; ++i) {
                            minX = i % 3 == 0 ? -0.001f : 0.0f;
                            minZ = i / 3 == 0 ? -0.001f : 0.0f;
                            maxX = i % 3 == 2 ? 1.001f : 1.0f;
                            maxZ = i / 3 == 2 ? 1.001f : 1.0f;
                            renderer.func_83020_a((double)minX, (double)renderBase, (double)minZ, (double)maxX, (double)renderHeight, (double)maxZ);
                            BlockSkinRenderHelper.renderFakeBlock(liquidItem.func_77617_a(liquid.itemMeta), posX, posY + yBase, posZ, renderer, world);
                        }
                    }
                    if (countSize != room) continue;
                    base = 0.0f;
                    ++yBase;
                    liquidBase = 0;
                }
            }
        }
        return true;
    }

    void renderLayer(SmelteryLogic logic, int start, int posX, int posY, int posZ, RenderBlocks renderer, IBlockAccess world) {
        renderer.func_83020_a((double)-0.001f, (double)-0.001f, (double)-0.001f, (double)1.001f, (double)1.001f, (double)1.001f);
        for (int i = 0; i < 9; ++i) {
            ItemStack blockToRender;
            ItemStack input = logic.func_70301_a(i + start);
            if (input == null || logic.getTempForSlot(i + start) <= 20 || (blockToRender = Smeltery.getRenderIndex(input)) == null) continue;
            float blockHeight = (float)input.field_77994_a / (float)blockToRender.field_77994_a;
            renderer.func_83020_a(0.0, 0.0, 0.0, 1.0, (double)MathHelper.func_76131_a((float)blockHeight, (float)0.01f, (float)1.0f), 1.0);
            if (blockToRender.field_77993_c < 4096) {
                Block liquidBlock = Block.field_71973_m[blockToRender.field_77993_c];
                BlockSkinRenderHelper.renderMetadataBlock(liquidBlock, blockToRender.func_77960_j(), posX + i % 3, posY, posZ + i / 3, renderer, world);
                continue;
            }
            Item liquidItem = Item.field_77698_e[blockToRender.field_77993_c];
            int metadata = blockToRender.func_77960_j();
            BlockSkinRenderHelper.renderFakeBlock(liquidItem.func_77617_a(metadata), posX + i % 3, posY, posZ + i / 3, renderer, world);
        }
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return smelteryModel;
    }
}

