/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.blocks.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.tinker.tconstruct.library.blocks.InventoryLogic;
import mods.tinker.tconstruct.library.crafting.DryingRackRecipes;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class DryingRackLogic
extends InventoryLogic {
    int currentTime;
    int maxTime;

    public DryingRackLogic() {
        super(1);
    }

    @Override
    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return null;
    }

    @Override
    protected String getDefaultName() {
        return "";
    }

    public void func_70316_g() {
        if (this.maxTime > 0 && this.currentTime < this.maxTime) {
            ++this.currentTime;
            if (this.currentTime >= this.maxTime) {
                this.inventory[0] = DryingRackRecipes.getDryingResult(this.inventory[0]);
                this.updateDryingTime();
            }
        }
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        super.func_70299_a(slot, itemstack);
        this.updateDryingTime();
    }

    @Override
    public ItemStack func_70298_a(int slot, int quantity) {
        ItemStack stack = super.func_70298_a(slot, quantity);
        this.maxTime = 0;
        this.currentTime = 0;
        return stack;
    }

    public void updateDryingTime() {
        this.currentTime = 0;
        this.maxTime = this.inventory[0] != null ? DryingRackRecipes.getDryingTime(this.inventory[0]) : 0;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70307_a(NBTTagCompound tags) {
        tags.func_74768_a("Time", this.currentTime);
        tags.func_74768_a("MaxTime", this.maxTime);
        this.readCustomNBT(tags);
    }

    @Override
    public void func_70310_b(NBTTagCompound tags) {
        this.currentTime = tags.func_74762_e("Time");
        this.maxTime = tags.func_74762_e("MaxTime");
        this.writeCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        super.func_70307_a(tags);
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        super.func_70310_b(tags);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.readCustomNBT(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB cbb = AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, (double)(this.field_70330_m - 1), (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 1), (double)(this.field_70327_n + 1));
        return cbb;
    }
}

