/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.blocks.logic;

import mods.tinker.tconstruct.inventory.DrawbridgeContainer;
import mods.tinker.tconstruct.library.TConstructRegistry;
import mods.tinker.tconstruct.library.blocks.InventoryLogic;
import mods.tinker.tconstruct.library.util.IActiveLogic;
import mods.tinker.tconstruct.library.util.IFacingLogic;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class DrawbridgeLogic
extends InventoryLogic
implements IFacingLogic,
IActiveLogic {
    boolean active;
    boolean working;
    int ticks;
    byte extension;
    byte direction;

    public DrawbridgeLogic() {
        super(2);
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean flag) {
        this.active = flag;
        this.working = true;
    }

    @Override
    public byte getRenderDirection() {
        return this.direction;
    }

    @Override
    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    @Override
    public void setDirection(int side) {
    }

    @Override
    public void setDirection(float yaw, float pitch, EntityLiving player) {
        if (pitch > 45.0f) {
            this.direction = 1;
        } else if (pitch < -45.0f) {
            this.direction = 0;
        } else {
            int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
            switch (facing) {
                case 0: {
                    this.direction = (byte)2;
                    break;
                }
                case 1: {
                    this.direction = (byte)5;
                    break;
                }
                case 2: {
                    this.direction = (byte)3;
                    break;
                }
                case 3: {
                    this.direction = (byte)4;
                }
            }
        }
    }

    @Override
    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return new DrawbridgeContainer(inventoryplayer, this);
    }

    @Override
    protected String getDefaultName() {
        return "tinker.drawbridge";
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        super.func_70299_a(slot, itemstack);
        if (slot == 1) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @Override
    public ItemStack func_70298_a(int slot, int quantity) {
        ItemStack stack = super.func_70298_a(slot, quantity);
        if (slot == 1) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        return stack;
    }

    public void func_70316_g() {
        if (this.working) {
            ++this.ticks;
            if (this.ticks == 5) {
                this.ticks = 0;
                if (this.active) {
                    if (this.inventory[0] != null && this.inventory[0].field_77994_a > 1 && this.extension < 15) {
                        this.extension = (byte)(this.extension + 1);
                        int xPos = this.field_70329_l;
                        int yPos = this.field_70330_m;
                        int zPos = this.field_70327_n;
                        switch (this.direction) {
                            case 0: {
                                yPos -= this.extension;
                                break;
                            }
                            case 1: {
                                yPos += this.extension;
                                break;
                            }
                            case 2: {
                                zPos -= this.extension;
                                break;
                            }
                            case 3: {
                                zPos += this.extension;
                                break;
                            }
                            case 4: {
                                xPos -= this.extension;
                                break;
                            }
                            case 5: {
                                xPos += this.extension;
                            }
                        }
                        Block block = Block.field_71973_m[this.field_70331_k.func_72798_a(xPos, yPos, zPos)];
                        if (block == null || block.isAirBlock(this.field_70331_k, xPos, yPos, zPos) || block.isBlockReplaceable(this.field_70331_k, xPos, yPos, zPos)) {
                            int blockToItem = TConstructRegistry.blockToItemMapping[this.inventory[0].field_77993_c];
                            if (blockToItem == 0) {
                                if (this.inventory[0].field_77993_c >= 4096 || Block.field_71973_m[this.inventory[0].field_77993_c] == null) {
                                    return;
                                }
                                this.field_70331_k.func_72832_d(xPos, yPos, zPos, this.inventory[0].field_77993_c, this.inventory[0].func_77960_j(), 3);
                            } else {
                                this.field_70331_k.func_72832_d(xPos, yPos, zPos, blockToItem, this.inventory[0].func_77960_j(), 3);
                            }
                            this.field_70331_k.func_72908_a((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5, "tile.piston.out", 0.25f, this.field_70331_k.field_73012_v.nextFloat() * 0.25f + 0.6f);
                            --this.inventory[0].field_77994_a;
                        } else {
                            this.extension = (byte)(this.extension - 1);
                            this.working = false;
                        }
                    } else {
                        this.working = false;
                    }
                } else if ((this.inventory[0] == null || this.inventory[0].field_77994_a < this.inventory[0].func_77976_d()) && this.extension > 0) {
                    int xPos = this.field_70329_l;
                    int yPos = this.field_70330_m;
                    int zPos = this.field_70327_n;
                    switch (this.direction) {
                        case 0: {
                            yPos -= this.extension;
                            break;
                        }
                        case 1: {
                            yPos += this.extension;
                            break;
                        }
                        case 2: {
                            zPos -= this.extension;
                            break;
                        }
                        case 3: {
                            zPos += this.extension;
                            break;
                        }
                        case 4: {
                            xPos -= this.extension;
                            break;
                        }
                        case 5: {
                            xPos += this.extension;
                        }
                    }
                    Block block = Block.field_71973_m[this.field_70331_k.func_72798_a(xPos, yPos, zPos)];
                    if (block != null) {
                        int meta = this.field_70331_k.func_72805_g(xPos, yPos, zPos);
                        if (this.inventory[0] != null && this.validBlock(block) && this.validMetadata(block.field_71990_ca, meta)) {
                            this.field_70331_k.func_72908_a((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5, "tile.piston.in", 0.25f, this.field_70331_k.field_73012_v.nextFloat() * 0.15f + 0.6f);
                            this.field_70331_k.func_94575_c(xPos, yPos, zPos, 0);
                            ++this.inventory[0].field_77994_a;
                        } else {
                            this.working = false;
                        }
                    }
                    this.extension = (byte)(this.extension - 1);
                } else {
                    this.working = false;
                }
            }
        }
    }

    boolean validBlock(Block block) {
        int type = TConstructRegistry.interchangableBlockMapping[block.field_71990_ca];
        if (type != 0 && type == this.inventory[0].field_77993_c) {
            return true;
        }
        int blockToItem = TConstructRegistry.blockToItemMapping[block.field_71990_ca];
        if (blockToItem != 0 && blockToItem == this.inventory[0].field_77993_c) {
            return true;
        }
        return block.field_71990_ca == this.inventory[0].field_77993_c;
    }

    boolean validMetadata(int blockID, int metadata) {
        int type = TConstructRegistry.drawbridgeState[blockID];
        if (type == 0) {
            return metadata == this.inventory[0].func_77960_j();
        }
        if (type == 1) {
            return true;
        }
        if (type == 2) {
            return false;
        }
        if (type == 3) {
            return true;
        }
        if (type == 4) {
            return true;
        }
        if (type == 5) {
            return metadata == this.inventory[0].func_77960_j();
        }
        return false;
    }

    @Override
    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.active = tags.func_74767_n("Active");
        this.working = tags.func_74767_n("Working");
        this.extension = tags.func_74771_c("Extension");
        this.readCustomNBT(tags);
    }

    @Override
    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        tags.func_74757_a("Active", this.active);
        tags.func_74757_a("Working", this.working);
        tags.func_74774_a("Extension", this.extension);
        this.writeCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.direction = tags.func_74771_c("Direction");
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74774_a("Direction", this.direction);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean hasExtended() {
        return this.extension != 0;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }
}

