/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.blocks;

import java.util.List;
import mods.tinker.tconstruct.TConstruct;
import mods.tinker.tconstruct.blocks.logic.DrawbridgeLogic;
import mods.tinker.tconstruct.blocks.logic.FirestarterLogic;
import mods.tinker.tconstruct.client.block.MachineRender;
import mods.tinker.tconstruct.common.TProxyCommon;
import mods.tinker.tconstruct.library.TConstructRegistry;
import mods.tinker.tconstruct.library.blocks.InventoryBlock;
import mods.tinker.tconstruct.library.util.IActiveLogic;
import mods.tinker.tconstruct.library.util.IFacingLogic;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class RedstoneMachine
extends InventoryBlock {
    public RedstoneMachine(int id) {
        super(id, Material.field_76243_f);
        this.func_71849_a(TConstructRegistry.blockTab);
        this.func_71848_c(12.0f);
        this.func_71884_a(field_71977_i);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity logic;
        if (world.func_72805_g(x, y, z) == 0 && (logic = world.func_72796_p(x, y, z)) != null && logic instanceof IInventory && ((IInventory)logic).func_70301_a(1) != null) {
            return field_71984_q[((IInventory)logic).func_70301_a((int)1).field_77993_c];
        }
        return super.getLightValue(world, x, y, z);
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new DrawbridgeLogic();
            }
            case 1: {
                return new FirestarterLogic();
            }
        }
        return null;
    }

    @Override
    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        int meta = world.func_72805_g(x, y, z);
        switch (meta) {
            case 0: {
                return TProxyCommon.drawbridgeGui;
            }
        }
        return null;
    }

    @Override
    public Object getModInstance() {
        return TConstruct.instance;
    }

    @Override
    public String[] getTextureNames() {
        String[] textureNames = new String[]{"drawbridge_top", "drawbridge_side", "drawbridge_bottom", "drawbridge_top_face", "drawbridge_side_face", "drawbridge_bottom_face", "firestarter_top", "firestarter_side", "firestarter_bottom"};
        return textureNames;
    }

    @Override
    public void func_94332_a(IconRegister iconRegister) {
        String[] textureNames = this.getTextureNames();
        this.icons = new Icon[textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("tinker:machines/" + textureNames[i]);
        }
    }

    public Icon func_71858_a(int side, int meta) {
        if (meta == 0) {
            if (side == 5) {
                return this.icons[5];
            }
            return this.icons[this.getTextureIndex(side)];
        }
        if (meta == 1) {
            return this.icons[this.getTextureIndex(side) + 6];
        }
        return this.icons[0];
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity logic = world.func_72796_p(x, y, z);
        int direction = logic instanceof IFacingLogic ? (int)((IFacingLogic)logic).getRenderDirection() : 0;
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0) {
            Block block;
            DrawbridgeLogic drawbridge = (DrawbridgeLogic)logic;
            ItemStack stack = drawbridge.func_70301_a(1);
            if (stack != null && stack.field_77993_c < 4096 && (block = Block.field_71973_m[stack.field_77993_c]) != null && block.func_71886_c()) {
                return block.func_71858_a(side, stack.func_77960_j());
            }
            if (side == direction) {
                return this.icons[this.getTextureIndex(side) + 3];
            }
            return this.icons[this.getTextureIndex(side)];
        }
        if (meta == 1) {
            if (side == direction) {
                return this.icons[6];
            }
            if (side / 2 == direction / 2) {
                return this.icons[8];
            }
            return this.icons[7];
        }
        return this.icons[0];
    }

    public int getTextureIndex(int side) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 0;
        }
        return 1;
    }

    public int func_71857_b() {
        return MachineRender.model;
    }

    public boolean isFireSource(World world, int x, int y, int z, int metadata, ForgeDirection side) {
        if (metadata == 1) {
            return side == ForgeDirection.UP;
        }
        return false;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 2; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    public void func_71863_a(World world, int x, int y, int z, int neighborBlockID) {
        IActiveLogic logic = (IActiveLogic)world.func_72796_p(x, y, z);
        logic.setActive(world.func_72864_z(x, y, z));
    }
}

