/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.blocks;

import java.util.Random;
import mods.tinker.tconstruct.blocks.LiquidMetalBase;
import mods.tinker.tconstruct.blocks.logic.LiquidTextureLogic;
import mods.tinker.tconstruct.common.TContent;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.liquids.ILiquid;

public class LiquidMetalFlowing
extends LiquidMetalBase
implements ILiquid {
    boolean[] isOptimalFlowDirection = new boolean[4];
    int[] flowCost = new int[4];

    public LiquidMetalFlowing(int id) {
        super(id, TContent.liquidMetal);
    }

    private void updateFlow(World world, int x, int y, int z) {
        int tex = ((LiquidTextureLogic)world.func_72796_p(x, y, z)).getLiquidType();
        int meta = world.func_72805_g(x, y, z);
        world.func_72832_d(x, y, z, this.stillLiquidId(), meta, 3);
        world.func_72909_d(x, y, z, x, y, z);
        world.func_72845_h(x, y, z);
        ((LiquidTextureLogic)world.func_72796_p(x, y, z)).setLiquidType(tex);
    }

    public void func_71847_b(World world, int x, int y, int z, Random random) {
        int tex = ((LiquidTextureLogic)world.func_72796_p(x, y, z)).getLiquidType();
        int flow = this.getFlowDecay(world, x, y, z);
        int byte0 = 1;
        boolean flag = true;
        if (flow > 0) {
            int i1 = -100;
            i1 = this.getSmallestFlowDecay(world, x - 1, y, z, i1);
            i1 = this.getSmallestFlowDecay(world, x + 1, y, z, i1);
            i1 = this.getSmallestFlowDecay(world, x, y, z - 1, i1);
            int j1 = (i1 = this.getSmallestFlowDecay(world, x, y, z + 1, i1)) + byte0;
            if (j1 >= 8 || i1 < 0) {
                j1 = -1;
            }
            if (this.getFlowDecay(world, x, y + 1, z) >= 0) {
                int l1 = this.getFlowDecay(world, x, y + 1, z);
                j1 = l1 >= 8 ? l1 : l1 + 8;
            }
            if (j1 != flow) {
                flow = j1;
                if (flow < 0) {
                    world.func_94571_i(x, y, z);
                } else {
                    world.func_72921_c(x, y, z, flow, 2);
                    world.func_72836_a(x, y, z, this.field_71990_ca, this.tickRate());
                    world.func_72898_h(x, y, z, this.field_71990_ca);
                }
            } else if (flag) {
                this.updateFlow(world, x, y, z);
            }
        } else {
            this.updateFlow(world, x, y, z);
        }
        if (this.liquidCanDisplaceBlock(world, x, y - 1, z)) {
            if (flow >= 8) {
                world.func_72832_d(x, y - 1, z, this.field_71990_ca, flow, 3);
            } else {
                world.func_72832_d(x, y - 1, z, this.field_71990_ca, flow + 8, 3);
            }
            ((LiquidTextureLogic)world.func_72796_p(x, y - 1, z)).setLiquidType(tex);
        } else if (flow >= 0 && (flow == 0 || this.blockBlocksFlow(world, x, y - 1, z))) {
            boolean[] aflag = this.getOptimalFlowDirections(world, x, y, z);
            int k1 = flow + byte0;
            if (flow >= 8) {
                k1 = 1;
            }
            if (k1 >= 8) {
                return;
            }
            if (aflag[0]) {
                this.flowIntoBlock(world, x - 1, y, z, k1, tex);
            }
            if (aflag[1]) {
                this.flowIntoBlock(world, x + 1, y, z, k1, tex);
            }
            if (aflag[2]) {
                this.flowIntoBlock(world, x, y, z - 1, k1, tex);
            }
            if (aflag[3]) {
                this.flowIntoBlock(world, x, y, z + 1, k1, tex);
            }
        }
    }

    private void flowIntoBlock(World world, int x, int y, int z, int meta, int tex) {
        if (this.liquidCanDisplaceBlock(world, x, y, z)) {
            int bID = world.func_72798_a(x, y, z);
            if (bID > 0) {
                Block.field_71973_m[bID].func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
            }
            world.func_72832_d(x, y, z, this.field_71990_ca, meta, 3);
            ((LiquidTextureLogic)world.func_72796_p(x, y, z)).setLiquidType(tex);
        }
    }

    private int calculateFlowCost(World world, int x, int y, int z, int l, int i1) {
        int j1 = 1000;
        for (int k1 = 0; k1 < 4; ++k1) {
            int k2;
            if (k1 == 0 && i1 == 1 || k1 == 1 && i1 == 0 || k1 == 2 && i1 == 3 || k1 == 3 && i1 == 2) continue;
            int posX = x;
            int posY = y;
            int posZ = z;
            if (k1 == 0) {
                --posX;
            }
            if (k1 == 1) {
                ++posX;
            }
            if (k1 == 2) {
                --posZ;
            }
            if (k1 == 3) {
                ++posZ;
            }
            if (this.blockBlocksFlow(world, posX, posY, posZ) || world.func_72803_f(posX, posY, posZ) == this.field_72018_cp && world.func_72805_g(posX, posY, posZ) == 0) continue;
            if (!this.blockBlocksFlow(world, posX, posY - 1, posZ)) {
                return l;
            }
            if (l >= 4 || (k2 = this.calculateFlowCost(world, posX, posY, posZ, l + 1, k1)) >= j1) continue;
            j1 = k2;
        }
        return j1;
    }

    private boolean[] getOptimalFlowDirections(World world, int x, int y, int z) {
        for (int iter = 0; iter < 4; ++iter) {
            this.flowCost[iter] = 1000;
            int posX = x;
            int posY = y;
            int posZ = z;
            if (iter == 0) {
                --posX;
            }
            if (iter == 1) {
                ++posX;
            }
            if (iter == 2) {
                --posZ;
            }
            if (iter == 3) {
                ++posZ;
            }
            if (this.blockBlocksFlow(world, posX, posY, posZ) || world.func_72803_f(posX, posY, posZ) == this.field_72018_cp && world.func_72805_g(posX, posY, posZ) == 0) continue;
            this.flowCost[iter] = !this.blockBlocksFlow(world, posX, posY - 1, posZ) ? 0 : this.calculateFlowCost(world, posX, posY, posZ, 1, iter);
        }
        int cost = this.flowCost[0];
        for (int k1 = 1; k1 < 4; ++k1) {
            if (this.flowCost[k1] >= cost) continue;
            cost = this.flowCost[k1];
        }
        for (int l1 = 0; l1 < 4; ++l1) {
            this.isOptimalFlowDirection[l1] = this.flowCost[l1] == cost;
        }
        return this.isOptimalFlowDirection;
    }

    private boolean blockBlocksFlow(World world, int x, int y, int z) {
        int l = world.func_72798_a(x, y, z);
        if (l == Block.field_72054_aE.field_71990_ca || l == Block.field_72045_aL.field_71990_ca || l == Block.field_72053_aD.field_71990_ca || l == Block.field_72055_aF.field_71990_ca || l == Block.field_72040_aX.field_71990_ca) {
            return true;
        }
        if (l == 0) {
            return false;
        }
        Material material = Block.field_71973_m[l].field_72018_cp;
        return material.func_76220_a();
    }

    protected int getSmallestFlowDecay(World world, int x, int y, int z, int l) {
        int i1 = this.getFlowDecay(world, x, y, z);
        if (i1 < 0) {
            return l;
        }
        if (i1 >= 8) {
            i1 = 0;
        }
        return l >= 0 && i1 >= l ? l : i1;
    }

    private boolean liquidCanDisplaceBlock(World world, int x, int y, int z) {
        Material material = world.func_72803_f(x, y, z);
        if (material == this.field_72018_cp) {
            return false;
        }
        return !this.blockBlocksFlow(world, x, y, z);
    }

    public void func_71861_g(World world, int x, int y, int z) {
        super.func_71861_g(world, x, y, z);
        if (world.func_72798_a(x, y, z) == this.field_71990_ca) {
            world.func_72836_a(x, y, z, this.field_71990_ca, this.tickRate());
        }
    }

    public int stillLiquidMeta() {
        return 0;
    }

    public boolean isMetaSensitive() {
        return false;
    }

    public int stillLiquidId() {
        return TContent.liquidMetalStill.field_71990_ca;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new LiquidTextureLogic();
    }
}

