/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class OreDictionary {
    private static boolean hasInit = false;
    private static int maxID = 0;
    private static HashMap<String, Integer> oreIDs = new HashMap();
    private static HashMap<Integer, ArrayList<wm>> oreStacks = new HashMap();
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    public static void initVanillaEntries() {
        if (!hasInit) {
            OreDictionary.registerOre("logWood", new wm(apa.N, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("plankWood", new wm(apa.B, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("slabWood", new wm((apa)apa.bS, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("stairWood", apa.ax);
            OreDictionary.registerOre("stairWood", apa.cb);
            OreDictionary.registerOre("stairWood", apa.cc);
            OreDictionary.registerOre("stairWood", apa.ca);
            OreDictionary.registerOre("stickWood", wk.E);
            OreDictionary.registerOre("treeSapling", new wm(apa.C, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new wm((apa)((Object)apa.O), 1, Short.MAX_VALUE));
            OreDictionary.registerOre("oreGold", apa.K);
            OreDictionary.registerOre("oreIron", apa.L);
            OreDictionary.registerOre("oreLapis", apa.R);
            OreDictionary.registerOre("oreDiamond", apa.aA);
            OreDictionary.registerOre("oreRedstone", apa.aR);
            OreDictionary.registerOre("oreEmerald", apa.bV);
            OreDictionary.registerOre("oreQuartz", apa.ct);
        }
        HashMap<wm, String> replacements = new HashMap<wm, String>();
        replacements.put(new wm(apa.B, 1, Short.MAX_VALUE), "plankWood");
        replacements.put(new wm(wk.E), "stickWood");
        String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        for (int i2 = 0; i2 < 16; ++i2) {
            wm dye = new wm(wk.aX, 1, i2);
            if (!hasInit) {
                OreDictionary.registerOre(dyes[i2], dye);
            }
            replacements.put(dye, dyes[i2]);
        }
        hasInit = true;
        wm[] replaceStacks = replacements.keySet().toArray(new wm[replacements.keySet().size()]);
        wm[] exclusions = new wm[]{new wm(apa.S), new wm(wk.bd)};
        List recipes = yk.a().b();
        ArrayList<Object> recipesToRemove = new ArrayList<Object>();
        ArrayList<Object> recipesToAdd = new ArrayList<Object>();
        for (Object obj : recipes) {
            wm output;
            yn recipe;
            if (obj instanceof yn) {
                recipe = (yn)obj;
                output = recipe.b();
                if (output != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.d, replaceStacks)) continue;
                recipesToRemove.add(recipe);
                recipesToAdd.add(new ShapedOreRecipe(recipe, replacements));
                continue;
            }
            if (!(obj instanceof yo) || (output = (recipe = (yo)obj).b()) != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.b.toArray(new wm[recipe.b.size()]), replaceStacks)) continue;
            recipesToRemove.add((ym)obj);
            ShapelessOreRecipe newRecipe = new ShapelessOreRecipe((yo)recipe, replacements);
            recipesToAdd.add(newRecipe);
        }
        recipes.removeAll(recipesToRemove);
        recipes.addAll(recipesToAdd);
        if (recipesToRemove.size() > 0) {
            System.out.println("Replaced " + recipesToRemove.size() + " ore recipies");
        }
    }

    public static int getOreID(String name) {
        Integer val = oreIDs.get(name);
        if (val == null) {
            val = maxID++;
            oreIDs.put(name, val);
            oreStacks.put(val, new ArrayList());
        }
        return val;
    }

    public static String getOreName(int id2) {
        for (Map.Entry<String, Integer> entry : oreIDs.entrySet()) {
            if (id2 != entry.getValue()) continue;
            return entry.getKey();
        }
        return "Unknown";
    }

    public static int getOreID(wm itemStack) {
        if (itemStack == null) {
            return -1;
        }
        for (Map.Entry<Integer, ArrayList<wm>> ore : oreStacks.entrySet()) {
            for (wm target : ore.getValue()) {
                if (itemStack.c != target.c || target.k() != Short.MAX_VALUE && itemStack.k() != target.k()) continue;
                return ore.getKey();
            }
        }
        return -1;
    }

    public static ArrayList<wm> getOres(String name) {
        return OreDictionary.getOres(OreDictionary.getOreID(name));
    }

    public static String[] getOreNames() {
        return oreIDs.keySet().toArray(new String[oreIDs.keySet().size()]);
    }

    public static ArrayList<wm> getOres(Integer id2) {
        ArrayList<wm> val = oreStacks.get(id2);
        if (val == null) {
            val = new ArrayList();
            oreStacks.put(id2, val);
        }
        return val;
    }

    private static boolean containsMatch(boolean strict, wm[] inputs, wm ... targets) {
        for (wm input : inputs) {
            for (wm target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean itemMatches(wm target, wm input, boolean strict) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.c == input.c && (target.k() == Short.MAX_VALUE && !strict || target.k() == input.k());
    }

    public static void registerOre(String name, wk ore) {
        OreDictionary.registerOre(name, new wm(ore));
    }

    public static void registerOre(String name, apa ore) {
        OreDictionary.registerOre(name, new wm(ore));
    }

    public static void registerOre(String name, wm ore) {
        OreDictionary.registerOre(name, OreDictionary.getOreID(name), ore);
    }

    public static void registerOre(int id2, wk ore) {
        OreDictionary.registerOre(id2, new wm(ore));
    }

    public static void registerOre(int id2, apa ore) {
        OreDictionary.registerOre(id2, new wm(ore));
    }

    public static void registerOre(int id2, wm ore) {
        OreDictionary.registerOre(OreDictionary.getOreName(id2), id2, ore);
    }

    private static void registerOre(String name, int id2, wm ore) {
        ArrayList<wm> ores = OreDictionary.getOres(id2);
        ore = ore.m();
        ores.add(ore);
        MinecraftForge.EVENT_BUS.post(new OreRegisterEvent(name, ore));
    }

    static {
        OreDictionary.initVanillaEntries();
    }

    public static class OreRegisterEvent
    extends Event {
        public final String Name;
        public final wm Ore;

        public OreRegisterEvent(String name, wm ore) {
            this.Name = name;
            this.Ore = ore;
        }
    }
}

