/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import net.minecraftforge.common.ForgeDirection;

public class RotationHelper {
    private static final ForgeDirection[] UP_DOWN_AXES = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};

    public static ForgeDirection[] getValidVanillaBlockRotations(apa block) {
        return block instanceof aln ? UP_DOWN_AXES : ForgeDirection.VALID_DIRECTIONS;
    }

    public static boolean rotateVanillaBlock(apa block, aab worldObj, int x, int y2, int z2, ForgeDirection axis) {
        if (worldObj.I) {
            return false;
        }
        if (block instanceof aln && (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN)) {
            return RotationHelper.rotateBlock(worldObj, x, y2, z2, axis, 7);
        }
        if (block instanceof aqt || block instanceof amd || block instanceof amb) {
            return RotationHelper.rotateBlock(worldObj, x, y2, z2, axis, 7);
        }
        return false;
    }

    private static boolean rotateBlock(aab worldObj, int x, int y2, int z2, ForgeDirection axis, int mask) {
        int rotMeta = worldObj.h(x, y2, z2);
        int masked = rotMeta & ~mask;
        ForgeDirection orientation = ForgeDirection.getOrientation(rotMeta & mask);
        ForgeDirection rotated = orientation.getRotation(axis);
        worldObj.b(x, y2, z2, rotated.ordinal() & mask | masked, 3);
        return true;
    }
}

