/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.network.FMLPacket;
import cpw.mods.fml.common.network.IChatListener;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.NetworkModHandler;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;

public class NetworkRegistry {
    private static final NetworkRegistry INSTANCE = new NetworkRegistry();
    private Multimap<Player, String> activeChannels = ArrayListMultimap.create();
    private Multimap<String, IPacketHandler> universalPacketHandlers = ArrayListMultimap.create();
    private Multimap<String, IPacketHandler> clientPacketHandlers = ArrayListMultimap.create();
    private Multimap<String, IPacketHandler> serverPacketHandlers = ArrayListMultimap.create();
    private Set<IConnectionHandler> connectionHandlers = Sets.newLinkedHashSet();
    private Map<ModContainer, IGuiHandler> serverGuiHandlers = Maps.newHashMap();
    private Map<ModContainer, IGuiHandler> clientGuiHandlers = Maps.newHashMap();
    private List<IChatListener> chatListeners = Lists.newArrayList();

    public static NetworkRegistry instance() {
        return INSTANCE;
    }

    byte[] getPacketRegistry(Side side) {
        return Joiner.on((char)'\u0000').join(Iterables.concat(Arrays.asList("FML"), (Iterable)this.universalPacketHandlers.keySet(), (Iterable)(side.isClient() ? this.clientPacketHandlers.keySet() : this.serverPacketHandlers.keySet()))).getBytes(Charsets.UTF_8);
    }

    public boolean isChannelActive(String channel, Player player) {
        return this.activeChannels.containsEntry((Object)player, (Object)channel);
    }

    public void registerChannel(IPacketHandler handler, String channelName) {
        if (Strings.isNullOrEmpty((String)channelName) || channelName != null && channelName.length() > 16) {
            FMLLog.severe("Invalid channel name '%s' : %s", channelName, Strings.isNullOrEmpty((String)channelName) ? "Channel name is empty" : "Channel name is too long (16 chars is maximum)");
            throw new RuntimeException("Channel name is invalid");
        }
        this.universalPacketHandlers.put((Object)channelName, (Object)handler);
    }

    public void registerChannel(IPacketHandler handler, String channelName, Side side) {
        if (side == null) {
            this.registerChannel(handler, channelName);
            return;
        }
        if (Strings.isNullOrEmpty((String)channelName) || channelName != null && channelName.length() > 16) {
            FMLLog.severe("Invalid channel name '%s' : %s", channelName, Strings.isNullOrEmpty((String)channelName) ? "Channel name is empty" : "Channel name is too long (16 chars is maximum)");
            throw new RuntimeException("Channel name is invalid");
        }
        if (side.isClient()) {
            this.clientPacketHandlers.put((Object)channelName, (Object)handler);
        } else {
            this.serverPacketHandlers.put((Object)channelName, (Object)handler);
        }
    }

    void activateChannel(Player player, String channel) {
        this.activeChannels.put((Object)player, (Object)channel);
    }

    void deactivateChannel(Player player, String channel) {
        this.activeChannels.remove((Object)player, (Object)channel);
    }

    public void registerConnectionHandler(IConnectionHandler handler) {
        this.connectionHandlers.add(handler);
    }

    public void registerChatListener(IChatListener listener) {
        this.chatListeners.add(listener);
    }

    void playerLoggedIn(jc player, jh netHandler, cg manager) {
        this.generateChannelRegistration(player, netHandler, manager);
        for (IConnectionHandler handler : this.connectionHandlers) {
            handler.playerLoggedIn((Player)((Object)player), netHandler, manager);
        }
    }

    String connectionReceived(jf netHandler, cg manager) {
        for (IConnectionHandler handler : this.connectionHandlers) {
            String kick = handler.connectionReceived(netHandler, manager);
            if (Strings.isNullOrEmpty((String)kick)) continue;
            return kick;
        }
        return null;
    }

    void connectionOpened(ej netClientHandler, String server, int port, cg networkManager) {
        for (IConnectionHandler handler : this.connectionHandlers) {
            handler.connectionOpened(netClientHandler, server, port, networkManager);
        }
    }

    void connectionOpened(ej netClientHandler, MinecraftServer server, cg networkManager) {
        for (IConnectionHandler handler : this.connectionHandlers) {
            handler.connectionOpened(netClientHandler, server, networkManager);
        }
    }

    void clientLoggedIn(ej clientHandler, cg manager, dz login) {
        this.generateChannelRegistration(clientHandler.getPlayer(), clientHandler, manager);
        for (IConnectionHandler handler : this.connectionHandlers) {
            handler.clientLoggedIn(clientHandler, manager, login);
        }
    }

    void connectionClosed(cg manager, sq player) {
        for (IConnectionHandler handler : this.connectionHandlers) {
            handler.connectionClosed(manager);
        }
        this.activeChannels.removeAll((Object)player);
    }

    void generateChannelRegistration(sq player, ej netHandler, cg manager) {
        dk pkt = new dk();
        pkt.a = "REGISTER";
        pkt.c = this.getPacketRegistry(player instanceof jc ? Side.SERVER : Side.CLIENT);
        pkt.b = pkt.c.length;
        manager.a((ei)pkt);
    }

    void handleCustomPacket(dk packet, cg network, ej handler) {
        if ("REGISTER".equals(packet.a)) {
            this.handleRegistrationPacket(packet, (Player)((Object)handler.getPlayer()));
        } else if ("UNREGISTER".equals(packet.a)) {
            this.handleUnregistrationPacket(packet, (Player)((Object)handler.getPlayer()));
        } else {
            this.handlePacket(packet, network, (Player)((Object)handler.getPlayer()));
        }
    }

    private void handlePacket(dk packet, cg network, Player player) {
        String channel = packet.a;
        for (IPacketHandler handler : Iterables.concat((Iterable)this.universalPacketHandlers.get((Object)channel), (Iterable)(player instanceof jc ? this.serverPacketHandlers.get((Object)channel) : this.clientPacketHandlers.get((Object)channel)))) {
            handler.onPacketData(network, packet, player);
        }
    }

    private void handleRegistrationPacket(dk packet, Player player) {
        List<String> channels = this.extractChannelList(packet);
        for (String channel : channels) {
            this.activateChannel(player, channel);
        }
    }

    private void handleUnregistrationPacket(dk packet, Player player) {
        List<String> channels = this.extractChannelList(packet);
        for (String channel : channels) {
            this.deactivateChannel(player, channel);
        }
    }

    private List<String> extractChannelList(dk packet) {
        String request = new String(packet.c, Charsets.UTF_8);
        ArrayList channels = Lists.newArrayList((Iterable)Splitter.on((char)'\u0000').split((CharSequence)request));
        return channels;
    }

    public void registerGuiHandler(Object mod, IGuiHandler handler) {
        NetworkModHandler nmh;
        ModContainer mc2 = FMLCommonHandler.instance().findContainerFor(mod);
        if (mc2 == null) {
            mc2 = Loader.instance().activeModContainer();
            FMLLog.log(Level.WARNING, "Mod %s attempted to register a gui network handler during a construction phase", mc2.getModId());
        }
        if ((nmh = FMLNetworkHandler.instance().findNetworkModHandler(mc2)) == null) {
            FMLLog.log(Level.FINE, "The mod %s needs to be a @NetworkMod to register a Networked Gui Handler", mc2.getModId());
        } else {
            this.serverGuiHandlers.put(mc2, handler);
        }
        this.clientGuiHandlers.put(mc2, handler);
    }

    void openRemoteGui(ModContainer mc2, jc player, int modGuiId, aab world, int x, int y2, int z2) {
        tj container;
        IGuiHandler handler = this.serverGuiHandlers.get(mc2);
        NetworkModHandler nmh = FMLNetworkHandler.instance().findNetworkModHandler(mc2);
        if (handler != null && nmh != null && (container = (tj)handler.getServerGuiElement(modGuiId, player, world, x, y2, z2)) != null) {
            player.ct();
            player.j();
            int windowId = player.cu;
            dk pkt = new dk();
            pkt.a = "FML";
            pkt.c = FMLPacket.makePacket(FMLPacket.Type.GUIOPEN, windowId, nmh.getNetworkId(), modGuiId, x, y2, z2);
            pkt.b = pkt.c.length;
            player.a.b((ei)pkt);
            player.bM = container;
            player.bM.d = windowId;
            player.bM.a((tp)player);
        }
    }

    void openLocalGui(ModContainer mc2, sq player, int modGuiId, aab world, int x, int y2, int z2) {
        IGuiHandler handler = this.clientGuiHandlers.get(mc2);
        FMLCommonHandler.instance().showGuiScreen(handler.getClientGuiElement(modGuiId, player, world, x, y2, z2));
    }

    public cw handleChat(ej handler, cw chat) {
        Side s2 = Side.CLIENT;
        if (handler instanceof jh) {
            s2 = Side.SERVER;
        }
        for (IChatListener listener : this.chatListeners) {
            chat = s2.isClient() ? listener.clientChat(handler, chat) : listener.serverChat(handler, chat);
        }
        return chat;
    }

    public void handleTinyPacket(ej handler, db mapData) {
        NetworkModHandler nmh = FMLNetworkHandler.instance().findNetworkModHandler(mapData.a);
        if (nmh == null) {
            FMLLog.info("Received a tiny packet for network id %d that is not recognised here", mapData.a);
            return;
        }
        if (nmh.hasTinyPacketHandler()) {
            nmh.getTinyPacketHandler().handle(handler, mapData);
        } else {
            FMLLog.info("Received a tiny packet for a network mod that does not accept tiny packets %s", nmh.getContainer().getModId());
        }
    }
}

