/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.network.FMLPacket;
import cpw.mods.fml.common.network.NetworkModHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModListRequestPacket
extends FMLPacket {
    private List<String> sentModList;
    private byte compatibilityLevel;

    public ModListRequestPacket() {
        super(FMLPacket.Type.MOD_LIST_REQUEST);
    }

    @Override
    public byte[] generatePacket(Object ... data) {
        ByteArrayDataOutput dat = ByteStreams.newDataOutput();
        Set<ModContainer> activeMods = FMLNetworkHandler.instance().getNetworkModList();
        dat.writeInt(activeMods.size());
        for (ModContainer mc2 : activeMods) {
            dat.writeUTF(mc2.getModId());
        }
        dat.writeByte(FMLNetworkHandler.getCompatibilityLevel());
        return dat.toByteArray();
    }

    @Override
    public FMLPacket consumePacket(byte[] data) {
        this.sentModList = Lists.newArrayList();
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
        int listSize = in.readInt();
        for (int i2 = 0; i2 < listSize; ++i2) {
            this.sentModList.add(in.readUTF());
        }
        try {
            this.compatibilityLevel = in.readByte();
        }
        catch (IllegalStateException e2) {
            FMLLog.fine("No compatibility byte found - the server is too old", new Object[0]);
        }
        return this;
    }

    @Override
    public void execute(cg mgr, FMLNetworkHandler handler, ej netHandler, String userName) {
        ArrayList missingMods = Lists.newArrayList();
        HashMap modVersions = Maps.newHashMap();
        HashMap indexedModList = Maps.newHashMap(Loader.instance().getIndexedModList());
        for (String string : this.sentModList) {
            ModContainer mc2 = (ModContainer)indexedModList.get(string);
            if (mc2 == null) {
                missingMods.add(string);
                continue;
            }
            indexedModList.remove(string);
            modVersions.put(string, mc2.getVersion());
        }
        if (indexedModList.size() > 0) {
            for (Map.Entry entry : indexedModList.entrySet()) {
                NetworkModHandler missingHandler;
                if (!((ModContainer)entry.getValue()).isNetworkMod() || !(missingHandler = FMLNetworkHandler.instance().findNetworkModHandler(entry.getValue())).requiresServerSide()) continue;
                FMLLog.warning("The mod %s was not found on the server you connected to, but requested that the server side be present", entry.getKey());
            }
        }
        FMLLog.fine("The server has compatibility level %d", this.compatibilityLevel);
        FMLCommonHandler.instance().getSidedDelegate().setClientCompatibilityLevel(this.compatibilityLevel);
        mgr.a((ei)PacketDispatcher.getPacket("FML", FMLPacket.makePacket(FMLPacket.Type.MOD_LIST_RESPONSE, modVersions, missingMods)));
    }
}

