/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.asm.transformers;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class MCPMerger {
    private static Hashtable<String, ClassInfo> clients = new Hashtable();
    private static Hashtable<String, ClassInfo> shared = new Hashtable();
    private static Hashtable<String, ClassInfo> servers = new Hashtable();
    private static HashSet<String> copyToServer = new HashSet();
    private static HashSet<String> copyToClient = new HashSet();
    private static HashSet<String> dontAnnotate = new HashSet();
    private static final boolean DEBUG = false;

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Usage: MCPMerger <MapFile> <minecraft.jar> <minecraft_server.jar>");
            System.exit(1);
        }
        File map_file = new File(args[0]);
        File client_jar = new File(args[1]);
        File server_jar = new File(args[2]);
        File client_jar_tmp = new File(args[1] + ".MergeBack");
        File server_jar_tmp = new File(args[2] + ".MergeBack");
        if (client_jar_tmp.exists() && !client_jar_tmp.delete()) {
            System.out.println("Could not delete temp file: " + client_jar_tmp);
        }
        if (server_jar_tmp.exists() && !server_jar_tmp.delete()) {
            System.out.println("Could not delete temp file: " + server_jar_tmp);
        }
        if (!client_jar.exists()) {
            System.out.println("Could not find minecraft.jar: " + client_jar);
            System.exit(1);
        }
        if (!server_jar.exists()) {
            System.out.println("Could not find minecraft_server.jar: " + server_jar);
            System.exit(1);
        }
        if (!client_jar.renameTo(client_jar_tmp)) {
            System.out.println("Could not rename file: " + client_jar + " -> " + client_jar_tmp);
            System.exit(1);
        }
        if (!server_jar.renameTo(server_jar_tmp)) {
            System.out.println("Could not rename file: " + server_jar + " -> " + server_jar_tmp);
            System.exit(1);
        }
        if (!MCPMerger.readMapFile(map_file)) {
            System.out.println("Could not read map file: " + map_file);
            System.exit(1);
        }
        try {
            MCPMerger.processJar(client_jar_tmp, server_jar_tmp, client_jar, server_jar);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            System.exit(1);
        }
        if (!client_jar_tmp.delete()) {
            System.out.println("Could not delete temp file: " + client_jar_tmp);
        }
        if (!server_jar_tmp.delete()) {
            System.out.println("Could not delete temp file: " + server_jar_tmp);
        }
    }

    private static boolean readMapFile(File mapFile) {
        try {
            String line;
            FileInputStream fstream = new FileInputStream(mapFile);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br2 = new BufferedReader(new InputStreamReader(in));
            while ((line = br2.readLine()) != null) {
                line = line.split("#")[0];
                char cmd = line.charAt(0);
                line = line.substring(1).trim();
                switch (cmd) {
                    case '!': {
                        dontAnnotate.add(line);
                        break;
                    }
                    case '<': {
                        copyToClient.add(line);
                        break;
                    }
                    case '>': {
                        copyToServer.add(line);
                    }
                }
            }
            in.close();
            return true;
        }
        catch (Exception e2) {
            System.err.println("Error: " + e2.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processJar(File clientInFile, File serverInFile, File clientOutFile, File serverOutFile) throws IOException {
        ZipFile cInJar = null;
        ZipFile sInJar = null;
        ZipOutputStream cOutJar = null;
        ZipOutputStream sOutJar = null;
        try {
            try {
                cInJar = new ZipFile(clientInFile);
                sInJar = new ZipFile(serverInFile);
            }
            catch (FileNotFoundException e2) {
                throw new FileNotFoundException("Could not open input file: " + e2.getMessage());
            }
            try {
                cOutJar = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(clientOutFile)));
                sOutJar = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(serverOutFile)));
            }
            catch (FileNotFoundException e3) {
                throw new FileNotFoundException("Could not open output file: " + e3.getMessage());
            }
            Hashtable<String, ZipEntry> cClasses = MCPMerger.getClassEntries(cInJar, cOutJar);
            Hashtable<String, ZipEntry> sClasses = MCPMerger.getClassEntries(sInJar, sOutJar);
            HashSet<String> cAdded = new HashSet<String>();
            HashSet<String> sAdded = new HashSet<String>();
            for (Map.Entry<String, ZipEntry> entry : cClasses.entrySet()) {
                String name = entry.getKey();
                ZipEntry cEntry = entry.getValue();
                ZipEntry sEntry = sClasses.get(name);
                if (sEntry == null) {
                    if (!copyToServer.contains(name)) {
                        MCPMerger.copyClass(cInJar, cEntry, cOutJar, null, true);
                        cAdded.add(name);
                        continue;
                    }
                    MCPMerger.copyClass(cInJar, cEntry, cOutJar, sOutJar, true);
                    cAdded.add(name);
                    sAdded.add(name);
                    continue;
                }
                sClasses.remove(name);
                ClassInfo info = new ClassInfo(name);
                shared.put(name, info);
                byte[] cData = MCPMerger.readEntry(cInJar, entry.getValue());
                byte[] sData = MCPMerger.readEntry(sInJar, sEntry);
                byte[] data = MCPMerger.processClass(cData, sData, info);
                ZipEntry newEntry = new ZipEntry(cEntry.getName());
                cOutJar.putNextEntry(newEntry);
                cOutJar.write(data);
                sOutJar.putNextEntry(newEntry);
                sOutJar.write(data);
                cAdded.add(name);
                sAdded.add(name);
            }
            for (Map.Entry<String, ZipEntry> entry : sClasses.entrySet()) {
                MCPMerger.copyClass(sInJar, entry.getValue(), cOutJar, sOutJar, false);
            }
            for (String name : new String[]{SideOnly.class.getName(), Side.class.getName()}) {
                String eName = name.replace(".", "/");
                byte[] data = MCPMerger.getClassBytes(name);
                ZipEntry newEntry = new ZipEntry(name.replace(".", "/").concat(".class"));
                if (!cAdded.contains(eName)) {
                    cOutJar.putNextEntry(newEntry);
                    cOutJar.write(data);
                }
                if (sAdded.contains(eName)) continue;
                sOutJar.putNextEntry(newEntry);
                sOutJar.write(data);
            }
        }
        finally {
            if (cInJar != null) {
                try {
                    cInJar.close();
                }
                catch (IOException e4) {}
            }
            if (sInJar != null) {
                try {
                    sInJar.close();
                }
                catch (IOException e5) {}
            }
            if (cOutJar != null) {
                try {
                    cOutJar.close();
                }
                catch (IOException e6) {}
            }
            if (sOutJar != null) {
                try {
                    sOutJar.close();
                }
                catch (IOException e7) {}
            }
        }
    }

    private static void copyClass(ZipFile inJar, ZipEntry entry, ZipOutputStream outJar, ZipOutputStream outJar2, boolean isClientOnly) throws IOException {
        ClassReader reader = new ClassReader(MCPMerger.readEntry(inJar, entry));
        ClassNode classNode = new ClassNode();
        reader.accept((ClassVisitor)classNode, 0);
        if (!dontAnnotate.contains(classNode.name)) {
            if (classNode.visibleAnnotations == null) {
                classNode.visibleAnnotations = new ArrayList();
            }
            classNode.visibleAnnotations.add(MCPMerger.getSideAnn(isClientOnly));
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        byte[] data = writer.toByteArray();
        ZipEntry newEntry = new ZipEntry(entry.getName());
        if (outJar != null) {
            outJar.putNextEntry(newEntry);
            outJar.write(data);
        }
        if (outJar2 != null) {
            outJar2.putNextEntry(newEntry);
            outJar2.write(data);
        }
    }

    private static AnnotationNode getSideAnn(boolean isClientOnly) {
        AnnotationNode ann2 = new AnnotationNode(Type.getDescriptor(SideOnly.class));
        ann2.values = new ArrayList();
        ann2.values.add("value");
        ann2.values.add(new String[]{Type.getDescriptor(Side.class), isClientOnly ? "CLIENT" : "SERVER"});
        return ann2;
    }

    private static Hashtable<String, ZipEntry> getClassEntries(ZipFile inFile, ZipOutputStream outFile) throws IOException {
        Hashtable<String, ZipEntry> ret = new Hashtable<String, ZipEntry>();
        for (ZipEntry zipEntry : Collections.list(inFile.entries())) {
            if (zipEntry.isDirectory()) {
                outFile.putNextEntry(zipEntry);
                continue;
            }
            String entryName = zipEntry.getName();
            if (!entryName.endsWith(".class") || entryName.startsWith(".")) {
                ZipEntry newEntry = new ZipEntry(zipEntry.getName());
                outFile.putNextEntry(newEntry);
                outFile.write(MCPMerger.readEntry(inFile, zipEntry));
                continue;
            }
            ret.put(entryName.replace(".class", ""), zipEntry);
        }
        return ret;
    }

    private static byte[] readEntry(ZipFile inFile, ZipEntry entry) throws IOException {
        return MCPMerger.readFully(inFile.getInputStream(entry));
    }

    private static byte[] readFully(InputStream stream) throws IOException {
        int len;
        byte[] data = new byte[4096];
        ByteArrayOutputStream entryBuffer = new ByteArrayOutputStream();
        do {
            if ((len = stream.read(data)) <= 0) continue;
            entryBuffer.write(data, 0, len);
        } while (len != -1);
        return entryBuffer.toByteArray();
    }

    public static byte[] processClass(byte[] cIn, byte[] sIn, ClassInfo info) {
        ClassNode cClassNode = MCPMerger.getClassNode(cIn);
        ClassNode sClassNode = MCPMerger.getClassNode(sIn);
        MCPMerger.processFields(cClassNode, sClassNode, info);
        MCPMerger.processMethods(cClassNode, sClassNode, info);
        ClassWriter writer = new ClassWriter(1);
        cClassNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private static ClassNode getClassNode(byte[] data) {
        ClassReader reader = new ClassReader(data);
        ClassNode classNode = new ClassNode();
        reader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    private static void processFields(ClassNode cClass, ClassNode sClass, ClassInfo info) {
        int x;
        List cFields = cClass.fields;
        List sFields = sClass.fields;
        int sI = 0;
        for (x = 0; x < cFields.size(); ++x) {
            FieldNode cF = (FieldNode)cFields.get(x);
            if (sI < sFields.size()) {
                if (!cF.name.equals(((FieldNode)sFields.get((int)sI)).name)) {
                    boolean serverHas = false;
                    for (int y2 = sI + 1; y2 < sFields.size(); ++y2) {
                        if (!cF.name.equals(((FieldNode)sFields.get((int)y2)).name)) continue;
                        serverHas = true;
                        break;
                    }
                    if (serverHas) {
                        boolean clientHas = false;
                        FieldNode sF = (FieldNode)sFields.get(sI);
                        for (int y3 = x + 1; y3 < cFields.size(); ++y3) {
                            if (!sF.name.equals(((FieldNode)cFields.get((int)y3)).name)) continue;
                            clientHas = true;
                            break;
                        }
                        if (!clientHas) {
                            if (sF.visibleAnnotations == null) {
                                sF.visibleAnnotations = new ArrayList();
                            }
                            sF.visibleAnnotations.add(MCPMerger.getSideAnn(false));
                            cFields.add(x++, sF);
                            info.sField.add(sF);
                        }
                    } else {
                        if (cF.visibleAnnotations == null) {
                            cF.visibleAnnotations = new ArrayList();
                        }
                        cF.visibleAnnotations.add(MCPMerger.getSideAnn(true));
                        sFields.add(sI, cF);
                        info.cField.add(cF);
                    }
                }
            } else {
                if (cF.visibleAnnotations == null) {
                    cF.visibleAnnotations = new ArrayList();
                }
                cF.visibleAnnotations.add(MCPMerger.getSideAnn(true));
                sFields.add(sI, cF);
                info.cField.add(cF);
            }
            ++sI;
        }
        if (sFields.size() != cFields.size()) {
            for (x = cFields.size(); x < sFields.size(); ++x) {
                FieldNode sF = (FieldNode)sFields.get(x);
                if (sF.visibleAnnotations == null) {
                    sF.visibleAnnotations = new ArrayList();
                }
                sF.visibleAnnotations.add(MCPMerger.getSideAnn(true));
                cFields.add(x++, sF);
                info.sField.add(sF);
            }
        }
    }

    private static void processMethods(ClassNode cClass, ClassNode sClass, ClassInfo info) {
        String clientName;
        List cMethods = cClass.methods;
        List sMethods = sClass.methods;
        LinkedHashSet allMethods = Sets.newLinkedHashSet();
        int cPos = 0;
        int sPos = 0;
        int cLen = cMethods.size();
        int sLen = sMethods.size();
        String lastName = clientName = "";
        String serverName = "";
        block0: while (cPos < cLen || sPos < sLen) {
            MethodWrapper mw;
            while (sPos < sLen) {
                MethodNode sM = (MethodNode)sMethods.get(sPos);
                serverName = sM.name;
                if (!serverName.equals(lastName) && cPos != cLen) break;
                mw = new MethodWrapper(sM);
                mw.server = true;
                allMethods.add(mw);
                if (++sPos < sLen) continue;
            }
            while (cPos < cLen) {
                MethodNode cM = (MethodNode)cMethods.get(cPos);
                clientName = cM.name;
                lastName = clientName;
                if (!clientName.equals(lastName) && sPos != sLen) continue block0;
                mw = new MethodWrapper(cM);
                mw.client = true;
                allMethods.add(mw);
                if (++cPos < cLen) continue;
                continue block0;
            }
        }
        cMethods.clear();
        sMethods.clear();
        for (MethodWrapper mw : allMethods) {
            cMethods.add(mw.node);
            sMethods.add(mw.node);
            if (mw.server && mw.client) continue;
            if (((MethodWrapper)mw).node.visibleAnnotations == null) {
                ((MethodWrapper)mw).node.visibleAnnotations = Lists.newArrayListWithExpectedSize((int)1);
            }
            ((MethodWrapper)mw).node.visibleAnnotations.add(MCPMerger.getSideAnn(mw.client));
            if (mw.client) {
                info.sMethods.add(mw.node);
                continue;
            }
            info.cMethods.add(mw.node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getClassBytes(String name) throws IOException {
        InputStream classStream = null;
        try {
            classStream = MCPMerger.class.getResourceAsStream("/" + name.replace('.', '/').concat(".class"));
            byte[] byArray = MCPMerger.readFully(classStream);
            return byArray;
        }
        finally {
            if (classStream != null) {
                try {
                    classStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class MethodWrapper {
        private MethodNode node;
        public boolean client;
        public boolean server;

        public MethodWrapper(MethodNode node) {
            this.node = node;
        }

        public boolean equals(Object obj) {
            boolean eq2;
            if (obj == null || !(obj instanceof MethodWrapper)) {
                return false;
            }
            MethodWrapper mw = (MethodWrapper)obj;
            boolean bl = eq2 = Objects.equal((Object)this.node.name, (Object)mw.node.name) && Objects.equal((Object)this.node.desc, (Object)mw.node.desc);
            if (eq2) {
                mw.client = this.client | mw.client;
                mw.server = this.server | mw.server;
                this.client |= mw.client;
                this.server |= mw.server;
            }
            return eq2;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.node.name, this.node.desc});
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("name", (Object)this.node.name).add("desc", (Object)this.node.desc).add("server", this.server).add("client", this.client).toString();
        }
    }

    private static class ClassInfo {
        public String name;
        public ArrayList<FieldNode> cField = new ArrayList();
        public ArrayList<FieldNode> sField = new ArrayList();
        public ArrayList<MethodNode> cMethods = new ArrayList();
        public ArrayList<MethodNode> sMethods = new ArrayList();

        public ClassInfo(String name) {
            this.name = name;
        }

        public boolean isSame() {
            return this.cField.size() == 0 && this.sField.size() == 0 && this.cMethods.size() == 0 && this.sMethods.size() == 0;
        }
    }
}

