/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFMLHandledException;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLEvent;
import cpw.mods.fml.common.event.FMLLoadEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLStateEvent;
import cpw.mods.fml.common.functions.ArtifactVersionNameFunction;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoadController {
    private Loader loader;
    private EventBus masterChannel;
    private ImmutableMap<String, EventBus> eventChannels;
    private LoaderState state;
    private Multimap<String, LoaderState.ModState> modStates = ArrayListMultimap.create();
    private Multimap<String, Throwable> errors = ArrayListMultimap.create();
    private Map<String, ModContainer> modList;
    private List<ModContainer> activeModList = Lists.newArrayList();
    private ModContainer activeContainer;
    private BiMap<ModContainer, Object> modObjectList;

    public LoadController(Loader loader) {
        this.loader = loader;
        this.masterChannel = new EventBus("FMLMainChannel");
        this.masterChannel.register((Object)this);
        this.state = LoaderState.NOINIT;
    }

    @Subscribe
    public void buildModList(FMLLoadEvent event) {
        this.modList = this.loader.getIndexedModList();
        ImmutableMap.Builder eventBus = ImmutableMap.builder();
        for (ModContainer mod : this.loader.getModList()) {
            EventBus bus;
            boolean isActive = mod.registerBus(bus = new EventBus(mod.getModId()), this);
            if (isActive) {
                Level level = Logger.getLogger(mod.getModId()).getLevel();
                FMLLog.log(mod.getModId(), Level.FINE, "Mod Logging channel %s configured at %s level.", mod.getModId(), level == null ? "default" : level);
                FMLLog.log(mod.getModId(), Level.INFO, "Activating mod %s", mod.getModId());
                this.activeModList.add(mod);
                this.modStates.put((Object)mod.getModId(), (Object)LoaderState.ModState.UNLOADED);
                eventBus.put((Object)mod.getModId(), (Object)bus);
                continue;
            }
            FMLLog.log(mod.getModId(), Level.WARNING, "Mod %s has been disabled through configuration", mod.getModId());
            this.modStates.put((Object)mod.getModId(), (Object)LoaderState.ModState.UNLOADED);
            this.modStates.put((Object)mod.getModId(), (Object)LoaderState.ModState.DISABLED);
        }
        this.eventChannels = eventBus.build();
    }

    public void distributeStateMessage(LoaderState state, Object ... eventData) {
        if (state.hasEvent()) {
            this.masterChannel.post((Object)state.getEvent(eventData));
        }
    }

    public void transition(LoaderState desiredState, boolean forceState) {
        LoaderState oldState = this.state;
        this.state = this.state.transition(!this.errors.isEmpty());
        if (this.state != desiredState && !forceState) {
            Throwable toThrow = null;
            FMLLog.severe("Fatal errors were detected during the transition from %s to %s. Loading cannot continue", new Object[]{oldState, desiredState});
            StringBuilder sb = new StringBuilder();
            this.printModStates(sb);
            FMLLog.getLogger().severe(sb.toString());
            if (this.errors.size() > 0) {
                FMLLog.severe("The following problems were captured during this phase", new Object[0]);
                for (Map.Entry error : this.errors.entries()) {
                    FMLLog.log(Level.SEVERE, (Throwable)error.getValue(), "Caught exception from %s", error.getKey());
                    if (error.getValue() instanceof IFMLHandledException) {
                        toThrow = (Throwable)error.getValue();
                        continue;
                    }
                    if (toThrow != null) continue;
                    toThrow = (Throwable)error.getValue();
                }
            } else {
                FMLLog.severe("The ForgeModLoader state engine has become corrupted. Probably, a state was missed by and invalid modification to a base classForgeModLoader depends on. This is a critical error and not recoverable. Investigate any modifications to base classes outside ofForgeModLoader, especially Optifine, to see if there are fixes available.", new Object[0]);
                throw new RuntimeException("The ForgeModLoader state engine is invalid");
            }
            if (toThrow != null && toThrow instanceof RuntimeException) {
                throw (RuntimeException)toThrow;
            }
            throw new LoaderException(toThrow);
        }
        if (this.state != desiredState && forceState) {
            FMLLog.info("The state engine was in incorrect state %s and forced into state %s. Errors may have been discarded.", new Object[]{this.state, desiredState});
            this.forceState(desiredState);
        }
    }

    public ModContainer activeContainer() {
        return this.activeContainer;
    }

    @Subscribe
    public void propogateStateMessage(FMLEvent stateEvent) {
        if (stateEvent instanceof FMLPreInitializationEvent) {
            this.modObjectList = this.buildModObjectList();
        }
        for (ModContainer mc2 : this.activeModList) {
            this.sendEventToModContainer(stateEvent, mc2);
        }
    }

    private void sendEventToModContainer(FMLEvent stateEvent, ModContainer mc2) {
        String modId = mc2.getModId();
        Collection requirements = Collections2.transform(mc2.getRequirements(), (Function)new ArtifactVersionNameFunction());
        for (ArtifactVersion av : mc2.getDependencies()) {
            if (av.getLabel() == null || !requirements.contains(av.getLabel()) || !this.modStates.containsEntry((Object)av.getLabel(), (Object)LoaderState.ModState.ERRORED)) continue;
            FMLLog.log(modId, Level.SEVERE, "Skipping event %s and marking errored mod %s since required dependency %s has errored", stateEvent.getEventType(), modId, av.getLabel());
            this.modStates.put((Object)modId, (Object)LoaderState.ModState.ERRORED);
            return;
        }
        this.activeContainer = mc2;
        stateEvent.applyModContainer(this.activeContainer());
        FMLLog.log(modId, Level.FINEST, "Sending event %s to mod %s", stateEvent.getEventType(), modId);
        ((EventBus)this.eventChannels.get((Object)modId)).post((Object)stateEvent);
        FMLLog.log(modId, Level.FINEST, "Sent event %s to mod %s", stateEvent.getEventType(), modId);
        this.activeContainer = null;
        if (stateEvent instanceof FMLStateEvent) {
            if (!this.errors.containsKey((Object)modId)) {
                this.modStates.put((Object)modId, (Object)((FMLStateEvent)stateEvent).getModState());
            } else {
                this.modStates.put((Object)modId, (Object)LoaderState.ModState.ERRORED);
            }
        }
    }

    public ImmutableBiMap<ModContainer, Object> buildModObjectList() {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (ModContainer mc2 : this.activeModList) {
            if (!mc2.isImmutable() && mc2.getMod() != null) {
                builder.put((Object)mc2, mc2.getMod());
            }
            if (mc2.getMod() != null || mc2.isImmutable() || this.state == LoaderState.CONSTRUCTING) continue;
            FMLLog.severe("There is a severe problem with %s - it appears not to have constructed correctly", mc2.getModId());
            if (this.state == LoaderState.CONSTRUCTING) continue;
            this.errorOccurred(mc2, new RuntimeException());
        }
        return builder.build();
    }

    public void errorOccurred(ModContainer modContainer, Throwable exception) {
        if (exception instanceof InvocationTargetException) {
            this.errors.put((Object)modContainer.getModId(), (Object)((InvocationTargetException)exception).getCause());
        } else {
            this.errors.put((Object)modContainer.getModId(), (Object)exception);
        }
    }

    public void printModStates(StringBuilder ret) {
        for (ModContainer mc2 : this.loader.getModList()) {
            ret.append("\n\t").append(mc2.getModId()).append("{").append(mc2.getVersion()).append("} [").append(mc2.getName()).append("] (").append(mc2.getSource().getName()).append(") ");
            Joiner.on((String)"->").appendTo(ret, (Iterable)this.modStates.get((Object)mc2.getModId()));
        }
    }

    public List<ModContainer> getActiveModList() {
        return this.activeModList;
    }

    public LoaderState.ModState getModState(ModContainer selectedMod) {
        return (LoaderState.ModState)((Object)Iterables.getLast((Iterable)this.modStates.get((Object)selectedMod.getModId()), (Object)((Object)LoaderState.ModState.AVAILABLE)));
    }

    public void distributeStateMessage(Class<?> customEvent) {
        try {
            this.masterChannel.post(customEvent.newInstance());
        }
        catch (Exception e2) {
            FMLLog.log(Level.SEVERE, e2, "An unexpected exception", new Object[0]);
            throw new LoaderException(e2);
        }
    }

    public BiMap<ModContainer, Object> getModObjectList() {
        if (this.modObjectList == null) {
            FMLLog.severe("Detected an attempt by a mod %s to perform game activity during mod construction. This is a serious programming error.", this.activeContainer);
            return this.buildModObjectList();
        }
        return ImmutableBiMap.copyOf(this.modObjectList);
    }

    public boolean isInState(LoaderState state) {
        return this.state == state;
    }

    boolean hasReachedState(LoaderState state) {
        return this.state.ordinal() >= state.ordinal() && this.state != LoaderState.ERRORED;
    }

    void forceState(LoaderState newState) {
        this.state = newState;
    }
}

