/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.CertificateHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ILanguageAdapter;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.ProxyInjector;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLEvent;
import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.common.versioning.VersionRange;
import java.io.File;
import java.io.FileInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FMLModContainer
implements ModContainer {
    private Mod modDescriptor;
    private Object modInstance;
    private File source;
    private ModMetadata modMetadata;
    private String className;
    private Map<String, Object> descriptor;
    private boolean enabled = true;
    private String internalVersion;
    private boolean overridesMetadata;
    private EventBus eventBus;
    private LoadController controller;
    private Multimap<Class<? extends Annotation>, Object> annotations;
    private DefaultArtifactVersion processedVersion;
    private boolean isNetworkMod;
    private static final BiMap<Class<? extends FMLEvent>, Class<? extends Annotation>> modAnnotationTypes = ImmutableBiMap.builder().put(FMLPreInitializationEvent.class, Mod.PreInit.class).put(FMLInitializationEvent.class, Mod.Init.class).put(FMLPostInitializationEvent.class, Mod.PostInit.class).put(FMLServerAboutToStartEvent.class, Mod.ServerAboutToStart.class).put(FMLServerStartingEvent.class, Mod.ServerStarting.class).put(FMLServerStartedEvent.class, Mod.ServerStarted.class).put(FMLServerStoppingEvent.class, Mod.ServerStopping.class).put(FMLServerStoppedEvent.class, Mod.ServerStopped.class).put(FMLInterModComms.IMCEvent.class, Mod.IMCCallback.class).put(FMLFingerprintViolationEvent.class, Mod.FingerprintWarning.class).build();
    private static final BiMap<Class<? extends Annotation>, Class<? extends FMLEvent>> modTypeAnnotations = modAnnotationTypes.inverse();
    private String annotationDependencies;
    private VersionRange minecraftAccepted;
    private boolean fingerprintNotPresent;
    private Set<String> sourceFingerprints;
    private Certificate certificate;
    private String modLanguage;
    private ILanguageAdapter languageAdapter;

    public FMLModContainer(String className, File modSource, Map<String, Object> modDescriptor) {
        this.className = className;
        this.source = modSource;
        this.descriptor = modDescriptor;
        this.modLanguage = (String)modDescriptor.get("modLanguage");
        this.languageAdapter = "scala".equals(this.modLanguage) ? new ILanguageAdapter.ScalaAdapter() : new ILanguageAdapter.JavaAdapter();
    }

    private ILanguageAdapter getLanguageAdapter() {
        return this.languageAdapter;
    }

    @Override
    public String getModId() {
        return (String)this.descriptor.get("modid");
    }

    @Override
    public String getName() {
        return this.modMetadata.name;
    }

    @Override
    public String getVersion() {
        return this.internalVersion;
    }

    @Override
    public File getSource() {
        return this.source;
    }

    @Override
    public ModMetadata getMetadata() {
        return this.modMetadata;
    }

    @Override
    public void bindMetadata(MetadataCollection mc2) {
        String mcVersionString;
        Properties versionProps;
        this.modMetadata = mc2.getMetadataForId(this.getModId(), this.descriptor);
        if (this.descriptor.containsKey("useMetadata")) {
            boolean bl = this.overridesMetadata = (Boolean)this.descriptor.get("useMetadata") == false;
        }
        if (this.overridesMetadata || !this.modMetadata.useDependencyInformation) {
            HashSet requirements = Sets.newHashSet();
            ArrayList dependencies = Lists.newArrayList();
            ArrayList dependants = Lists.newArrayList();
            this.annotationDependencies = (String)this.descriptor.get("dependencies");
            Loader.instance().computeDependencies(this.annotationDependencies, requirements, dependencies, dependants);
            this.modMetadata.requiredMods = requirements;
            this.modMetadata.dependencies = dependencies;
            this.modMetadata.dependants = dependants;
            FMLLog.log(this.getModId(), Level.FINEST, "Parsed dependency info : %s %s %s", requirements, dependencies, dependants);
        } else {
            FMLLog.log(this.getModId(), Level.FINEST, "Using mcmod dependency info : %s %s %s", this.modMetadata.requiredMods, this.modMetadata.dependencies, this.modMetadata.dependants);
        }
        if (Strings.isNullOrEmpty((String)this.modMetadata.name)) {
            FMLLog.log(this.getModId(), Level.INFO, "Mod %s is missing the required element 'name'. Substituting %s", this.getModId(), this.getModId());
            this.modMetadata.name = this.getModId();
        }
        this.internalVersion = (String)this.descriptor.get("version");
        if (Strings.isNullOrEmpty((String)this.internalVersion) && (versionProps = this.searchForVersionProperties()) != null) {
            this.internalVersion = versionProps.getProperty(this.getModId() + ".version");
            FMLLog.log(this.getModId(), Level.FINE, "Found version %s for mod %s in version.properties, using", this.internalVersion, this.getModId());
        }
        if (Strings.isNullOrEmpty((String)this.internalVersion) && !Strings.isNullOrEmpty((String)this.modMetadata.version)) {
            FMLLog.log(this.getModId(), Level.WARNING, "Mod %s is missing the required element 'version' and a version.properties file could not be found. Falling back to metadata version %s", this.getModId(), this.modMetadata.version);
            this.internalVersion = this.modMetadata.version;
        }
        if (Strings.isNullOrEmpty((String)this.internalVersion)) {
            FMLLog.log(this.getModId(), Level.WARNING, "Mod %s is missing the required element 'version' and no fallback can be found. Substituting '1.0'.", this.getModId());
            this.internalVersion = "1.0";
            this.modMetadata.version = "1.0";
        }
        this.minecraftAccepted = !Strings.isNullOrEmpty((String)(mcVersionString = (String)this.descriptor.get("acceptedMinecraftVersions"))) ? VersionParser.parseRange(mcVersionString) : Loader.instance().getMinecraftModContainer().getStaticVersionRange();
    }

    public Properties searchForVersionProperties() {
        try {
            File propsFile;
            FMLLog.log(this.getModId(), Level.FINE, "Attempting to load the file version.properties from %s to locate a version number for %s", this.getSource().getName(), this.getModId());
            Properties version = null;
            if (this.getSource().isFile()) {
                ZipFile source = new ZipFile(this.getSource());
                ZipEntry versionFile = source.getEntry("version.properties");
                if (versionFile != null) {
                    version = new Properties();
                    version.load(source.getInputStream(versionFile));
                }
                source.close();
            } else if (this.getSource().isDirectory() && (propsFile = new File(this.getSource(), "version.properties")).exists() && propsFile.isFile()) {
                version = new Properties();
                FileInputStream fis = new FileInputStream(propsFile);
                version.load(fis);
                fis.close();
            }
            return version;
        }
        catch (Exception e2) {
            Throwables.propagateIfPossible((Throwable)e2);
            FMLLog.log(this.getModId(), Level.FINEST, "Failed to find a usable version.properties file", new Object[0]);
            return null;
        }
    }

    @Override
    public void setEnabledState(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Set<ArtifactVersion> getRequirements() {
        return this.modMetadata.requiredMods;
    }

    @Override
    public List<ArtifactVersion> getDependencies() {
        return this.modMetadata.dependencies;
    }

    @Override
    public List<ArtifactVersion> getDependants() {
        return this.modMetadata.dependants;
    }

    @Override
    public String getSortingRules() {
        return this.overridesMetadata || !this.modMetadata.useDependencyInformation ? Strings.nullToEmpty((String)this.annotationDependencies) : this.modMetadata.printableSortingRules();
    }

    @Override
    public boolean matches(Object mod) {
        return mod == this.modInstance;
    }

    @Override
    public Object getMod() {
        return this.modInstance;
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        if (this.enabled) {
            FMLLog.log(this.getModId(), Level.FINE, "Enabling mod %s", this.getModId());
            this.eventBus = bus;
            this.controller = controller;
            this.eventBus.register((Object)this);
            return true;
        }
        return false;
    }

    private Multimap<Class<? extends Annotation>, Object> gatherAnnotations(Class<?> clazz) throws Exception {
        ArrayListMultimap anns = ArrayListMultimap.create();
        for (Method m2 : clazz.getDeclaredMethods()) {
            for (Annotation a2 : m2.getAnnotations()) {
                if (!modTypeAnnotations.containsKey(a2.annotationType())) continue;
                Object[] paramTypes = new Class[]{(Class)modTypeAnnotations.get(a2.annotationType())};
                if (Arrays.equals(m2.getParameterTypes(), paramTypes)) {
                    m2.setAccessible(true);
                    anns.put(a2.annotationType(), (Object)m2);
                    continue;
                }
                FMLLog.log(this.getModId(), Level.SEVERE, "The mod %s appears to have an invalid method annotation %s. This annotation can only apply to methods with argument types %s -it will not be called", this.getModId(), a2.annotationType().getSimpleName(), Arrays.toString(paramTypes));
            }
        }
        return anns;
    }

    private void processFieldAnnotations(ASMDataTable asmDataTable) throws Exception {
        SetMultimap<String, ASMDataTable.ASMData> annotations = asmDataTable.getAnnotationsFor(this);
        this.parseSimpleFieldAnnotation(annotations, Mod.Instance.class.getName(), new Function<ModContainer, Object>(){

            public Object apply(ModContainer mc2) {
                return mc2.getMod();
            }
        });
        this.parseSimpleFieldAnnotation(annotations, Mod.Metadata.class.getName(), new Function<ModContainer, Object>(){

            public Object apply(ModContainer mc2) {
                return mc2.getMetadata();
            }
        });
    }

    private void parseSimpleFieldAnnotation(SetMultimap<String, ASMDataTable.ASMData> annotations, String annotationClassName, Function<ModContainer, Object> retreiver) throws IllegalAccessException {
        String[] annName = annotationClassName.split("\\.");
        String annotationName = annName[annName.length - 1];
        for (ASMDataTable.ASMData targets : annotations.get((Object)annotationClassName)) {
            String targetMod = (String)targets.getAnnotationInfo().get("value");
            Field f2 = null;
            Object injectedMod = null;
            ModContainer mc2 = this;
            boolean isStatic = false;
            Class<?> clz = this.modInstance.getClass();
            if (!Strings.isNullOrEmpty((String)targetMod)) {
                mc2 = Loader.isModLoaded(targetMod) ? Loader.instance().getIndexedModList().get(targetMod) : null;
            }
            if (mc2 != null) {
                try {
                    clz = Class.forName(targets.getClassName(), true, Loader.instance().getModClassLoader());
                    f2 = clz.getDeclaredField(targets.getObjectName());
                    f2.setAccessible(true);
                    isStatic = Modifier.isStatic(f2.getModifiers());
                    injectedMod = retreiver.apply((Object)mc2);
                }
                catch (Exception e2) {
                    Throwables.propagateIfPossible((Throwable)e2);
                    FMLLog.log(this.getModId(), Level.WARNING, e2, "Attempting to load @%s in class %s for %s and failing", annotationName, targets.getClassName(), mc2.getModId());
                }
            }
            if (f2 == null) continue;
            Object target = null;
            if (!isStatic) {
                target = this.modInstance;
                if (!this.modInstance.getClass().equals(clz)) {
                    FMLLog.log(this.getModId(), Level.WARNING, "Unable to inject @%s in non-static field %s.%s for %s as it is NOT the primary mod instance", annotationName, targets.getClassName(), targets.getObjectName(), mc2.getModId());
                    continue;
                }
            }
            f2.set(target, injectedMod);
        }
    }

    @Subscribe
    public void constructMod(FMLConstructionEvent event) {
        try {
            ModClassLoader modClassLoader = event.getModClassLoader();
            modClassLoader.addFile(this.source);
            Class<?> clazz = Class.forName(this.className, true, modClassLoader);
            Certificate[] certificates = clazz.getProtectionDomain().getCodeSource().getCertificates();
            int len = 0;
            if (certificates != null) {
                len = certificates.length;
            }
            ImmutableList.Builder certBuilder = ImmutableList.builder();
            for (int i2 = 0; i2 < len; ++i2) {
                certBuilder.add((Object)CertificateHelper.getFingerprint(certificates[i2]));
            }
            ImmutableList certList = certBuilder.build();
            this.sourceFingerprints = ImmutableSet.copyOf((Collection)certList);
            String expectedFingerprint = (String)this.descriptor.get("certificateFingerprint");
            this.fingerprintNotPresent = true;
            if (expectedFingerprint != null && !expectedFingerprint.isEmpty()) {
                if (!this.sourceFingerprints.contains(expectedFingerprint)) {
                    Level warnLevel = Level.SEVERE;
                    if (this.source.isDirectory()) {
                        warnLevel = Level.FINER;
                    }
                    FMLLog.log(this.getModId(), warnLevel, "The mod %s is expecting signature %s for source %s, however there is no signature matching that description", this.getModId(), expectedFingerprint, this.source.getName());
                } else {
                    this.certificate = certificates[certList.indexOf((Object)expectedFingerprint)];
                    this.fingerprintNotPresent = false;
                }
            }
            this.annotations = this.gatherAnnotations(clazz);
            this.isNetworkMod = FMLNetworkHandler.instance().registerNetworkMod(this, clazz, event.getASMHarvestedData());
            this.modInstance = this.getLanguageAdapter().getNewInstance(this, clazz, modClassLoader);
            if (this.fingerprintNotPresent) {
                this.eventBus.post((Object)new FMLFingerprintViolationEvent(this.source.isDirectory(), this.source, (ImmutableSet<String>)ImmutableSet.copyOf(this.sourceFingerprints), expectedFingerprint));
            }
            ProxyInjector.inject(this, event.getASMHarvestedData(), FMLCommonHandler.instance().getSide(), this.getLanguageAdapter());
            this.processFieldAnnotations(event.getASMHarvestedData());
        }
        catch (Throwable e2) {
            this.controller.errorOccurred(this, e2);
            Throwables.propagateIfPossible((Throwable)e2);
        }
    }

    @Subscribe
    public void handleModStateEvent(FMLEvent event) {
        Class annotation = (Class)modAnnotationTypes.get(event.getClass());
        if (annotation == null) {
            return;
        }
        try {
            for (Object o : this.annotations.get((Object)annotation)) {
                Method m2 = (Method)o;
                m2.invoke(this.modInstance, event);
            }
        }
        catch (Throwable t2) {
            this.controller.errorOccurred(this, t2);
            Throwables.propagateIfPossible((Throwable)t2);
        }
    }

    @Override
    public ArtifactVersion getProcessedVersion() {
        if (this.processedVersion == null) {
            this.processedVersion = new DefaultArtifactVersion(this.getModId(), this.getVersion());
        }
        return this.processedVersion;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public boolean isNetworkMod() {
        return this.isNetworkMod;
    }

    @Override
    public String getDisplayVersion() {
        return this.modMetadata.version;
    }

    @Override
    public VersionRange acceptableMinecraftVersionRange() {
        return this.minecraftAccepted;
    }

    @Override
    public Certificate getSigningCertificate() {
        return this.certificate;
    }

    public String toString() {
        return "FMLMod:" + this.getModId() + "{" + this.getVersion() + "}";
    }
}

