/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class KeyBindingRegistry {
    private static final KeyBindingRegistry INSTANCE = new KeyBindingRegistry();
    private Set<KeyHandler> keyHandlers = Sets.newLinkedHashSet();

    public static void registerKeyBinding(KeyHandler handler) {
        KeyBindingRegistry.instance().keyHandlers.add(handler);
        if (!handler.isDummy) {
            TickRegistry.registerTickHandler(handler, Side.CLIENT);
        }
    }

    @Deprecated
    public static KeyBindingRegistry instance() {
        return INSTANCE;
    }

    public void uploadKeyBindingsToGame(avy settings) {
        ArrayList harvestedBindings = Lists.newArrayList();
        for (KeyHandler key : this.keyHandlers) {
            for (ava kb : key.keyBindings) {
                harvestedBindings.add(kb);
            }
        }
        ava[] modKeyBindings = harvestedBindings.toArray(new ava[harvestedBindings.size()]);
        ava[] allKeys = new ava[settings.W.length + modKeyBindings.length];
        System.arraycopy(settings.W, 0, allKeys, 0, settings.W.length);
        System.arraycopy(modKeyBindings, 0, allKeys, settings.W.length, modKeyBindings.length);
        settings.W = allKeys;
        settings.a();
    }

    public static abstract class KeyHandler
    implements ITickHandler {
        protected ava[] keyBindings;
        protected boolean[] keyDown;
        protected boolean[] repeatings;
        private boolean isDummy;

        public KeyHandler(ava[] keyBindings, boolean[] repeatings) {
            assert (keyBindings.length == repeatings.length) : "You need to pass two arrays of identical length";
            this.keyBindings = keyBindings;
            this.repeatings = repeatings;
            this.keyDown = new boolean[keyBindings.length];
        }

        public KeyHandler(ava[] keyBindings) {
            this.keyBindings = keyBindings;
            this.isDummy = true;
        }

        public ava[] getKeyBindings() {
            return this.keyBindings;
        }

        @Override
        public final void tickStart(EnumSet<TickType> type, Object ... tickData) {
            this.keyTick(type, false);
        }

        @Override
        public final void tickEnd(EnumSet<TickType> type, Object ... tickData) {
            this.keyTick(type, true);
        }

        private void keyTick(EnumSet<TickType> type, boolean tickEnd) {
            for (int i2 = 0; i2 < this.keyBindings.length; ++i2) {
                boolean state;
                ava keyBinding = this.keyBindings[i2];
                int keyCode = keyBinding.d;
                boolean bl = state = keyCode < 0 ? Mouse.isButtonDown((int)(keyCode + 100)) : Keyboard.isKeyDown((int)keyCode);
                if (state == this.keyDown[i2] && (!state || !this.repeatings[i2])) continue;
                if (state) {
                    this.keyDown(type, keyBinding, tickEnd, state != this.keyDown[i2]);
                } else {
                    this.keyUp(type, keyBinding, tickEnd);
                }
                if (!tickEnd) continue;
                this.keyDown[i2] = state;
            }
        }

        public abstract void keyDown(EnumSet<TickType> var1, ava var2, boolean var3, boolean var4);

        public abstract void keyUp(EnumSet<TickType> var1, ava var2, boolean var3);

        @Override
        public abstract EnumSet<TickType> ticks();
    }
}

