/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client.modloader;

import com.google.common.base.Equivalence;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapDifference;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import cpw.mods.fml.client.modloader.ModLoaderBlockRendererHandler;
import cpw.mods.fml.client.modloader.ModLoaderKeyBindingHandler;
import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.modloader.BaseModProxy;
import cpw.mods.fml.common.modloader.IModLoaderSidedHelper;
import cpw.mods.fml.common.modloader.ModLoaderHelper;
import cpw.mods.fml.common.modloader.ModLoaderModContainer;
import cpw.mods.fml.common.network.EntitySpawnPacket;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.client.Minecraft;

public class ModLoaderClientHelper
implements IModLoaderSidedHelper {
    private Minecraft client;
    private static Multimap<ModLoaderModContainer, ModLoaderKeyBindingHandler> keyBindingContainers;
    private Map<cg, ej> managerLookups = new MapMaker().weakKeys().weakValues().makeMap();

    public static int obtainBlockModelIdFor(BaseMod mod, boolean inventoryRenderer) {
        int renderId = RenderingRegistry.getNextAvailableRenderId();
        ModLoaderBlockRendererHandler bri = new ModLoaderBlockRendererHandler(renderId, inventoryRenderer, mod);
        RenderingRegistry.registerBlockHandler(bri);
        return renderId;
    }

    public static void handleFinishLoadingFor(ModLoaderModContainer mc2, Minecraft game) {
        FMLLog.log(mc2.getModId(), Level.FINE, "Handling post startup activities for ModLoader mod %s", mc2.getModId());
        BaseMod mod = (BaseMod)mc2.getMod();
        HashMap renderers = Maps.newHashMap((Map)bgy.a.q);
        try {
            FMLLog.log(mc2.getModId(), Level.FINEST, "Requesting renderers from basemod %s", mc2.getModId());
            mod.addRenderer(renderers);
            FMLLog.log(mc2.getModId(), Level.FINEST, "Received %d renderers from basemod %s", renderers.size(), mc2.getModId());
        }
        catch (Exception e2) {
            FMLLog.log(mc2.getModId(), Level.SEVERE, e2, "A severe problem was detected with the mod %s during the addRenderer call. Continuing, but expect odd results", mc2.getModId());
        }
        MapDifference difference = Maps.difference((Map)bgy.a.q, (Map)renderers, (Equivalence)Equivalence.identity());
        for (Map.Entry e3 : difference.entriesOnlyOnLeft().entrySet()) {
            FMLLog.log(mc2.getModId(), Level.WARNING, "The mod %s attempted to remove an entity renderer %s from the entity map. This will be ignored.", mc2.getModId(), ((Class)e3.getKey()).getName());
        }
        for (Map.Entry e3 : difference.entriesOnlyOnRight().entrySet()) {
            FMLLog.log(mc2.getModId(), Level.FINEST, "Registering ModLoader entity renderer %s as instance of %s", ((Class)e3.getKey()).getName(), ((bgz)e3.getValue()).getClass().getName());
            RenderingRegistry.registerEntityRenderingHandler((Class)e3.getKey(), (bgz)e3.getValue());
        }
        for (Map.Entry e3 : difference.entriesDiffering().entrySet()) {
            FMLLog.log(mc2.getModId(), Level.FINEST, "Registering ModLoader entity rendering override for %s as instance of %s", ((Class)e3.getKey()).getName(), ((bgz)((MapDifference.ValueDifference)e3.getValue()).rightValue()).getClass().getName());
            RenderingRegistry.registerEntityRenderingHandler((Class)e3.getKey(), (bgz)((MapDifference.ValueDifference)e3.getValue()).rightValue());
        }
        try {
            mod.registerAnimation(game);
        }
        catch (Exception e4) {
            FMLLog.log(mc2.getModId(), Level.SEVERE, e4, "A severe problem was detected with the mod %s during the registerAnimation call. Continuing, but expect odd results", mc2.getModId());
        }
    }

    public ModLoaderClientHelper(Minecraft client) {
        this.client = client;
        ModLoaderHelper.sidedHelper = this;
        keyBindingContainers = Multimaps.newMultimap((Map)Maps.newHashMap(), (Supplier)new Supplier<Collection<ModLoaderKeyBindingHandler>>(){

            public Collection<ModLoaderKeyBindingHandler> get() {
                return Collections.singleton(new ModLoaderKeyBindingHandler());
            }
        });
    }

    @Override
    public void finishModLoading(ModLoaderModContainer mc2) {
        ModLoaderClientHelper.handleFinishLoadingFor(mc2, this.client);
    }

    public static void registerKeyBinding(BaseModProxy mod, ava keyHandler, boolean allowRepeat) {
        ModLoaderModContainer mlmc = (ModLoaderModContainer)Loader.instance().activeModContainer();
        ModLoaderKeyBindingHandler handler = (ModLoaderKeyBindingHandler)Iterables.getOnlyElement((Iterable)keyBindingContainers.get((Object)mlmc));
        handler.setModContainer(mlmc);
        handler.addKeyBinding(keyHandler, allowRepeat);
        KeyBindingRegistry.registerKeyBinding(handler);
    }

    @Override
    public Object getClientGui(BaseModProxy mod, sq player, int ID, int x, int y2, int z2) {
        return ((BaseMod)mod).getContainerGUI((bdv)player, ID, x, y2, z2);
    }

    @Override
    public mp spawnEntity(BaseModProxy mod, EntitySpawnPacket input, EntityRegistry.EntityRegistration er2) {
        return ((BaseMod)mod).spawnEntity(er2.getModEntityId(), this.client.e, input.scaledX, input.scaledY, input.scaledZ);
    }

    @Override
    public void sendClientPacket(BaseModProxy mod, dk packet) {
        ((BaseMod)mod).clientCustomPayload(this.client.g.a, packet);
    }

    @Override
    public void clientConnectionOpened(ej netClientHandler, cg manager, BaseModProxy mod) {
        this.managerLookups.put(manager, netClientHandler);
        ((BaseMod)mod).clientConnect((bdk)netClientHandler);
    }

    @Override
    public boolean clientConnectionClosed(cg manager, BaseModProxy mod) {
        if (this.managerLookups.containsKey(manager)) {
            ((BaseMod)mod).clientDisconnect((bdk)this.managerLookups.get(manager));
            return true;
        }
        return false;
    }
}

