/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaks;
import invtweaks.InvTweaksConfig;
import invtweaks.InvTweaksConst;
import invtweaks.InvTweaksHandlerAutoRefill;
import invtweaks.InvTweaksHandlerShortcuts;
import invtweaks.InvTweaksItemTreeLoader;
import invtweaks.InvTweaksLocalization;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.IllegalFormatException;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;

public class InvTweaksConfigManager {
    private static final Logger log = InvTweaks.log;
    private Minecraft mc;
    private InvTweaksConfig config = null;
    private long storedConfigLastModified = 0L;
    private InvTweaksHandlerAutoRefill autoRefillHandler = null;
    private InvTweaksHandlerShortcuts shortcutsHandler = null;

    public InvTweaksConfigManager(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public boolean makeSureConfigurationIsLoaded() {
        try {
            if (this.config != null && this.config.refreshProperties()) {
                this.shortcutsHandler = new InvTweaksHandlerShortcuts(this.mc, this.config);
                InvTweaks.logInGameStatic("invtweaks.propsfile.loaded");
            }
        }
        catch (IOException iOException) {
            InvTweaks.logInGameErrorStatic("invtweaks.loadconfig.refresh.error", iOException);
        }
        long l = this.computeConfigLastModified();
        if (this.config != null) {
            if (this.storedConfigLastModified != l) {
                return this.loadConfig();
            }
            return true;
        }
        this.storedConfigLastModified = l;
        return this.loadConfig();
    }

    public InvTweaksConfig getConfig() {
        return this.config;
    }

    public InvTweaksHandlerAutoRefill getAutoRefillHandler() {
        return this.autoRefillHandler;
    }

    public InvTweaksHandlerShortcuts getShortcutsHandler() {
        return this.shortcutsHandler;
    }

    private long computeConfigLastModified() {
        return new File(InvTweaksConst.CONFIG_RULES_FILE).lastModified() + new File(InvTweaksConst.CONFIG_TREE_FILE).lastModified();
    }

    private boolean loadConfig() {
        File file = new File(InvTweaksConst.MINECRAFT_CONFIG_DIR);
        if (!file.exists()) {
            file.mkdir();
        }
        try {
            if (!InvTweaksItemTreeLoader.isValidVersion(InvTweaksConst.CONFIG_TREE_FILE)) {
                this.backupFile(new File(InvTweaksConst.CONFIG_TREE_FILE), InvTweaksConst.CONFIG_TREE_FILE);
            }
        }
        catch (Exception exception) {
            log.warning("Failed to check item tree version: " + exception.getMessage());
        }
        if (new File(InvTweaksConst.OLDER_CONFIG_RULES_FILE).exists()) {
            if (new File(InvTweaksConst.CONFIG_RULES_FILE).exists()) {
                this.backupFile(new File(InvTweaksConst.CONFIG_RULES_FILE), InvTweaksConst.CONFIG_RULES_FILE);
            }
            new File(InvTweaksConst.OLDER_CONFIG_RULES_FILE).renameTo(new File(InvTweaksConst.CONFIG_RULES_FILE));
        }
        if (new File(InvTweaksConst.OLDER_CONFIG_TREE_FILE).exists()) {
            this.backupFile(new File(InvTweaksConst.OLDER_CONFIG_TREE_FILE), InvTweaksConst.CONFIG_TREE_FILE);
        }
        if (new File(InvTweaksConst.OLD_CONFIG_TREE_FILE).exists()) {
            new File(InvTweaksConst.OLD_CONFIG_TREE_FILE).renameTo(new File(InvTweaksConst.CONFIG_TREE_FILE));
        }
        if (!new File(InvTweaksConst.CONFIG_RULES_FILE).exists() && this.extractFile("DefaultConfig.dat", InvTweaksConst.CONFIG_RULES_FILE)) {
            InvTweaks.logInGameStatic(InvTweaksConst.CONFIG_RULES_FILE + " " + InvTweaksLocalization.get("invtweaks.loadconfig.invalidkeywords"));
        }
        if (!new File(InvTweaksConst.CONFIG_TREE_FILE).exists() && this.extractFile("DefaultTree.dat", InvTweaksConst.CONFIG_TREE_FILE)) {
            InvTweaks.logInGameStatic(InvTweaksConst.CONFIG_TREE_FILE + " " + InvTweaksLocalization.get("invtweaks.loadconfig.invalidkeywords"));
        }
        this.storedConfigLastModified = this.computeConfigLastModified();
        String string = null;
        Exception exception = null;
        try {
            if (this.config == null) {
                this.config = new InvTweaksConfig(InvTweaksConst.CONFIG_RULES_FILE, InvTweaksConst.CONFIG_TREE_FILE);
                this.autoRefillHandler = new InvTweaksHandlerAutoRefill(this.mc, this.config);
                this.shortcutsHandler = new InvTweaksHandlerShortcuts(this.mc, this.config);
            }
            this.config.load();
            this.shortcutsHandler.loadShortcuts();
            log.setLevel(this.config.getLogLevel());
            InvTweaks.logInGameStatic("invtweaks.loadconfig.done");
            this.showConfigErrors(this.config);
        }
        catch (FileNotFoundException fileNotFoundException) {
            string = "Config file not found";
        }
        catch (Exception exception2) {
            string = "Error while loading config";
            exception = exception2;
        }
        if (string != null) {
            InvTweaks.logInGameErrorStatic(string, exception);
            log.severe(string);
            this.config = null;
            return false;
        }
        return true;
    }

    private void backupFile(File file, String string) {
        File file2 = new File(string + ".bak");
        if (file2.exists()) {
            file2.delete();
        }
        file.renameTo(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean extractFile(String string, String string2) {
        File[] fileArray;
        Object object;
        String string3 = "";
        URL uRL = InvTweaks.class.getResource(string);
        if (uRL != null) {
            object = null;
            try {
                fileArray = uRL.getContent();
                if (fileArray instanceof InputStream) {
                    object = (InputStream)fileArray;
                    while (((InputStream)object).available() > 0) {
                        byte[] objectArray = new byte[((InputStream)object).available()];
                        ((InputStream)object).read(objectArray);
                        string3 = string3 + new String(objectArray);
                    }
                }
            }
            catch (IOException iOException) {
                uRL = null;
            }
            finally {
                if (object != null) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        if (uRL == null && (fileArray = ((File)(object = new File(InvTweaksConst.MINECRAFT_DIR + File.separatorChar + "mods"))).listFiles()) != null && fileArray.length > 0) {
            for (File file : fileArray) {
                try {
                    ZipFile exception = new ZipFile(file);
                    ZipEntry zipEntry = exception.getEntry(string);
                    if (zipEntry != null) {
                        InputStream inputStream = exception.getInputStream(zipEntry);
                        while (inputStream.available() > 0) {
                            byte[] byArray = new byte[inputStream.available()];
                            inputStream.read(byArray);
                            string3 = string3 + new String(byArray);
                        }
                        exception.close();
                        break;
                    }
                    exception.close();
                }
                catch (Exception exception) {
                    log.warning("Failed to extract " + string + " from mod: " + exception.getMessage());
                }
            }
        }
        if (!string3.isEmpty()) {
            try {
                object = new FileWriter(string2);
                ((Writer)object).write(string3);
                ((OutputStreamWriter)object).close();
                return true;
            }
            catch (IOException iOException) {
                try {
                    InvTweaks.logInGameStatic(String.format(InvTweaksLocalization.get("invtweaks.extract.create.error"), string2));
                }
                catch (IllegalFormatException illegalFormatException) {
                    InvTweaks.logInGameStatic("[16] The mod won't work, because " + string2 + " creation failed!");
                }
                log.severe("Cannot create " + string2 + " file: " + iOException.getMessage());
                return false;
            }
        }
        try {
            InvTweaks.logInGameStatic(String.format(InvTweaksLocalization.get("invtweaks.extract.find.error"), string));
        }
        catch (IllegalFormatException illegalFormatException) {
            InvTweaks.logInGameStatic("[15] The mod won't work, because " + string + " creation failed!");
        }
        log.severe("Cannot create " + string2 + " file: " + string + " not found");
        return false;
    }

    private void showConfigErrors(InvTweaksConfig invTweaksConfig) {
        Vector<String> vector = invTweaksConfig.getInvalidKeywords();
        if (vector.size() > 0) {
            String string = InvTweaksLocalization.get("invtweaks.loadconfig.invalidkeywords") + ": ";
            for (String string2 : invTweaksConfig.getInvalidKeywords()) {
                string = string + string2 + " ";
            }
            InvTweaks.logInGameStatic(string);
        }
    }
}

