/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.world;

import java.util.Random;
import net.minecraft.world.World;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.compat.ArtificeRegistry;
import shukaro.artifice.util.ChunkCoord;

public class WorldGenLily {
    private World world;
    private Random rand;
    private int x;
    private int y;
    private int z;
    private int startX;
    private int startZ;
    private int xMin;
    private int zMin;
    private int xMax;
    private int zMax;

    public WorldGenLily(World world, Random rand) {
        this.world = world;
        this.rand = rand;
    }

    public boolean generate(int chunkX, int chunkZ) {
        this.xMin = chunkX << 4;
        this.zMin = chunkZ << 4;
        this.xMax = this.xMin + 16;
        this.zMax += 16;
        this.startX = this.xMin + this.rand.nextInt(16);
        this.startZ = this.zMin + this.rand.nextInt(16);
        if (!ArtificeRegistry.getLotusWhitelist().contains(this.world.func_72807_a((int)this.startX, (int)this.startZ).field_76791_y)) {
            return false;
        }
        if (this.rand.nextInt(10) > 4) {
            return false;
        }
        int tries = this.rand.nextInt(16) + 8;
        ChunkCoord c = new ChunkCoord(chunkX, chunkZ);
        for (int l = 0; l < tries; ++l) {
            this.x = this.startX + this.rand.nextInt(8) - this.rand.nextInt(8);
            this.z = this.startZ + this.rand.nextInt(8) - this.rand.nextInt(8);
            this.y = this.world.func_72976_f(this.x, this.z);
            if (!c.contains(this.x, this.z) || !this.world.func_72799_c(this.x, this.y, this.z) || !ArtificeBlocks.blockLotus.func_71930_b(this.world, this.x, this.y, this.z)) continue;
            if (this.world.func_72820_D() > 12000L) {
                this.world.func_72832_d(this.x, this.y, this.z, ArtificeBlocks.blockLotus.field_71990_ca, 1, 0);
                continue;
            }
            this.world.func_72832_d(this.x, this.y, this.z, ArtificeBlocks.blockLotus.field_71990_ca, 0, 0);
        }
        return true;
    }
}

