/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.World;
import shukaro.artifice.compat.ArtificeRegistry;
import shukaro.artifice.util.BlockCoord;

public class WorldGenCave {
    private World world;
    private Random rand;
    private int id;
    private int meta;
    private int maxHeight;
    private int frequency;
    private int size;
    private int adherence;
    private Set replaced;
    private BlockCoord coord;
    private List lining;
    private List extra;
    private static Map marbleStartingPoints = new HashMap();
    private static Map basaltStartingPoints = new HashMap();

    public WorldGenCave(World world, Random rand, int id, int maxHeight, int frequency, int size, int adherence) {
        this(world, rand, id, 0, maxHeight, frequency, size, adherence, ArtificeRegistry.getStoneTypes());
    }

    public WorldGenCave(World world, Random rand, int id, int meta, int maxHeight, int frequency, int size, int adherence, Set replaced) {
        this.world = world;
        this.rand = rand;
        this.id = id;
        this.meta = meta;
        this.maxHeight = maxHeight;
        this.frequency = frequency;
        this.size = size;
        this.adherence = adherence;
        this.replaced = replaced;
        this.coord = new BlockCoord();
        this.lining = new ArrayList();
        this.extra = new ArrayList();
    }

    public boolean generate(int chunkX, int chunkZ) {
        this.lining.clear();
        this.extra.clear();
        int tries = this.rand.nextInt(16) + 4;
        for (int i = 0; i < tries; ++i) {
            int x = (chunkX << 4) + this.rand.nextInt(16);
            int y = this.rand.nextInt(this.maxHeight);
            int z = (chunkZ << 4) + this.rand.nextInt(16);
            this.coord.set(x, y, z);
            if (!this.canGenHere(this.world, this.coord, true)) continue;
            this.world.func_72832_d(this.coord.x, this.coord.y, this.coord.z, this.id, this.meta, 0);
            for (int j = 0; j < this.size; ++j) {
                for (BlockCoord c : this.coord.getNearby()) {
                    if (this.canGenHere(this.world, c, true)) {
                        this.lining.add(c);
                    }
                    if (!this.canGenHere(this.world, c, false)) continue;
                    this.extra.add(c);
                }
                if (this.lining.isEmpty() && this.extra.isEmpty()) {
                    return true;
                }
                if (this.lining.isEmpty()) {
                    this.coord.set((BlockCoord)this.extra.get(this.rand.nextInt(this.extra.size())));
                    this.extra.remove(this.coord);
                } else if (this.extra.isEmpty()) {
                    this.coord.set((BlockCoord)this.lining.get(this.rand.nextInt(this.lining.size())));
                    this.lining.remove(this.coord);
                } else if (this.rand.nextInt(100) < this.adherence) {
                    this.coord.set((BlockCoord)this.lining.get(this.rand.nextInt(this.lining.size())));
                    this.lining.remove(this.coord);
                } else {
                    this.coord.set((BlockCoord)this.extra.get(this.rand.nextInt(this.extra.size())));
                    this.extra.remove(this.coord);
                }
                this.world.func_72832_d(this.coord.x, this.coord.y, this.coord.z, this.id, this.meta, 0);
            }
            return true;
        }
        return true;
    }

    private boolean canGenHere(World world, BlockCoord c, boolean strict) {
        if (c.getBlock(world) != null && this.replaced.contains(c.getBlockID(world))) {
            for (BlockCoord n : c.getNearby()) {
                if (n.getBlock(world) == null || !n.getBlock(world).func_71926_d()) {
                    return true;
                }
                if (strict || n.getBlock(world) == null || n.getBlockID(world) != this.id) continue;
                return true;
            }
        }
        return false;
    }
}

