/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeItems;
import shukaro.artifice.ArtificeTooltips;
import shukaro.artifice.compat.ArtificeRegistry;
import shukaro.artifice.gui.ArtificeCreativeTab;
import shukaro.artifice.util.FormatCodes;
import shukaro.artifice.util.IdMetaPair;

public class ItemBox
extends Item {
    private Icon icon;

    public ItemBox(int id) {
        super(id);
        this.func_77637_a(ArtificeCreativeTab.tab);
        this.func_77655_b("artifice.box");
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77617_a(int meta) {
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister reg) {
        this.icon = reg.func_94245_a("artifice:box");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77978_p() != null;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        NBTTagCompound tag = stack.func_77978_p();
        int num = 1;
        if (player.func_70093_af()) {
            num = stack.field_77994_a;
        }
        if (tag != null) {
            if (Block.field_71973_m[world.func_72798_a(x, y, z)] instanceof IDeepStorageUnit) {
                IDeepStorageUnit unit = (IDeepStorageUnit)Block.field_71973_m[world.func_72798_a(x, y, z)];
                ItemStack contained = unit.getStoredItemType();
                ItemStack boxed = new ItemStack(tag.func_74762_e("id"), tag.func_74762_e("size") * num, tag.func_74762_e("meta"));
                if (contained == null) {
                    unit.setStoredItemType(boxed.field_77993_c, boxed.func_77960_j(), boxed.field_77994_a);
                    stack.field_77994_a -= num;
                    return true;
                }
                if (tag.func_74775_l("nbt").func_82582_d() && contained.func_77969_a(boxed)) {
                    if (unit.getMaxStoredCount() < contained.field_77994_a + boxed.field_77994_a) {
                        return false;
                    }
                    unit.setStoredItemCount(contained.field_77994_a + boxed.field_77994_a);
                    stack.field_77994_a -= num;
                    return true;
                }
                return false;
            }
            this.func_77659_a(stack, world, player);
            return true;
        }
        if (Block.field_71973_m[world.func_72798_a(x, y, z)] instanceof IDeepStorageUnit) {
            ItemStack newStack;
            IDeepStorageUnit unit = (IDeepStorageUnit)Block.field_71973_m[world.func_72798_a(x, y, z)];
            ItemStack contained = unit.getStoredItemType();
            if (contained == null) {
                return false;
            }
            NBTTagCompound newTag = new NBTTagCompound();
            newTag.func_74768_a("meta", contained.func_77960_j());
            newTag.func_74768_a("id", contained.field_77993_c);
            boolean canFill = true;
            if (contained.field_77994_a > 8 * num) {
                newTag.func_74768_a("size", 8);
                unit.setStoredItemCount(contained.field_77994_a - 8 * num);
            } else if (contained.field_77994_a > 8) {
                newTag.func_74768_a("size", 8);
                unit.setStoredItemCount(contained.field_77994_a - 8);
                canFill = false;
            } else {
                newTag.func_74768_a("size", contained.field_77994_a);
                unit.setStoredItemCount(0);
                canFill = false;
            }
            if (!canFill) {
                newStack = new ItemStack(ArtificeItems.itemBox.field_77779_bT, 1, newTag.func_74762_e("size"));
                --stack.field_77994_a;
            } else {
                newStack = new ItemStack(ArtificeItems.itemBox.field_77779_bT, num, newTag.func_74762_e("size"));
                stack.field_77994_a -= num;
            }
            newStack.func_77982_d(newTag);
            if (!player.field_71071_by.func_70441_a(newStack) && !world.field_72995_K) {
                world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, newStack));
            }
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            ItemStack thing = new ItemStack(tag.func_74762_e("id"), stack.func_77960_j(), tag.func_74762_e("meta"));
            if (!tag.func_74775_l("nbt").func_82582_d()) {
                thing.func_77982_d(tag.func_74775_l("nbt"));
            }
            if (player.func_70093_af()) {
                int numCrafted = stack.field_77994_a * stack.func_77960_j();
                if (numCrafted > thing.func_77976_d()) {
                    ItemStack out;
                    for (int given = 0; given < numCrafted; given += out.field_77994_a) {
                        out = thing.func_77946_l();
                        out.field_77994_a = numCrafted - given > thing.func_77976_d() ? thing.func_77976_d() : numCrafted - given;
                        if (out == null || out.field_77994_a <= 0 || player.field_71071_by.func_70441_a(out) || player.field_70170_p.field_72995_K) continue;
                        player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, out));
                    }
                } else {
                    ItemStack out = thing.func_77946_l();
                    out.field_77994_a = numCrafted;
                    if (out != null && out.field_77994_a > 0 && !player.field_71071_by.func_70441_a(out) && !player.field_70170_p.field_72995_K) {
                        player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, out));
                    }
                }
                stack.field_77994_a = 0;
                return stack;
            }
            ItemStack extra = null;
            if (thing.field_77994_a > thing.func_77976_d() && stack.field_77994_a > 1) {
                extra = stack.func_77946_l();
                extra.field_77994_a = stack.field_77994_a - 1;
                stack.field_77994_a = 1;
                thing.field_77994_a = stack.func_77960_j();
            }
            ItemStack drop = null;
            if (thing.field_77994_a > thing.func_77976_d()) {
                drop = thing.func_77946_l();
                drop.field_77994_a = thing.func_77976_d();
                stack.func_77964_b(stack.func_77960_j() - drop.field_77994_a);
                if (stack.func_77960_j() < 1) {
                    --stack.field_77994_a;
                }
                if (drop != null && !player.field_71071_by.func_70441_a(drop) && !world.field_72995_K) {
                    world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, drop));
                }
            } else {
                drop = thing.func_77946_l();
                --stack.field_77994_a;
                if (drop != null && !player.field_71071_by.func_70441_a(drop) && !world.field_72995_K) {
                    world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, drop));
                }
            }
            if (extra != null && !player.field_71071_by.func_70441_a(extra) && !world.field_72995_K) {
                world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, extra));
            }
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List infoList, boolean advancedTooltips) {
        NBTTagCompound tag;
        if (ArtificeConfig.tooltips.getBoolean(true)) {
            IdMetaPair pair = new IdMetaPair(stack.field_77993_c, 0);
            if (ArtificeRegistry.getTooltipMap().get(pair) != null) {
                for (String s : (List)ArtificeRegistry.getTooltipMap().get(pair)) {
                    if (s.startsWith(ArtificeTooltips.commentCode)) continue;
                    infoList.add(s);
                }
            }
        }
        if ((tag = stack.func_77978_p()) != null) {
            NBTTagList enchants;
            infoList.add("Contains: " + FormatCodes.Aqua.format + new ItemStack(tag.func_74762_e("id"), 1, tag.func_74762_e("meta")).func_82833_r());
            infoList.add("Amount: " + FormatCodes.Aqua.format + stack.func_77960_j());
            NBTTagList nBTTagList = enchants = (NBTTagList)tag.func_74775_l("nbt").func_74781_a("ench") != null ? (NBTTagList)tag.func_74775_l("nbt").func_74781_a("ench") : (NBTTagList)tag.func_74775_l("nbt").func_74781_a("StoredEnchantments");
            if (enchants != null) {
                for (int i = 0; i < enchants.func_74745_c(); ++i) {
                    short id = ((NBTTagCompound)enchants.func_74743_b(i)).func_74765_d("id");
                    short lvl = ((NBTTagCompound)enchants.func_74743_b(i)).func_74765_d("lvl");
                    if (Enchantment.field_77331_b[id] == null) continue;
                    infoList.add(FormatCodes.Yellow.format + Enchantment.field_77331_b[id].func_77316_c((int)lvl));
                }
            }
        }
        if (ArtificeConfig.tooltips.getBoolean(true)) {
            IdMetaPair pair = new IdMetaPair(stack.field_77993_c, 0);
            if (ArtificeRegistry.getTooltipMap().get(pair) != null) {
                for (String s : (List)ArtificeRegistry.getTooltipMap().get(pair)) {
                    if (!ArtificeConfig.flavorText.getBoolean(true) || !s.startsWith(ArtificeTooltips.commentCode)) continue;
                    infoList.add(s);
                }
            }
        }
    }
}

