/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.block.frame;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.block.frame.BlockFrame;
import shukaro.artifice.render.IconHandler;
import shukaro.artifice.render.connectedtexture.ConnectedTexture;
import shukaro.artifice.render.connectedtexture.ConnectedTextureBase;
import shukaro.artifice.render.connectedtexture.IConnectedTexture;
import shukaro.artifice.render.connectedtexture.ILayeredRender;
import shukaro.artifice.render.connectedtexture.TransparentConnectedTexture;

public class BlockFrameGlassWall
extends BlockFrame
implements IConnectedTexture,
ILayeredRender {
    private Icon[] icons = new Icon[ArtificeCore.tiers.length];
    private ConnectedTextureBase basic = new TransparentConnectedTexture(ConnectedTexture.BasicFrame);
    private ConnectedTextureBase reinforced = new TransparentConnectedTexture(ConnectedTexture.ReinforcedFrame);
    private ConnectedTextureBase industrial = new TransparentConnectedTexture(ConnectedTexture.IndustrialFrame);
    private ConnectedTextureBase advanced = new TransparentConnectedTexture(ConnectedTexture.AdvancedFrame);

    public BlockFrameGlassWall(int id) {
        super(id);
        this.func_71864_b("artifice.glasswall");
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int meta = world.func_72805_g(x, y, z);
        return this.getResistance(meta);
    }

    public float getResistance(int meta) {
        switch (meta) {
            case 0: {
                return 15.0f;
            }
            case 1: {
                return 25.0f;
            }
            case 2: {
                return 45.0f;
            }
            case 3: {
                return 75.0f;
            }
        }
        return 10.0f;
    }

    @Override
    public boolean func_71926_d() {
        return false;
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    @Override
    public Icon getRenderIcon(int side, int meta) {
        return this.icons[meta];
    }

    @Override
    public ConnectedTexture getTextureType(int side, int meta) {
        switch (meta) {
            case 0: {
                return ConnectedTexture.BasicFrame;
            }
            case 1: {
                return ConnectedTexture.ReinforcedFrame;
            }
            case 2: {
                return ConnectedTexture.IndustrialFrame;
            }
            case 3: {
                return ConnectedTexture.AdvancedFrame;
            }
        }
        return null;
    }

    @Override
    public ConnectedTextureBase getTextureRenderer(int side, int meta) {
        switch (meta) {
            case 0: {
                return this.basic;
            }
            case 1: {
                return this.reinforced;
            }
            case 2: {
                return this.industrial;
            }
            case 3: {
                return this.advanced;
            }
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister reg) {
        if (!ConnectedTexture.BasicFrame.isRegistered) {
            IconHandler.registerConnectedTexture(reg, ConnectedTexture.BasicFrame, "frame/basic");
        }
        if (!ConnectedTexture.ReinforcedFrame.isRegistered) {
            IconHandler.registerConnectedTexture(reg, ConnectedTexture.ReinforcedFrame, "frame/reinforced");
        }
        if (!ConnectedTexture.IndustrialFrame.isRegistered) {
            IconHandler.registerConnectedTexture(reg, ConnectedTexture.IndustrialFrame, "frame/industrial");
        }
        if (!ConnectedTexture.AdvancedFrame.isRegistered) {
            IconHandler.registerConnectedTexture(reg, ConnectedTexture.AdvancedFrame, "frame/advanced");
        }
        for (int i = 0; i < ArtificeCore.tiers.length; ++i) {
            this.icons[i] = IconHandler.registerSingle(reg, ArtificeCore.tiers[i].toLowerCase(), "glasswall");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        return this.getTextureType((int)side, (int)meta).textureList[0];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess block, int x, int y, int z, int side) {
        return this.getTextureType((int)side, (int)block.func_72805_g((int)x, (int)y, (int)z)).textureList[this.getTextureRenderer(side, block.func_72805_g(x, y, z)).getTextureIndex(block, x, y, z, side)];
    }

    @Override
    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return false;
    }
}

