/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.block.decorative;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.block.BlockArtifice;
import shukaro.artifice.gui.ArtificeCreativeTab;
import shukaro.artifice.render.IconHandler;
import shukaro.artifice.render.connectedtexture.ConnectedTexture;
import shukaro.artifice.render.connectedtexture.ConnectedTextureBase;
import shukaro.artifice.render.connectedtexture.IConnectedTexture;
import shukaro.artifice.render.connectedtexture.SolidConnectedTexture;

public class BlockMarble
extends BlockArtifice
implements IConnectedTexture {
    private Icon[] icons = new Icon[ArtificeCore.rocks.length];
    private ConnectedTextureBase paver = new SolidConnectedTexture(ConnectedTexture.MarblePaver);
    private ConnectedTextureBase antipaver = new SolidConnectedTexture(ConnectedTexture.MarbleAntipaver);

    public BlockMarble(int id) {
        super(id, Material.field_76246_e);
        this.func_71849_a(ArtificeCreativeTab.tab);
        this.func_71848_c(1.5f);
        this.func_71894_b(10.0f);
        this.func_71864_b("artifice.marble");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int i, CreativeTabs tabs, List list) {
        for (int j = 0; j < ArtificeCore.rocks.length; ++j) {
            list.add(new ItemStack(i, 1, j));
        }
    }

    @Override
    public int func_71899_b(int meta) {
        return meta == 0 ? 1 : meta;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister reg) {
        if (!ConnectedTexture.MarblePaver.isRegistered) {
            IconHandler.registerConnectedTexture(reg, ConnectedTexture.MarblePaver, "marble/paver");
        }
        this.icons[0] = IconHandler.registerSingle(reg, "marble", "marble");
        this.icons[1] = IconHandler.registerSingle(reg, "cobblestone", "marble");
        this.icons[2] = IconHandler.registerSingle(reg, "bricks", "marble");
        this.icons[5] = IconHandler.registerSingle(reg, "chiseled", "marble");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        if (meta >= ArtificeCore.rocks.length) {
            meta = 0;
        }
        if (meta == 3 || meta == 4) {
            return this.getTextureType((int)side, (int)meta).textureList[0];
        }
        return this.icons[meta];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess block, int x, int y, int z, int side) {
        int meta = block.func_72805_g(x, y, z);
        if (meta > ArtificeCore.rocks.length) {
            meta = 0;
        }
        if (meta == 3 || meta == 4) {
            return this.getTextureType((int)side, (int)meta).textureList[this.getTextureRenderer(side, meta).getTextureIndex(block, x, y, z, side)];
        }
        return this.icons[meta];
    }

    @Override
    public ConnectedTexture getTextureType(int side, int meta) {
        if (meta == 3) {
            return ConnectedTexture.MarblePaver;
        }
        if (meta == 4) {
            return ConnectedTexture.MarbleAntipaver;
        }
        return null;
    }

    @Override
    public ConnectedTextureBase getTextureRenderer(int side, int meta) {
        if (meta == 3) {
            return this.paver;
        }
        if (meta == 4) {
            return this.antipaver;
        }
        return null;
    }
}

