/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.DefaultOverlayRenderer;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.forge.IContainerInputHandler;
import codechicken.nei.forge.IContainerTooltipHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.RecipeInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.lwjgl.opengl.GL11;

public abstract class TemplateRecipeHandler
implements ICraftingHandler,
IUsageHandler {
    public int cycleticks = Math.abs((int)System.currentTimeMillis());
    public ArrayList arecipes = new ArrayList();
    public LinkedList transferRects = new LinkedList();

    static {
        GuiContainerManager.addInputHandler(new RecipeTransferRectHandler());
        GuiContainerManager.addTooltipHandler(new RecipeTransferRectHandler());
    }

    public TemplateRecipeHandler() {
        this.loadTransferRects();
        RecipeTransferRectHandler.registerRectsToGuis(this.getRecipeTransferRectGuis(), this.transferRects);
    }

    public void loadTransferRects() {
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("item")) {
            this.loadCraftingRecipes((wm)results[0]);
        }
    }

    public void loadCraftingRecipes(wm result) {
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("item")) {
            this.loadUsageRecipes((wm)ingredients[0]);
        }
    }

    public void loadUsageRecipes(wm ingredient) {
    }

    public abstract String getGuiTexture();

    public String getOverlayIdentifier() {
        return null;
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
    }

    public void drawProgressBar(GuiContainerManager gui, int x, int y, int tx, int ty, int w, int h, int ticks, int direction) {
        this.drawProgressBar(gui, x, y, tx, ty, w, h, (float)(this.cycleticks % ticks) / (float)ticks, direction);
    }

    public void drawProgressBar(GuiContainerManager gui, int x, int y, int tx, int ty, int w, int h, float completion, int direction) {
        if (direction > 3) {
            completion = 1.0f - completion;
            direction %= 4;
        }
        int var = (int)(completion * (float)(direction % 2 == 0 ? w : h));
        switch (direction) {
            case 0: {
                gui.drawTexturedModalRect(x, y, tx, ty, var, h);
                break;
            }
            case 1: {
                gui.drawTexturedModalRect(x, y, tx, ty, w, var);
                break;
            }
            case 2: {
                gui.drawTexturedModalRect(x + w - var, y, tx + w - var, ty, var, h);
                break;
            }
            case 3: {
                gui.drawTexturedModalRect(x, y + h - var, tx, ty + h - var, w, var);
            }
        }
    }

    public List getRecipeTransferRectGuis() {
        Class clazz = this.getGuiClass();
        if (clazz != null) {
            LinkedList<Class> list = new LinkedList<Class>();
            list.add(clazz);
            return list;
        }
        return null;
    }

    public Class getGuiClass() {
        return null;
    }

    public TemplateRecipeHandler newInstance() {
        try {
            return (TemplateRecipeHandler)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ICraftingHandler getRecipeHandler(String outputId, Object ... results) {
        TemplateRecipeHandler handler = this.newInstance();
        handler.loadCraftingRecipes(outputId, results);
        return handler;
    }

    @Override
    public IUsageHandler getUsageHandler(String inputId, Object ... ingredients) {
        TemplateRecipeHandler handler = this.newInstance();
        handler.loadUsageRecipes(inputId, ingredients);
        return handler;
    }

    @Override
    public int numRecipes() {
        return this.arecipes.size();
    }

    @Override
    public void drawBackground(GuiContainerManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.bindTexture(this.getGuiTexture());
        gui.drawTexturedModalRect(0, 0, 5, 11, 166, 65);
    }

    @Override
    public void drawForeground(GuiContainerManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        gui.bindTexture(this.getGuiTexture());
        this.drawExtras(gui, recipe);
    }

    @Override
    public ArrayList getIngredientStacks(int recipe) {
        return ((CachedRecipe)this.arecipes.get(recipe)).getIngredients();
    }

    @Override
    public PositionedStack getResultStack(int recipe) {
        return ((CachedRecipe)this.arecipes.get(recipe)).getResult();
    }

    @Override
    public ArrayList getOtherStacks(int recipe) {
        return ((CachedRecipe)this.arecipes.get(recipe)).getOtherStacks();
    }

    @Override
    public void onUpdate() {
        if (!NEIClientUtils.shiftKey()) {
            ++this.cycleticks;
        }
    }

    @Override
    public boolean hasOverlay(ayl gui, tj container, int recipe) {
        return RecipeInfo.hasDefaultOverlay(gui, this.getOverlayIdentifier()) || RecipeInfo.hasOverlayHandler(gui, this.getOverlayIdentifier());
    }

    @Override
    public IRecipeOverlayRenderer getOverlayRenderer(ayl gui, int recipe) {
        IStackPositioner positioner = RecipeInfo.getStackPositioner(gui, this.getOverlayIdentifier());
        if (positioner == null) {
            return null;
        }
        return new DefaultOverlayRenderer(this.getIngredientStacks(recipe), positioner);
    }

    @Override
    public IOverlayHandler getOverlayHandler(ayl gui, int recipe) {
        return RecipeInfo.getOverlayHandler(gui, this.getOverlayIdentifier());
    }

    @Override
    public int recipiesPerPage() {
        return 2;
    }

    @Override
    public List handleTooltip(GuiRecipe gui, List currenttip, int recipe) {
        if (gui.manager.shouldShowTooltip() && currenttip.size() == 0) {
            Point offset = gui.getRecipePosition(recipe);
            currenttip = TemplateRecipeHandler.transferRectTooltip(gui, this.transferRects, offset.x, offset.y, currenttip);
        }
        return currenttip;
    }

    @Override
    public List handleItemTooltip(GuiRecipe gui, wm stack, List currenttip, int recipe) {
        return currenttip;
    }

    @Override
    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        if (keyCode == NEIClientConfig.getKeyBinding("recipe")) {
            return this.transferRect(gui, recipe, false);
        }
        if (keyCode == NEIClientConfig.getKeyBinding("usage")) {
            return this.transferRect(gui, recipe, true);
        }
        return false;
    }

    @Override
    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        if (button == 0) {
            return this.transferRect(gui, recipe, false);
        }
        if (button == 1) {
            return this.transferRect(gui, recipe, true);
        }
        return false;
    }

    private boolean transferRect(GuiRecipe gui, int recipe, boolean usage) {
        Point offset = gui.getRecipePosition(recipe);
        return TemplateRecipeHandler.transferRect(gui, this.transferRects, offset.x, offset.y, usage);
    }

    private static boolean transferRect(ayl gui, Collection transferRects, int offsetx, int offsety, boolean usage) {
        Point pos = gui.manager.getMousePosition();
        Point relMouse = new Point(pos.x - gui.e - offsetx, pos.y - gui.o - offsety);
        for (RecipeTransferRect rect : transferRects) {
            if (!rect.rect.contains(relMouse) || !(usage ? GuiUsageRecipe.openRecipeGui(rect.outputId, rect.results) : GuiCraftingRecipe.openRecipeGui(rect.outputId, rect.results))) continue;
            return true;
        }
        return false;
    }

    private static List transferRectTooltip(ayl gui, Collection transferRects, int offsetx, int offsety, List currenttip) {
        Point pos = gui.manager.getMousePosition();
        Point relMouse = new Point(pos.x - gui.e - offsetx, pos.y - gui.o - offsety);
        for (RecipeTransferRect rect : transferRects) {
            if (!rect.rect.contains(relMouse)) continue;
            currenttip.add("Recipes");
            break;
        }
        return currenttip;
    }

    public abstract class CachedRecipe {
        final long offset = System.currentTimeMillis();

        public abstract PositionedStack getResult();

        public ArrayList getIngredients() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            PositionedStack stack = this.getIngredient();
            if (stack != null) {
                stacks.add(stack);
            }
            return stacks;
        }

        public PositionedStack getIngredient() {
            return null;
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            PositionedStack stack = this.getOtherStack();
            if (stack != null) {
                stacks.add(stack);
            }
            return stacks;
        }

        public PositionedStack getOtherStack() {
            return null;
        }

        public ArrayList getCycledIngredients(int cycle, ArrayList ingredients) {
            int itemIndex = 0;
            while (itemIndex < ingredients.size()) {
                PositionedStack stack = (PositionedStack)ingredients.get(itemIndex);
                Random rand = new Random((long)(cycle + itemIndex) + this.offset);
                stack.setPermutationToRender(Math.abs(rand.nextInt()) % stack.items.length);
                ++itemIndex;
            }
            return ingredients;
        }

        public void setIngredientPermutation(Collection ingredients, wm ingredient) {
            block0: for (PositionedStack stack : ingredients) {
                int i = 0;
                while (i < stack.items.length) {
                    if (NEIServerUtils.areStacksSameTypeCrafting(ingredient, stack.items[i])) {
                        stack.item = stack.items[i];
                        stack.item.b(ingredient.k());
                        stack.items = new wm[]{stack.item};
                        stack.setPermutationToRender(0);
                        continue block0;
                    }
                    ++i;
                }
            }
        }

        public boolean contains(Collection ingredients, wm ingredient) {
            for (PositionedStack stack : ingredients) {
                wm[] wmArray = stack.items;
                int n = stack.items.length;
                int n2 = 0;
                while (n2 < n) {
                    wm item = wmArray[n2];
                    if (NEIServerUtils.areStacksSameTypeCrafting(item, ingredient)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }

    public static class RecipeTransferRect {
        Rectangle rect;
        String outputId;
        Object[] results;

        @Deprecated
        public RecipeTransferRect(TemplateRecipeHandler handler, Rectangle rectangle, String outputId, Object ... results) {
            this(rectangle, outputId, results);
        }

        public RecipeTransferRect(Rectangle rectangle, String outputId, Object ... results) {
            this.rect = rectangle;
            this.outputId = outputId;
            this.results = results;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RecipeTransferRect)) {
                return false;
            }
            return this.rect.equals(((RecipeTransferRect)obj).rect);
        }

        public int hashCode() {
            return this.rect.hashCode();
        }
    }

    public static class RecipeTransferRectHandler
    implements IContainerInputHandler,
    IContainerTooltipHandler {
        private static HashMap guiMap = new HashMap();

        public static void registerRectsToGuis(List classes, List rects) {
            if (classes == null) {
                return;
            }
            for (Class clazz : classes) {
                HashSet set = (HashSet)guiMap.get(clazz);
                if (set == null) {
                    set = new HashSet();
                    guiMap.put(clazz, set);
                }
                set.addAll(rects);
            }
        }

        public boolean canHandle(ayl gui) {
            return guiMap.containsKey(((Object)((Object)gui)).getClass());
        }

        @Override
        public boolean lastKeyTyped(ayl gui, char keyChar, int keyCode) {
            if (!this.canHandle(gui)) {
                return false;
            }
            if (keyCode == NEIClientConfig.getKeyBinding("recipe")) {
                return this.transferRect(gui, false);
            }
            if (keyCode == NEIClientConfig.getKeyBinding("usage")) {
                return this.transferRect(gui, true);
            }
            return false;
        }

        @Override
        public boolean mouseClicked(ayl gui, int mousex, int mousey, int button) {
            if (!this.canHandle(gui)) {
                return false;
            }
            if (button == 0) {
                return this.transferRect(gui, false);
            }
            if (button == 1) {
                return this.transferRect(gui, true);
            }
            return false;
        }

        private boolean transferRect(ayl gui, boolean usage) {
            int[] offset = RecipeInfo.getGuiOffset(gui);
            return TemplateRecipeHandler.transferRect(gui, (Collection)RecipeTransferRectHandler.guiMap.get(((Object)((Object)gui)).getClass()), offset[0], offset[1], usage);
        }

        @Override
        public void onKeyTyped(ayl gui, char keyChar, int keyID) {
        }

        @Override
        public void onMouseClicked(ayl gui, int mousex, int mousey, int button) {
        }

        @Override
        public void onMouseUp(ayl gui, int mousex, int mousey, int button) {
        }

        @Override
        public boolean keyTyped(ayl gui, char keyChar, int keyID) {
            return false;
        }

        @Override
        public boolean mouseScrolled(ayl gui, int mousex, int mousey, int scrolled) {
            return false;
        }

        @Override
        public void onMouseScrolled(ayl gui, int mousex, int mousey, int scrolled) {
        }

        @Override
        public List handleTooltipFirst(ayl gui, int mousex, int mousey, List currenttip) {
            if (!this.canHandle(gui)) {
                return currenttip;
            }
            if (gui.manager.shouldShowTooltip() && currenttip.size() == 0) {
                int[] offset = RecipeInfo.getGuiOffset(gui);
                currenttip = TemplateRecipeHandler.transferRectTooltip(gui, (Collection)RecipeTransferRectHandler.guiMap.get(((Object)((Object)gui)).getClass()), offset[0], offset[1], currenttip);
            }
            return currenttip;
        }

        @Override
        public List handleItemTooltip(ayl gui, wm itemstack, List currenttip) {
            return currenttip;
        }

        @Override
        public void onMouseDragged(ayl gui, int mousex, int mousey, int button, long heldTime) {
        }
    }
}

