/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.ASMHelper;
import codechicken.core.asm.CodeChickenCorePlugin;
import codechicken.core.asm.InterfaceDependancies;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import cpw.mods.fml.relauncher.IClassTransformer;
import java.util.Iterator;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public class InterfaceDependancyTransformer
implements IClassTransformer {
    public byte[] transform(String name, String tname, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ClassNode cnode = ASMHelper.createClassNode(bytes);
        boolean hasDependancyInterfaces = false;
        if (cnode.visibleAnnotations != null) {
            for (AnnotationNode ann : cnode.visibleAnnotations) {
                if (!ann.desc.equals(Type.getDescriptor(InterfaceDependancies.class))) continue;
                hasDependancyInterfaces = true;
                break;
            }
        }
        if (!hasDependancyInterfaces) {
            return bytes;
        }
        hasDependancyInterfaces = false;
        Iterator iterator = cnode.interfaces.iterator();
        while (iterator.hasNext()) {
            try {
                String s = (String)iterator.next();
                s = FMLDeobfuscatingRemapper.INSTANCE.map(s);
                CodeChickenCorePlugin.cl.findClass(s.replace('/', '.'));
            }
            catch (ClassNotFoundException cnfe) {
                iterator.remove();
                hasDependancyInterfaces = true;
            }
        }
        if (!hasDependancyInterfaces) {
            return bytes;
        }
        return ASMHelper.createBytes(cnode, 0);
    }
}

